/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2cp;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.i2p.data.DataFormatException;
import net.i2p.data.Lease;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.data.i2cp.I2CPMessageImpl;
import net.i2p.data.i2cp.SessionId;
import net.i2p.util.ByteArrayStream;
import net.i2p.util.VersionComparator;

public class RequestVariableLeaseSetMessage
extends I2CPMessageImpl {
    public static final int MESSAGE_TYPE = 37;
    private SessionId _sessionId;
    private final List<Lease> _endpoints = new ArrayList<Lease>(6);
    private static final String MIN_VERSION = "0.9.7";

    public static boolean isSupported(String clientVersion) {
        return clientVersion != null && VersionComparator.comp(clientVersion, MIN_VERSION) >= 0;
    }

    public SessionId getSessionId() {
        return this._sessionId;
    }

    @Override
    public SessionId sessionId() {
        return this._sessionId;
    }

    public void setSessionId(SessionId id) {
        this._sessionId = id;
    }

    public int getEndpoints() {
        return this._endpoints.size();
    }

    public Lease getEndpoint(int endpoint) {
        if (endpoint < 0 || this._endpoints.size() <= endpoint) {
            return null;
        }
        return this._endpoints.get(endpoint);
    }

    public void addEndpoint(Lease lease) {
        if (lease == null) {
            throw new IllegalArgumentException();
        }
        this._endpoints.add(lease);
    }

    @Override
    protected void doReadMessage(InputStream in, int size) throws I2CPMessageException, IOException {
        try {
            if (this._sessionId != null) {
                throw new IllegalStateException();
            }
            this._sessionId = new SessionId();
            this._sessionId.readBytes(in);
            int numTunnels = in.read();
            if (numTunnels < 0) {
                throw new EOFException();
            }
            for (int i = 0; i < numTunnels; ++i) {
                Lease lease = new Lease();
                lease.readBytes(in);
                this._endpoints.add(lease);
            }
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Unable to load the message data", dfe);
        }
    }

    @Override
    protected byte[] doWriteMessage() throws I2CPMessageException, IOException {
        if (this._sessionId == null) {
            throw new I2CPMessageException("No data");
        }
        int len = 3 + this._endpoints.size() * 44;
        ByteArrayStream os = new ByteArrayStream(len);
        try {
            this._sessionId.writeBytes(os);
            os.write((byte)this._endpoints.size());
            for (int i = 0; i < this._endpoints.size(); ++i) {
                this._endpoints.get(i).writeBytes(os);
            }
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Error writing out the message data", dfe);
        }
        return os.toByteArray();
    }

    @Override
    public int getType() {
        return 37;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getSessionId());
        buf.append(" RequestVariableLeaseSetMessage ");
        for (int i = 0; i < this.getEndpoints(); ++i) {
            buf.append(this._endpoints.get(i));
        }
        return buf.toString();
    }
}

