/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.servlet;

import java.io.IOException;
import java.text.Collator;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.i2p.data.DataHelper;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;

public class I2PDefaultServlet
extends DefaultServlet {
    private ContextHandler _contextHandler;
    private boolean _dirAllowed = true;
    private boolean _etags = true;
    private Resource _resourceBase;
    private Resource _stylesheet;
    private static final String FORMAT = "dd MMM yyyy HH:mm";
    private static final String LAST_MODIFIED_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private boolean setLastModifiedHeader = true;

    @Override
    public void init() throws UnavailableException {
        super.init();
        this._dirAllowed = this.getInitBoolean("dirAllowed", this._dirAllowed);
        this._etags = this.getInitBoolean("etags", this._etags);
        String rb = this.getInitParameter("resourceBase");
        if (rb != null) {
            try {
                this._resourceBase = this._contextHandler.newResource(rb);
            }
            catch (Exception e) {
                throw new UnavailableException(e.toString());
            }
        }
        String css = this.getInitParameter("stylesheet");
        try {
            if (css != null) {
                this._stylesheet = Resource.newResource(css);
                if (!this._stylesheet.exists()) {
                    this._stylesheet = null;
                }
            }
            if (this._stylesheet == null) {
                this._stylesheet = Resource.newResource(this.getClass().getResource("/jetty-dir.css"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String setLastModifiedHeaderParam = this.getInitParameter("setLastModifiedHeader");
        if (setLastModifiedHeaderParam != null && setLastModifiedHeaderParam.equalsIgnoreCase("false")) {
            this.setLastModifiedHeader = false;
        }
    }

    @Override
    protected ContextHandler initContextHandler(ServletContext servletContext) {
        ContextHandler rv;
        this._contextHandler = rv = super.initContextHandler(servletContext);
        ErrorPageErrorHandler errorHandler = new ErrorPageErrorHandler();
        errorHandler.addErrorPage(403, "/.resources/403.html");
        errorHandler.addErrorPage(404, "/.resources/404.html");
        rv.setErrorHandler(errorHandler);
        return rv;
    }

    private boolean getInitBoolean(String name, boolean dft) {
        String value = this.getInitParameter(name);
        if (value == null || value.length() == 0) {
            return dft;
        }
        return value.startsWith("t") || value.startsWith("T") || value.startsWith("y") || value.startsWith("Y") || value.startsWith("1");
    }

    @Override
    protected void sendDirectory(HttpServletRequest request, HttpServletResponse response, Resource resource, String pathInContext) throws IOException {
        String dir;
        if (!this._dirAllowed) {
            response.sendError(403);
            return;
        }
        byte[] data = null;
        String base = URIUtil.addPaths(request.getRequestURI(), "/");
        if (this._resourceBase != null) {
            if (this._resourceBase instanceof ResourceCollection) {
                resource = this._resourceBase.addPath(pathInContext);
            }
        } else if (this._contextHandler.getBaseResource() instanceof ResourceCollection) {
            resource = this._contextHandler.getBaseResource().addPath(pathInContext);
        }
        if ((dir = I2PDefaultServlet.getListHTML(resource, base, pathInContext.length() > 1)) == null) {
            response.sendError(403, "No directory");
            return;
        }
        data = dir.getBytes("UTF-8");
        response.setContentType("text/html; charset=UTF-8");
        response.setContentLength(data.length);
        response.getOutputStream().write(data);
    }

    private static String getListHTML(Resource res, String base, boolean parent) throws IOException {
        if ((base = URIUtil.canonicalPath(base)) == null || !res.isDirectory()) {
            return null;
        }
        String[] ls = res.list();
        if (ls == null) {
            return null;
        }
        DataHelper.sort(ls, new FileComparator(res));
        String decodedBase = URIUtil.decodePath(base);
        String title = "Directory: " + I2PDefaultServlet.deTag(decodedBase);
        String pwd = "Directory: <a href=\"" + I2PDefaultServlet.deTag(decodedBase) + "\">" + I2PDefaultServlet.deTag(decodedBase) + "</a>";
        String inlineCSS = "<style>\n#dirlist {margin: 2.5%; padding: 0; font-family: Open Sans, Ubuntu, SegoeUI, sans-serif; font-size: 11pt; color: #333; border: 1px solid #ddd; background: #999}\ntable {border-collapse: collapse}\nb, th {font-weight: 700; font-size: 90%}\ntr:nth-child(odd) {background: #eee}\ntr:nth-child(even) {background: #ddd}\ntr:hover {background: #ffd}\n#dirlist th, #dirlist td {padding: 4px 8px}\n#dirlist th {border-bottom: 1px solid #ddd; background: #fff}\n#dirlist td:nth-child(n+2) {font-size: 90%}\nh1 {margin: -1px -1px 0; padding: 5px 8px; font-size: 14pt; background: #f2f2f2; border: 1px solid #ddd}\n#dirlist a {text-decoration: none; outline: none; color: #b33}\n#dirlist td a {width: 100%; display: inline-block; font-weight: 600}\n#dirlist a:visited {color: #700}\n#dirlist a:hover, #dirlist a:focus {color: #d30}\n</style>\n";
        String tableHeader = "<table border=0 width=100% class=listing>\n<thead>\n<tr><th align=left class=name><b>Name</b></th><th align=right nowrap class=lastmodified><b>Last modified (UTC)</b></th><th align=right nowrap class=size><b>Size (bytes)</b></th></tr>\n</thead>\n<tbody>\n";
        StringBuilder buf = new StringBuilder(4096);
        buf.append("<!DOCTYPE HTML>\n<html>\n<head>\n<title>");
        buf.append(title);
        buf.append("</title>\n<meta charset=utf-8>\n");
        buf.append(inlineCSS);
        buf.append("<link href=/.resources/jetty-dir.css rel=stylesheet>\n").append("</head>\n<body id=dirlist>\n<h1>").append(pwd).append("</h1>\n").append(tableHeader);
        if (parent) {
            buf.append("<tr><td class=name><a href=\"");
            buf.append(URIUtil.addPaths(base, "../"));
            buf.append("\">Parent Directory</a></td><td class=lastmodified></td><td class=size></td></tr>\n");
        }
        String encodedBase = I2PDefaultServlet.hrefEncodeURI(base);
        SimpleDateFormat dfmt = new SimpleDateFormat(FORMAT, Locale.UK);
        TimeZone utc = TimeZone.getTimeZone("GMT");
        dfmt.setTimeZone(utc);
        for (int i = 0; i < ls.length; ++i) {
            Resource item;
            try {
                item = res.addPath(ls[i]);
            }
            catch (IOException ioe) {
                System.out.println("Skipping file in directory listing: " + ioe.getMessage());
                continue;
            }
            catch (RuntimeException re) {
                System.out.println("Skipping file in directory listing: " + re.getMessage());
                continue;
            }
            if (ls[i].startsWith(".") || ls[i].equals("jetty-dir.css") || ls[i].equals("favicon.ico") || ls[i].equals("favicon.svg") || ls[i].equals("favicon.png") || ls[i].endsWith("~") || ls[i].endsWith("_") || ls[i].endsWith(".bak") || ls[i].endsWith(".backup") || ls[i].endsWith(".orig") || ls[i].endsWith(".old") || ls[i].endsWith("_files/")) continue;
            buf.append("<tr><td class=name><a href=\"");
            String path = URIUtil.addPaths(encodedBase, URIUtil.encodePath(ls[i]));
            buf.append(path);
            boolean isDir = item.isDirectory();
            if (isDir && !path.endsWith("/")) {
                buf.append("/");
            }
            buf.append("\">");
            buf.append(I2PDefaultServlet.deTag(ls[i]));
            buf.append("</a></td><td width=1% nowrap class=lastmodified>");
            buf.append(dfmt.format(new Date(item.lastModified())));
            buf.append("</td><td width=1% align=right class=size>");
            if (!isDir) {
                buf.append(item.length());
            }
            buf.append("</td></tr>\n");
        }
        buf.append("</tbody>\n</table>\n");
        buf.append("</body>\n</html>\n");
        return buf.toString();
    }

    private static String hrefEncodeURI(String raw) {
        char c;
        int i;
        StringBuffer buf = null;
        block9: for (i = 0; i < raw.length(); ++i) {
            c = raw.charAt(i);
            switch (c) {
                case '\"': 
                case '\'': 
                case '<': 
                case '>': {
                    buf = new StringBuffer(raw.length() << 1);
                    break block9;
                }
                default: {
                    continue block9;
                }
            }
        }
        if (buf == null) {
            return raw;
        }
        block10: for (i = 0; i < raw.length(); ++i) {
            c = raw.charAt(i);
            switch (c) {
                case '\"': {
                    buf.append("%22");
                    continue block10;
                }
                case '\'': {
                    buf.append("%27");
                    continue block10;
                }
                case '<': {
                    buf.append("%3C");
                    continue block10;
                }
                case '>': {
                    buf.append("%3E");
                    continue block10;
                }
                default: {
                    buf.append(c);
                    continue block10;
                }
            }
        }
        return buf.toString();
    }

    private static String deTag(String raw) {
        return StringUtil.sanitizeXmlString(raw);
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String resourcePath = request.getRequestURI().substring(request.getContextPath().length());
        Resource resource = this.getResource(resourcePath);
        if (resource == null) {
            response.sendError(404);
            return;
        }
        long lastModified = resource.lastModified();
        if (lastModified > 0L) {
            SimpleDateFormat sdf = new SimpleDateFormat(LAST_MODIFIED_FORMAT, Locale.US);
            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
            response.setHeader("Last-Modified", sdf.format(new Date(lastModified)));
        }
        super.doGet(request, response);
    }

    @Override
    public Resource getResource(String path) {
        Resource resource = super.getResource(path);
        if (resource != null || !"true".equals(this.getInitParameter("aliases"))) {
            return resource;
        }
        int dotIndex = path.lastIndexOf(".");
        if (dotIndex != -1) {
            String[] aliases;
            String pathWithoutExtension = path.substring(0, dotIndex);
            for (String alias : aliases = new String[]{pathWithoutExtension + ".gif", pathWithoutExtension + ".htm", pathWithoutExtension + ".jpeg", pathWithoutExtension + ".jpg", pathWithoutExtension + ".php", pathWithoutExtension + ".png", pathWithoutExtension + ".shtml", pathWithoutExtension + ".webp", pathWithoutExtension + ".xhtml"}) {
                resource = super.getResource(alias);
                if (resource == null) continue;
                return resource;
            }
        }
        return null;
    }

    private static class FileComparator
    implements Comparator<String> {
        private final Comparator<Object> _coll;
        private final Resource _base;

        public FileComparator(Resource base) {
            this._base = base;
            this._coll = Collator.getInstance(Locale.US);
        }

        @Override
        public int compare(String a, String b) {
            try {
                Resource ra = this._base.addPath(a);
                Resource rb = this._base.addPath(b);
                boolean da = ra.isDirectory();
                boolean db = rb.isDirectory();
                if (da && !db) {
                    return -1;
                }
                if (!da && db) {
                    return 1;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this._coll.compare(a, b);
        }
    }
}

