/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.servlet.filters;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.PrivateKeyFile;
import net.i2p.util.FileSuffixFilter;
import net.i2p.util.Log;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;

public class XI2PLocationFilter
extends HandlerWrapper {
    private static final String PROP_ENABLE_LOCATION_HEADER = "i2p.tunnel.webserverLocationHeader";
    private String X_I2P_Location = null;
    private long lastFailure = -1L;
    private static final long failTimeout = 600000L;
    private static final String encodeUTF = StandardCharsets.UTF_8.toString();
    private final Log _log = I2PAppContext.getGlobalContext().logManager().getLog(XI2PLocationFilter.class);

    private synchronized void setLocation(String xi2plocation) {
        if (this._log.shouldInfo()) {
            this._log.info("Checking X-I2P-Location header prefix: " + xi2plocation);
        }
        if (this.X_I2P_Location != null) {
            return;
        }
        if (xi2plocation == null) {
            return;
        }
        if (xi2plocation.equals("")) {
            return;
        }
        this.X_I2P_Location = xi2plocation;
        if (this._log.shouldInfo()) {
            this._log.info("Caching X-I2P-Location header prefix: " + this.X_I2P_Location);
        }
    }

    private synchronized boolean shouldRecheck() {
        boolean settable;
        boolean bl = settable = this.X_I2P_Location == null;
        if (!settable) {
            return settable;
        }
        if (this.lastFailure == -1L) {
            this.lastFailure = System.currentTimeMillis();
            if (this._log.shouldDebug()) {
                this._log.debug("New instance, attempting to set X-I2P-Location header for the first time...");
            }
            return settable;
        }
        if (System.currentTimeMillis() - this.lastFailure > 600000L) {
            this.lastFailure = System.currentTimeMillis();
            if (this._log.shouldDebug()) {
                this._log.debug("Attempt to re-check X-I2P-Location header failed (10min timeout reached)");
            }
            return settable;
        }
        if (this._log.shouldDebug()) {
            this._log.debug("Not attempting to re-check X-I2P-Location header");
        }
        return false;
    }

    private synchronized String getXI2PLocation(String host, String port) {
        boolean shouldConfigure = I2PAppContext.getGlobalContext().getBooleanProperty(PROP_ENABLE_LOCATION_HEADER);
        File configDir = I2PAppContext.getGlobalContext().getConfigDir();
        File tunnelConfig = new File(configDir, "i2ptunnel.config");
        boolean isSingleFile = tunnelConfig.exists();
        if (!isSingleFile && shouldConfigure) {
            File tunnelConfigD = new File(configDir, "i2ptunnel.config.d");
            File[] configFiles = tunnelConfigD.listFiles(new FileSuffixFilter(".config"));
            if (configFiles == null) {
                return null;
            }
            for (int fnum = 0; fnum < configFiles.length; ++fnum) {
                Properties tunnelProps = new Properties();
                try {
                    boolean hostmatch;
                    DataHelper.loadProps(tunnelProps, configFiles[fnum]);
                    String targetHost = tunnelProps.getProperty("targetHost");
                    boolean bl = hostmatch = host.equals(targetHost) || "0.0.0.0".equals(targetHost) || "::".equals(targetHost);
                    if (!hostmatch || !port.equals(tunnelProps.getProperty("targetPort"))) continue;
                    String sh = tunnelProps.getProperty("spoofedHost");
                    if (sh != null && sh.endsWith(".i2p")) {
                        return sh;
                    }
                    String kf = tunnelProps.getProperty("privKeyFile");
                    if (kf != null) {
                        File keyFile = new File(kf);
                        if (!keyFile.isAbsolute()) {
                            keyFile = new File(configDir, kf);
                        }
                        if (keyFile.exists()) {
                            PrivateKeyFile pkf = new PrivateKeyFile(keyFile);
                            try {
                                Destination rv = pkf.getDestination();
                                if (rv != null) {
                                    return rv.toBase32();
                                }
                            }
                            catch (I2PException e) {
                                if (this._log.shouldWarn()) {
                                    this._log.warn("Unable to set X-I2P-Location -> Keys not ready (probably safe to ignore, should resolve after first run)\n* Error: " + e.getMessage());
                                }
                                return null;
                            }
                            catch (IOException e) {
                                if (this._log.shouldWarn()) {
                                    this._log.warn("Unable to set X-I2P-Location -> Location not initialized (probably safe to ignore)\n* Error: " + e.getMessage());
                                }
                                return null;
                            }
                        }
                    }
                    if (this._log.shouldWarn()) {
                        this._log.warn("Unable to set X-I2P-Location -> Location target not found in any I2PTunnel config (shouldn't happen!)");
                    }
                    return null;
                }
                catch (IOException ioe) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Unable to set X-I2P-Location -> Location not initialized (probably safe to ignore)\n* Error: " + ioe.getMessage());
                    }
                    return null;
                }
            }
        }
        return null;
    }

    private synchronized String headerContents(HttpServletRequest httpRequest) {
        if (this.X_I2P_Location != null) {
            String query;
            String path;
            String scheme = httpRequest.getScheme();
            if (scheme == null) {
                scheme = "";
            }
            if ((path = httpRequest.getPathInfo()) == null) {
                path = "";
            }
            if ((query = httpRequest.getQueryString()) == null) {
                query = "";
            }
            try {
                if (query.equals("")) {
                    URI uri = new URI(scheme, this.X_I2P_Location, path, null);
                    String encodedURL = uri.toASCIIString();
                    return encodedURL;
                }
                URI uri = new URI(scheme, this.X_I2P_Location, path, query, null);
                String encodedURL = uri.toASCIIString();
                return encodedURL;
            }
            catch (URISyntaxException use) {
                return null;
            }
        }
        return null;
    }

    @Override
    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
        String hashHeader = httpRequest.getHeader("X-I2P-DestHash");
        if (hashHeader == null) {
            String headerURL;
            if (this.shouldRecheck()) {
                String xi2plocation = this.getXI2PLocation(request.getLocalAddr(), String.valueOf(request.getLocalPort()));
                if (this._log.shouldInfo()) {
                    this._log.info("Checking X-I2P-Location header for " + request.getLocalAddr() + ":" + request.getLocalPort() + " (Prefix: " + xi2plocation + ")");
                }
                this.setLocation(xi2plocation);
            }
            if ((headerURL = this.headerContents(httpRequest)) != null) {
                if (this._log.shouldInfo()) {
                    this._log.info("Checking X-I2P-Location header: " + headerURL);
                }
                httpResponse.addHeader("X-I2P-Location", headerURL);
            }
        }
        this._handler.handle(target, request, httpRequest, httpResponse);
    }
}

