/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.servlet.filters;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.i2p.I2PAppContext;
import net.i2p.servlet.filters.XSSRequestWrapper;

public class XSSFilter
implements Filter {
    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    @Override
    public void destroy() {
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            chain.doFilter(new XSSRequestWrapper((HttpServletRequest)request), response);
        }
        catch (IllegalStateException ise) {
            I2PAppContext.getGlobalContext().logManager().getLog(XSSFilter.class).error("XSS Filter Error", ise);
            try {
                String msg = ise.getMessage();
                if (msg == null) {
                    msg = ise.toString();
                }
                ((HttpServletResponse)response).sendError(413, "XSS Filter " + msg);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }
}

