/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.util.Log;
import net.i2p.util.SyntheticREDQueue;
import org.klomp.snark.BandwidthListener;
import org.klomp.snark.Peer;

public class BandwidthManager
implements BandwidthListener {
    private final I2PAppContext _context;
    private final Log _log;
    private SyntheticREDQueue _up;
    private SyntheticREDQueue _down;
    private SyntheticREDQueue _req;

    BandwidthManager(I2PAppContext ctx, int upLimit, int downLimit) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(BandwidthManager.class);
        int absoluteUpLimit = 10238976;
        int absoluteDownLimit = 10238976;
        int up = Math.min(upLimit, absoluteUpLimit);
        int down = Math.min(downLimit, absoluteDownLimit);
        this._up = new SyntheticREDQueue(ctx, up);
        this._down = new SyntheticREDQueue(ctx, down);
        this._req = new SyntheticREDQueue(ctx, down * 110 / 100);
    }

    void setUpBWLimit(long upLimit) {
        int limit = (int)Math.min(upLimit, Integer.MAX_VALUE);
        if ((long)limit != this.getUpBWLimit()) {
            this._up = new SyntheticREDQueue(this._context, limit);
        }
    }

    void setDownBWLimit(long downLimit) {
        int limit = (int)Math.min(downLimit, Integer.MAX_VALUE);
        if ((long)limit != this.getDownBWLimit()) {
            this._down = new SyntheticREDQueue(this._context, limit);
            this._req = new SyntheticREDQueue(this._context, limit * 110 / 100);
        }
    }

    long getRequestRate() {
        return (long)(1000.0f * this._req.getBandwidthEstimate());
    }

    @Override
    public long getUploadRate() {
        return (long)(1000.0f * this._up.getBandwidthEstimate());
    }

    @Override
    public long getDownloadRate() {
        return (long)(1000.0f * this._down.getBandwidthEstimate());
    }

    @Override
    public void uploaded(int size) {
        this._up.addSample(size);
    }

    @Override
    public void downloaded(int size) {
        this._down.addSample(size);
    }

    @Override
    public boolean shouldSend(int size) {
        boolean rv = this._up.offer(size, 1.0f);
        if (!rv && this._log.shouldWarn()) {
            this._log.warn("Declining send request for " + size + " bytes -> Upload rate: " + DataHelper.formatSize(this.getUploadRate()) + "B/s");
        }
        return rv;
    }

    @Override
    public boolean shouldRequest(Peer peer, int size) {
        boolean rv;
        boolean bl = rv = !this.overDownBWLimit() && this._req.offer(size, 1.0f);
        if (!rv && this._log.shouldWarn()) {
            this._log.warn("Not requesting " + size + " bytes (bandwidth limit exceeded) -> Download / Request rate: " + DataHelper.formatSize(this.getDownloadRate()) + "B/s / " + DataHelper.formatSize(this.getRequestRate()) + "B/s");
        }
        return rv;
    }

    @Override
    public long getUpBWLimit() {
        return this._up.getMaxBandwidth();
    }

    @Override
    public long getDownBWLimit() {
        return this._down.getMaxBandwidth();
    }

    @Override
    public boolean overUpBWLimit() {
        return this.getUploadRate() > this.getUpBWLimit();
    }

    @Override
    public boolean overDownBWLimit() {
        return this.getDownloadRate() > this.getDownBWLimit();
    }

    public String toString() {
        String separator = " <span class=bullet>&nbsp;&bullet;&nbsp;</span> ";
        return "<div class=debugStats id=bwManager><span class=stat><b>Bandwidth Out:</b> <span class=dbug>" + this._up.toString().replace("* ", "") + "</span></span>" + separator + "<span class=stat><b>Bandwidth In:</b> <span class=dbug>" + this._down.toString().replace("* ", "") + "</span></span></div>";
    }
}

