/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.i2p.I2PAppContext;
import net.i2p.data.ByteArray;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;
import net.i2p.util.RandomSource;
import net.i2p.util.SimpleTimer2;
import org.klomp.snark.BandwidthListener;
import org.klomp.snark.BitField;
import org.klomp.snark.CoordinatorListener;
import org.klomp.snark.ExtensionHandler;
import org.klomp.snark.I2PSnarkUtil;
import org.klomp.snark.MagnetState;
import org.klomp.snark.MetaInfo;
import org.klomp.snark.PartialPiece;
import org.klomp.snark.Peer;
import org.klomp.snark.PeerCheckerTask;
import org.klomp.snark.PeerID;
import org.klomp.snark.PeerListener;
import org.klomp.snark.PeerState;
import org.klomp.snark.Piece;
import org.klomp.snark.Request;
import org.klomp.snark.Snark;
import org.klomp.snark.Storage;
import org.klomp.snark.bencode.BEValue;
import org.klomp.snark.bencode.InvalidBEncodingException;
import org.klomp.snark.comments.Comment;
import org.klomp.snark.comments.CommentSet;
import org.klomp.snark.dht.DHT;

class PeerCoordinator
implements PeerListener,
BandwidthListener {
    private final Log _log;
    MetaInfo metainfo;
    Storage storage;
    private final Snark snark;
    static final long CHECK_PERIOD = 5000L;
    static final int MAX_UPLOADERS = 16;
    public static final long MAX_INACTIVE = 300000L;
    public static final long MAX_SEED_INACTIVE = 180000L;
    private final AtomicInteger uploaders = new AtomicInteger();
    private final AtomicInteger interestedUploaders = new AtomicInteger();
    private final AtomicInteger interestedAndChoking = new AtomicInteger();
    private final AtomicLong uploaded = new AtomicLong();
    private final AtomicLong downloaded = new AtomicLong();
    static final int RATE_DEPTH = 3;
    private final long[] uploaded_old = new long[]{-1L, -1L, -1L};
    private final long[] downloaded_old = new long[]{-1L, -1L, -1L};
    final Deque<Peer> peers;
    private final Set<PeerID> pexPeers;
    private volatile int peerCount;
    private final CheckEvent timer;
    private final SimpleTimer2.TimedEvent rerequestTimer;
    private final Object rerequestLock = new Object();
    private boolean wasRequestAllowed;
    private boolean isRerequestScheduled;
    private final byte[] id;
    private final byte[] infohash;
    private final List<Piece> wantedPieces;
    private long wantedBytes;
    private final List<PartialPiece> partialPieces;
    private volatile boolean halted;
    private final MagnetState magnetState;
    private final CoordinatorListener listener;
    private final BandwidthListener bwListener;
    private final I2PSnarkUtil _util;
    private final RandomSource _random;
    private final AtomicLong _commentsLastRequested = new AtomicLong();
    private final AtomicInteger _commentsNotRequested = new AtomicInteger();
    private static final long COMMENT_REQ_INTERVAL = 43200000L;
    private static final long COMMENT_REQ_DELAY = 3600000L;
    private static final int MAX_COMMENT_NOT_REQ = 10;
    private Map<String, Long> _webPeerBans;
    private static final long WEBPEER_BAN_TIME = 1800000L;
    private static final int END_GAME_THRESHOLD = 32;
    private static final int MAX_PARALLEL_REQUESTS = 8;

    public PeerCoordinator(I2PSnarkUtil util, byte[] id, byte[] infohash, MetaInfo metainfo, Storage storage, CoordinatorListener listener, Snark torrent, BandwidthListener bwl) {
        this._util = util;
        this._random = util.getContext().random();
        this._log = util.getContext().logManager().getLog(PeerCoordinator.class);
        this.id = id;
        this.infohash = infohash;
        this.metainfo = metainfo;
        this.storage = storage;
        this.listener = listener;
        this.snark = torrent;
        this.bwListener = bwl;
        this.wantedPieces = new ArrayList<Piece>();
        this.setWantedPieces();
        this.partialPieces = new ArrayList<PartialPiece>(this.getMaxConnections() + 1);
        this.peers = new LinkedBlockingDeque<Peer>();
        this.magnetState = new MagnetState(infohash, metainfo);
        this.pexPeers = new ConcurrentHashSet<PeerID>();
        this.timer = new CheckEvent(this._util.getContext(), new PeerCheckerTask(this._util, this));
        this.timer.schedule(20000L + (long)this._random.nextInt(40000));
        this.rerequestTimer = new RerequestEvent();
        this._commentsLastRequested.set(util.getContext().clock().now() - (43200000L - this._random.nextLong(3600000L)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWantedPieces() {
        if (this.metainfo == null || this.storage == null) {
            this.wantedBytes = -1L;
            return;
        }
        List<Piece> list = this.wantedPieces;
        synchronized (list) {
            this.wantedPieces.clear();
            BitField bitfield = this.storage.getBitField();
            int[] pri = this.storage.getPiecePriorities();
            long count = 0L;
            for (int i = 0; i < this.metainfo.getPieces(); ++i) {
                if (bitfield.get(i) || pri != null && pri[i] < 0) continue;
                Piece p = new Piece(i);
                if (pri != null) {
                    p.setPriority(pri[i]);
                }
                this.wantedPieces.add(p);
                count += (long)this.metainfo.getPieceLength(i);
            }
            this.wantedBytes = count;
            Collections.shuffle(this.wantedPieces, this._random);
        }
    }

    public Storage getStorage() {
        return this.storage;
    }

    public List<Peer> peerList() {
        return new ArrayList<Peer>(this.peers);
    }

    public byte[] getID() {
        return this.id;
    }

    public String getName() {
        return this.snark.getName();
    }

    public boolean completed() {
        if (this.storage == null) {
            return false;
        }
        return this.storage.complete();
    }

    public int getPeerCount() {
        return this.peerCount;
    }

    public int getPeers() {
        int rv;
        this.peerCount = rv = this.peers.size();
        return rv;
    }

    public long getLeft() {
        if (this.metainfo == null | this.storage == null) {
            return -1L;
        }
        int psz = this.metainfo.getPieceLength(0);
        long rv = (long)this.storage.needed() * (long)psz;
        int last = this.metainfo.getPieces() - 1;
        BitField bf = this.storage.getBitField();
        if (bf != null && !bf.get(last)) {
            rv -= (long)(psz - this.metainfo.getPieceLength(last));
        }
        return rv;
    }

    public long getNeededLength() {
        return this.wantedBytes;
    }

    public long getUploaded() {
        return this.uploaded.get();
    }

    public void setUploaded(long up) {
        this.uploaded.set(up);
    }

    public long getDownloaded() {
        return this.downloaded.get();
    }

    @Override
    public void uploaded(int size) {
        this.uploaded.addAndGet(size);
        this.bwListener.uploaded(size);
    }

    @Override
    public void downloaded(int size) {
        this.downloaded.addAndGet(size);
        this.bwListener.downloaded(size);
    }

    @Override
    public boolean shouldSend(int size) {
        boolean rv = this.bwListener.shouldSend(size);
        if (rv) {
            this.uploaded.addAndGet(size);
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shouldRequest(Peer peer, int size) {
        boolean rv;
        Object object = this.rerequestLock;
        synchronized (object) {
            rv = this.bwListener.shouldRequest(peer, size);
            if (!this.wasRequestAllowed && rv) {
                if (!this.isRerequestScheduled) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Now unthrottled, schedule rerequest timer");
                    }
                    this.isRerequestScheduled = true;
                    this.rerequestTimer.reschedule(1000L);
                }
                this.wasRequestAllowed = true;
            } else if (this.wasRequestAllowed && !rv) {
                if (!this.isRerequestScheduled) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Now throttled, schedule rerequest timer");
                    }
                    this.isRerequestScheduled = true;
                    this.rerequestTimer.schedule(3000L);
                }
                this.wasRequestAllowed = false;
            }
        }
        return rv;
    }

    public void setRateHistory(long up, long down) {
        PeerCoordinator.setRate(up, this.uploaded_old);
        PeerCoordinator.setRate(down, this.downloaded_old);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setRate(long val, long[] array) {
        long[] lArray = array;
        synchronized (array) {
            for (int i = 2; i > 0; --i) {
                array[i] = array[i - 1];
            }
            array[0] = val;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public long getDownloadRate() {
        if (this.halted) {
            return 0L;
        }
        return PeerCoordinator.getRate(this.downloaded_old);
    }

    @Override
    public long getUploadRate() {
        if (this.halted) {
            return 0L;
        }
        return PeerCoordinator.getRate(this.uploaded_old);
    }

    public long getCurrentUploadRate() {
        if (this.halted) {
            return 0L;
        }
        long r = this.uploaded_old[0];
        if (r <= 0L) {
            return 0L;
        }
        return r * 1000L / 5000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long getRate(long[] array) {
        long rate = 0L;
        int factor = 0;
        long[] lArray = array;
        synchronized (array) {
            int i;
            for (i = 0; i < 3 && array[i] >= 0L; ++i) {
                int f = 3 - i;
                rate += array[i] * (long)f;
                factor += f;
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            if (i == 0) {
                return 0L;
            }
            return rate / ((long)factor * 5000L / 1000L);
        }
    }

    @Override
    public long getUpBWLimit() {
        return this.bwListener.getUpBWLimit();
    }

    @Override
    public boolean overUpBWLimit() {
        return this.bwListener.overUpBWLimit();
    }

    public boolean overUpBWLimit(long total) {
        return total * 1000L / 5000L > this.getUpBWLimit();
    }

    @Override
    public long getDownBWLimit() {
        return this.bwListener.getDownBWLimit();
    }

    @Override
    public boolean overDownBWLimit() {
        return this.bwListener.overDownBWLimit();
    }

    public MetaInfo getMetaInfo() {
        return this.metainfo;
    }

    public byte[] getInfoHash() {
        return this.infohash;
    }

    public boolean needPeers() {
        return !this.halted && this.peers.size() < this.getMaxConnections();
    }

    public boolean needOutboundPeers() {
        return (this.wantedBytes != 0L || this._util.utCommentsEnabled() && this._commentsLastRequested.get() < this._util.getContext().clock().now() - 43200000L) && !this.halted && this.peers.size() < this.getMaxConnections() - 2 && (this.storage == null || !this.storage.isChecking());
    }

    private int getMaxConnections() {
        if (this.metainfo == null) {
            return 6;
        }
        int pieces = this.metainfo.getPieces();
        if (pieces <= 10) {
            return 4;
        }
        if (pieces <= 25) {
            return 10;
        }
        if (pieces <= 80) {
            return 16;
        }
        int max = this._util.getMaxConnections();
        return max;
    }

    public boolean halted() {
        return this.halted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void halt() {
        this.halted = true;
        ArrayList<Peer> removed = new ArrayList<Peer>();
        SequencedCollection<Comparable<Peer>> sequencedCollection = this.peers;
        synchronized (sequencedCollection) {
            this.timer.cancel();
            removed.addAll(this.peers);
            this.peers.clear();
            this.peerCount = 0;
        }
        while (!removed.isEmpty()) {
            Peer peer = (Peer)removed.remove(0);
            peer.disconnect();
            this.removePeerFromPieces(peer);
        }
        sequencedCollection = this.partialPieces;
        synchronized (sequencedCollection) {
            for (PartialPiece pp : this.partialPieces) {
                pp.release();
            }
            this.partialPieces.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart() {
        this.halted = false;
        Object object = this.uploaded_old;
        synchronized (this.uploaded_old) {
            Arrays.fill(this.uploaded_old, 0L);
            // ** MonitorExit[var1_1 /* !! */ ] (shouldn't be in output)
            object = this.downloaded_old;
            synchronized (this.downloaded_old) {
                Arrays.fill(this.downloaded_old, 0L);
                // ** MonitorExit[var1_1 /* !! */ ] (shouldn't be in output)
                List<Piece> list = this.wantedPieces;
                object = list;
                synchronized (list) {
                    for (Piece pc : this.wantedPieces) {
                        pc.clear();
                    }
                    // ** MonitorExit[var1_1 /* !! */ ] (shouldn't be in output)
                    this.timer.schedule(2500L + (long)this._random.nextInt(5000));
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connected(Peer peer) {
        if (this.halted) {
            peer.disconnect(false);
            return;
        }
        Peer toDisconnect = null;
        Deque<Peer> deque = this.peers;
        synchronized (deque) {
            Peer old = PeerCoordinator.peerIDInList(peer.getPeerID(), this.peers);
            if (old != null && old.getInactiveTime() > old.getMaxInactiveTime()) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Removing old peer [" + peer + "] - [" + old + "] inactive for " + old.getInactiveTime() + "ms");
                }
                this.peers.remove(old);
                toDisconnect = old;
                old = null;
            }
            if (old != null) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Already connected to [" + peer + "] - [" + old + "] inactive for " + old.getInactiveTime() + "ms");
                }
                peer.disconnect(false);
            } else if (this.peers.size() >= this.getMaxConnections()) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Already at MAX_CONNECTIONS in connected() with peer [" + peer + "]");
                }
                peer.disconnect(false);
            } else {
                if (this._log.shouldInfo()) {
                    String name = this.metainfo == null ? "Magnet" : this.metainfo.getName();
                    this._log.info("New connection to [" + peer + "] for " + name);
                }
                if (this.metainfo != null) {
                    peer.setMetaInfo(this.metainfo);
                }
                if (this._util.getContext().random().nextInt(4) == 0) {
                    this.peers.push(peer);
                } else {
                    this.peers.add(peer);
                }
                this.peerCount = this.peers.size();
                this.unchokePeer();
            }
        }
        if (toDisconnect != null) {
            toDisconnect.disconnect(false);
            this.removePeerFromPieces(toDisconnect);
        }
    }

    private static Peer peerIDInList(PeerID pid, Collection<Peer> peers) {
        for (Peer cur : peers) {
            if (!pid.sameID(cur.getPeerID())) continue;
            return cur;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addPeer(final Peer peer) {
        boolean need_more;
        if (this.halted) {
            peer.disconnect(false);
            return false;
        }
        int peersize = 0;
        Deque<Peer> deque = this.peers;
        synchronized (deque) {
            peersize = this.peers.size();
            boolean bl = need_more = !peer.isConnected() && peersize < this.getMaxConnections();
            if (need_more) {
                Peer old = PeerCoordinator.peerIDInList(peer.getPeerID(), this.peers);
                need_more = old == null || old.getInactiveTime() > old.getMaxInactiveTime();
            }
        }
        if (need_more) {
            if (this._log.shouldDebug()) {
                String name = this.metainfo == null ? "Magnet" : this.metainfo.getName();
                this._log.debug("Adding peer [" + peer.getPeerID().toString() + "] for " + name, new Exception("add/run"));
            }
            final PeerCoordinator listener = this;
            final BitField bitfield = this.storage != null ? this.storage.getBitField() : null;
            if (!peer.isIncoming() && this.wantedBytes == 0L && this._log.shouldInfo()) {
                this._log.info("Checking for new comments for: " + this.snark.getBaseName() + " from [" + peer + "]");
            }
            final boolean partialComplete = this.wantedBytes == 0L && bitfield != null && !bitfield.complete();
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    peer.runConnection(PeerCoordinator.this._util, listener, PeerCoordinator.this, bitfield, PeerCoordinator.this.magnetState, partialComplete);
                }
            };
            String threadName = "Snark peer " + peer.toString();
            new I2PAppThread(r, threadName).start();
            return true;
        }
        if (this._log.shouldDebug()) {
            if (peer.isConnected()) {
                this._log.debug("Add peer already connected [" + peer + "]");
            } else {
                this._log.debug("Not accepting extra peer [" + peer + "] (Connections: " + peersize + "/" + this.getMaxConnections() + ")");
            }
        }
        return false;
    }

    void unchokePeer() {
        if (this.storage == null || this.storage.getBitField().size() == 0) {
            return;
        }
        if (this.overUpBWLimit()) {
            return;
        }
        LinkedList<Peer> interested = new LinkedList<Peer>();
        int count = 0;
        int unchokedCount = 0;
        int maxUploaders = this.allowedUploaders();
        for (Peer peer : this.peers) {
            if (!peer.isChoking() || !peer.isInterested()) continue;
            ++count;
            if (this.uploaders.get() >= maxUploaders) continue;
            if (peer.isInteresting() && !peer.isChoked()) {
                interested.add(unchokedCount++, peer);
                continue;
            }
            interested.add(peer);
        }
        int up = this.uploaders.get();
        while (up < maxUploaders && !interested.isEmpty()) {
            Peer peer = (Peer)interested.remove(0);
            if (this._log.shouldDebug()) {
                this._log.debug("Unchoking [" + peer + "]");
            }
            peer.setChoking(false);
            up = this.uploaders.incrementAndGet();
            this.interestedUploaders.incrementAndGet();
            --count;
            this.peers.remove(peer);
            this.peers.add(peer);
            this.peerCount = this.peers.size();
        }
        this.interestedAndChoking.set(count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean gotHave(Peer peer, int piece) {
        List<Piece> list = this.wantedPieces;
        synchronized (list) {
            for (Piece pc : this.wantedPieces) {
                if (pc.getId() != piece) continue;
                pc.addPeer(peer);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean gotBitField(Peer peer, BitField bitfield) {
        boolean rv = false;
        List<Piece> list = this.wantedPieces;
        synchronized (list) {
            for (Piece p : this.wantedPieces) {
                int i = p.getId();
                if (!bitfield.get(i)) continue;
                p.addPeer(peer);
                rv = true;
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Piece wantPiece(Peer peer, BitField havePieces, boolean record) {
        if (this.halted) {
            if (this._log.shouldWarn()) {
                this._log.warn("We don't want anything from [" + peer + "] as we are halted!");
            }
            return null;
        }
        Piece piece = null;
        ArrayList<Piece> requested = new ArrayList<Piece>();
        int wantedSize = 33;
        List<Piece> list = this.wantedPieces;
        synchronized (list) {
            Piece p;
            if (record) {
                Collections.sort(this.wantedPieces);
            }
            Iterator<Piece> it = this.wantedPieces.iterator();
            while (piece == null && it.hasNext() && !(p = it.next()).isDisabled()) {
                if (havePieces.get(p.getId()) && !p.isRequested()) {
                    boolean hasPartial = false;
                    for (PartialPiece pp : this.partialPieces) {
                        if (pp.getPiece() != p.getId()) continue;
                        if (this._log.shouldDebug()) {
                            this._log.debug("wantPiece() skipping partial for [" + peer + "] [Piece " + pp + "]");
                        }
                        hasPartial = true;
                        break;
                    }
                    if (hasPartial) continue;
                    piece = p;
                    continue;
                }
                if (!p.isRequested()) continue;
                requested.add(p);
            }
            if (piece == null) {
                wantedSize = this.wantedPieces.size();
            }
            if (piece == null) {
                if (wantedSize > 32) {
                    if (this._log.shouldInfo()) {
                        this._log.info("Nothing to request, " + requested.size() + " being requested and " + wantedSize + " still wanted");
                    }
                    return null;
                }
                if (record) {
                    Collections.shuffle(requested, this._random);
                }
                Iterator it2 = requested.iterator();
                while (piece == null && it2.hasNext()) {
                    int requestedCount;
                    Piece p2 = (Piece)it2.next();
                    if (!havePieces.get(p2.getId()) || (requestedCount = p2.getRequestCount()) >= 8 || p2.isRequestedBy(peer)) continue;
                    piece = p2;
                    break;
                }
                if (piece == null) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Nothing to even rerequest from [" + peer + "] - requested = " + requested);
                    }
                    return null;
                }
                if (this._log.shouldInfo()) {
                    this._log.info("Parallel request (end game?) for [" + peer + "] [Piece " + piece + "]");
                }
            }
            if (record) {
                if (this._log.shouldInfo()) {
                    if (piece.getPriority() > 0) {
                        this._log.info("Requesting piece [" + piece + "] from [" + peer + "] (Priority: " + piece.getPriority() + ")");
                    } else {
                        this._log.info("Requesting piece [" + piece + "] from [" + peer + "]");
                    }
                }
                piece.setRequested(peer, true);
            }
            return piece;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePiecePriorities() {
        if (this.storage == null) {
            return;
        }
        int[] pri = this.storage.getPiecePriorities();
        if (pri == null) {
            this._log.debug("Updated piece priorities called but no priorities to set?");
            return;
        }
        ArrayList<Piece> toCancel = new ArrayList<Piece>();
        Iterator<Peer> iterator = this.wantedPieces;
        synchronized (iterator) {
            BitField want = new BitField(pri.length);
            for (Piece p : this.wantedPieces) {
                want.set(p.getId());
            }
            BitField bitfield = this.storage.getBitField();
            for (int i = 0; i < pri.length; ++i) {
                if (pri[i] < 0 || bitfield.get(i) || want.get(i)) continue;
                Piece piece = new Piece(i);
                this.wantedPieces.add(piece);
                this.wantedBytes += (long)this.metainfo.getPieceLength(i);
                for (Peer p : this.peers) {
                    BitField bf;
                    PeerState s = p.state;
                    if (s == null || (bf = s.bitfield) == null || !bf.get(i)) continue;
                    piece.addPeer(p);
                }
            }
            Iterator<Piece> iter = this.wantedPieces.iterator();
            while (iter.hasNext()) {
                Piece p = iter.next();
                int priority = pri[p.getId()];
                if (priority >= 0) {
                    p.setPriority(priority);
                    continue;
                }
                iter.remove();
                toCancel.add(p);
                this.wantedBytes -= (long)this.metainfo.getPieceLength(p.getId());
            }
            if (this._log.shouldDebug()) {
                this._log.debug("Updated piece priorities, now wanted: " + this.wantedPieces);
            }
            Collections.shuffle(this.wantedPieces, this._random);
        }
        if (!toCancel.isEmpty()) {
            for (Peer peer : this.peers) {
                for (Piece p : toCancel) {
                    peer.cancel(p.getId());
                }
            }
        }
        for (Peer peer : this.peers) {
            peer.request();
        }
    }

    @Override
    public ByteArray gotRequest(Peer peer, int piece, int off, int len) {
        if (this.halted) {
            return null;
        }
        if (this.metainfo == null || this.storage == null) {
            return null;
        }
        try {
            return this.storage.getPiece(piece, off, len);
        }
        catch (IOException ioe) {
            this.snark.stopTorrent();
            String msg = "Error reading the storage (piece " + piece + ") for " + this.metainfo.getName() + ": " + ioe;
            this._log.error(msg, ioe);
            if (this.listener != null) {
                this.listener.addMessage(msg);
                this.listener.addMessage("Fatal storage error: Stopping torrent " + this.metainfo.getName());
            }
            throw new RuntimeException(msg, ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean gotPiece(Peer peer, PartialPiece pp) {
        if (this.metainfo == null || this.storage == null || this.storage.isChecking() || this.halted) {
            pp.release();
            return true;
        }
        int piece = pp.getPiece();
        try {
            List<Piece> list = this.wantedPieces;
            synchronized (list) {
                Piece p = new Piece(piece);
                if (!this.wantedPieces.contains(p)) {
                    if (this._log.shouldDebug()) {
                        this._log.debug("Received unwanted piece [" + piece + "/" + this.metainfo.getPieces() + "] from [" + peer + "] for " + this.metainfo.getName());
                    }
                    if (this.storage.getBitField().get(piece)) {
                        pp.release();
                        return true;
                    }
                }
                if (this.storage.putPiece(pp)) {
                    if (this._log.shouldDebug()) {
                        this._log.debug("Received valid piece [" + piece + "/" + this.metainfo.getPieces() + "] from [" + peer + "] for " + this.metainfo.getName());
                    }
                } else {
                    this.markUnrequested(peer, piece);
                    this.removePartialPiece(piece);
                    for (Piece pc : this.wantedPieces) {
                        if (pc.getId() != piece) continue;
                        pc.removePeer(peer);
                        break;
                    }
                    if (this._log.shouldDebug()) {
                        this._log.debug("Received BAD piece [" + piece + "/" + this.metainfo.getPieces() + "] from [" + peer + "] for " + this.metainfo.getName());
                    }
                    return false;
                }
                this.wantedPieces.remove(p);
                this.wantedBytes -= (long)this.metainfo.getPieceLength(p.getId());
            }
        }
        catch (IOException ioe) {
            String msg = "Error writing to storage [piece " + piece + "] for " + this.metainfo.getName();
            msg = msg + "\n* ";
            this._log.error(msg, ioe);
            if (this.listener != null) {
                this.listener.addMessage(msg);
                this.listener.addMessage("Fatal storage error: Stopping torrent " + this.metainfo.getName());
            }
            this.snark.stopTorrent();
            throw new RuntimeException(msg, ioe);
        }
        this.removePartialPiece(piece);
        boolean done = this.wantedBytes <= 0L;
        ArrayList<Peer> toDisconnect = done ? new ArrayList<Peer>() : null;
        for (Peer p : this.peers) {
            if (!p.isConnected()) continue;
            if (done && p.isCompleted()) {
                toDisconnect.add(p);
                continue;
            }
            p.have(piece);
        }
        if (done) {
            for (Peer p : toDisconnect) {
                p.disconnect(true);
            }
            if (!this.completed()) {
                this.snark.storageCompleted(this.storage);
            }
            List<PartialPiece> list = this.partialPieces;
            synchronized (list) {
                for (PartialPiece ppp : this.partialPieces) {
                    ppp.release();
                }
                this.partialPieces.clear();
            }
        }
        return true;
    }

    @Override
    public void gotChoke(Peer peer, boolean choke) {
        if (this._log.shouldInfo()) {
            this._log.info("Received choke(" + choke + ") from [" + peer + "]");
        }
    }

    @Override
    public void gotInterest(Peer peer, boolean interest) {
        if (interest) {
            if (this.storage == null || this.storage.getBitField().size() == 0) {
                return;
            }
            if (this.uploaders.get() < this.allowedUploaders() && peer.isChoking() && !this.overUpBWLimit()) {
                this.uploaders.incrementAndGet();
                this.interestedUploaders.incrementAndGet();
                peer.setChoking(false);
                if (this._log.shouldInfo()) {
                    this._log.info("Unchoking [" + peer + "]");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnected(Peer peer) {
        if (this._log.shouldInfo()) {
            this._log.info("Disconnected peer [" + peer + "]");
        }
        Deque<Peer> deque = this.peers;
        synchronized (deque) {
            if (this.peers.remove(peer)) {
                this.unchokePeer();
                this.removePeerFromPieces(peer);
            }
            this.peerCount = this.peers.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePeerFromPieces(Peer peer) {
        List<Piece> list = this.wantedPieces;
        synchronized (list) {
            for (Piece piece : this.wantedPieces) {
                piece.removePeer(peer);
                piece.setRequested(peer, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void savePartialPieces(Peer peer, List<Request> partials) {
        if (this._log.shouldInfo()) {
            this._log.info("Partials received from [" + peer + "] - " + partials);
        }
        if (this.halted || this.completed()) {
            for (Request req : partials) {
                PartialPiece pp = req.getPartialPiece();
                pp.release();
            }
            return;
        }
        List<Piece> list = this.wantedPieces;
        synchronized (list) {
            for (Request req : partials) {
                PartialPiece pp = req.getPartialPiece();
                if (pp.hasData()) {
                    int idx = this.partialPieces.indexOf(pp);
                    if (idx < 0) {
                        this.partialPieces.add(pp);
                        if (this._log.shouldInfo()) {
                            this._log.info("Saving orphaned partial piece (new) " + pp);
                        }
                    } else if (pp.getDownloaded() > this.partialPieces.get(idx).getDownloaded()) {
                        this.partialPieces.get(idx).release();
                        this.partialPieces.set(idx, pp);
                        if (this._log.shouldInfo()) {
                            this._log.info("Saving orphaned partial piece (bigger) " + pp);
                        }
                    } else {
                        pp.release();
                        if (this._log.shouldInfo()) {
                            this._log.info("Discarding partial piece (not bigger)" + pp);
                        }
                    }
                    int max = this.getMaxConnections();
                    if (this.partialPieces.size() > max) {
                        Collections.sort(this.partialPieces);
                        PartialPiece gone = this.partialPieces.remove(this.partialPieces.size() - 1);
                        gone.release();
                        if (this._log.shouldInfo()) {
                            this._log.info("Discarding orphaned partial piece (list full) " + gone);
                        }
                    }
                } else {
                    pp.release();
                }
                this.markUnrequested(peer, pp.getPiece());
            }
            if (this._log.shouldInfo()) {
                this._log.info("Partial list size now: " + this.partialPieces.size());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PartialPiece getPartialPiece(Peer peer, BitField havePieces) {
        if (this.metainfo == null) {
            return null;
        }
        if (this.storage != null && this.storage.isChecking()) {
            return null;
        }
        List<Piece> list = this.wantedPieces;
        synchronized (list) {
            Collections.sort(this.partialPieces);
            Iterator<PartialPiece> iter = this.partialPieces.iterator();
            while (iter.hasNext()) {
                PartialPiece pp = iter.next();
                int savedPiece = pp.getPiece();
                if (!havePieces.get(savedPiece)) continue;
                boolean skipped = false;
                block4: for (Piece piece : this.wantedPieces) {
                    if (piece.getId() != savedPiece) continue;
                    if (peer.isCompleted() && piece.getPeerCount() > 1 && this.wantedPieces.size() > 64 && this.partialPieces.size() < 4 && this._random.nextInt(4) != 0) {
                        int nonSeeds = 0;
                        int seeds = 0;
                        for (Peer pr : this.peers) {
                            BitField bf;
                            if (pr.isCompleted()) {
                                if (++seeds < 4) continue;
                                break;
                            }
                            PeerState state = pr.state;
                            if (state == null || (bf = state.bitfield) == null || !bf.get(savedPiece) || ++nonSeeds <= 1) continue;
                            skipped = true;
                            break block4;
                        }
                    }
                    iter.remove();
                    piece.setRequested(peer, true);
                    if (this._log.shouldInfo()) {
                        this._log.info("Restoring orphaned partial piece " + pp + " to " + peer + " -> Partial list size now: " + this.partialPieces.size());
                    }
                    return pp;
                }
                if (!this._log.shouldDebug()) continue;
                if (skipped) {
                    this._log.debug("Partial piece " + pp + " with multiple peers skipped for seeder");
                    continue;
                }
                this._log.debug("Partial piece " + pp + " NOT in wantedPieces??");
            }
            if (this._log.shouldDebug() && !this.partialPieces.isEmpty()) {
                this._log.debug("Peer [" + peer + "] has none of our partials " + this.partialPieces);
            }
        }
        Piece piece = this.wantPiece(peer, havePieces, true);
        if (piece != null) {
            return new PartialPiece(piece, this.metainfo.getPieceLength(piece.getId()), this._util.getTempDir());
        }
        if (this._log.shouldDebug()) {
            this._log.debug("We have no partial piece to return");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean needPiece(Peer peer, BitField havePieces) {
        List<Piece> list = this.wantedPieces;
        synchronized (list) {
            for (PartialPiece pp : this.partialPieces) {
                int savedPiece = pp.getPiece();
                if (!havePieces.get(savedPiece)) continue;
                for (Piece piece : this.wantedPieces) {
                    if (piece.getId() != savedPiece) continue;
                    if (this._log.shouldInfo()) {
                        this._log.info("We could restore orphaned partial piece " + pp);
                    }
                    return true;
                }
            }
        }
        return this.wantPiece(peer, havePieces, false) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePartialPiece(int piece) {
        List<Piece> list = this.wantedPieces;
        synchronized (list) {
            Iterator<PartialPiece> iter = this.partialPieces.iterator();
            while (iter.hasNext()) {
                PartialPiece pp = iter.next();
                if (pp.getPiece() != piece) continue;
                iter.remove();
                pp.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markUnrequested(Peer peer, int piece) {
        List<Piece> list = this.wantedPieces;
        synchronized (list) {
            for (Piece pc : this.wantedPieces) {
                if (pc.getId() != piece) continue;
                pc.setRequested(peer, false);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void gotExtension(Peer peer, int id, byte[] bs) {
        if (this._log.shouldDebug()) {
            this._log.debug("Received extension message " + id + " from [" + peer + "]");
        }
        if (this.metainfo == null && id == 1) {
            MagnetState magnetState = this.magnetState;
            synchronized (magnetState) {
                if (this.magnetState.isComplete()) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Received completed metainfo via extension");
                    }
                    this.metainfo = this.magnetState.getMetaInfo();
                    this.listener.gotMetaInfo(this, this.metainfo);
                }
            }
        } else if (id == 0) {
            if (!peer.isCompleted()) {
                this.sendPeers(peer);
            }
            this.sendDHT(peer);
            if (this._util.utCommentsEnabled()) {
                this.sendCommentReq(peer);
            }
        }
    }

    void sendPeers(Peer peer) {
        if (this.metainfo != null && this.metainfo.isPrivate()) {
            return;
        }
        Map<String, BEValue> handshake = peer.getHandshakeMap();
        if (handshake == null) {
            return;
        }
        BEValue bev = handshake.get("m");
        if (bev == null) {
            return;
        }
        try {
            if (bev.getMap().get("i2p_pex") != null) {
                ArrayList<Peer> pList = new ArrayList<Peer>();
                long t = peer.getPexLastSent();
                for (Peer p : this.peers) {
                    if (p.equals(peer) || p.isWebPeer() || p.getWhenConnected() <= t) continue;
                    pList.add(p);
                }
                if (!pList.isEmpty()) {
                    ExtensionHandler.sendPEX(peer, pList);
                    peer.setPexLastSent(this._util.getContext().clock().now());
                }
            }
        }
        catch (InvalidBEncodingException invalidBEncodingException) {
            // empty catch block
        }
    }

    void sendDHT(Peer peer) {
        DHT dht = this._util.getDHT();
        if (dht == null) {
            return;
        }
        Map<String, BEValue> handshake = peer.getHandshakeMap();
        if (handshake == null) {
            return;
        }
        BEValue bev = handshake.get("m");
        if (bev == null) {
            return;
        }
        try {
            if (bev.getMap().get("i2p_dht") != null) {
                ExtensionHandler.sendDHT(peer, dht.getPort(), dht.getRPort());
            }
        }
        catch (InvalidBEncodingException invalidBEncodingException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendCommentReq(Peer peer) {
        block13: {
            Map<String, BEValue> handshake = peer.getHandshakeMap();
            if (handshake == null) {
                if (this.wantedBytes == 0L && this._commentsNotRequested.incrementAndGet() >= 10) {
                    this._commentsLastRequested.set(this._util.getContext().clock().now());
                }
                return;
            }
            BEValue bev = handshake.get("m");
            if (bev == null) {
                if (this.wantedBytes == 0L && this._commentsNotRequested.incrementAndGet() >= 10) {
                    this._commentsLastRequested.set(this._util.getContext().clock().now());
                }
                return;
            }
            try {
                if (bev.getMap().get("ut_comment") != null) {
                    int sz = 0;
                    CommentSet comments = this.snark.getComments();
                    if (comments != null) {
                        CommentSet commentSet = comments;
                        synchronized (commentSet) {
                            sz = comments.size();
                        }
                    }
                    this._commentsNotRequested.set(0);
                    this._commentsLastRequested.set(this._util.getContext().clock().now());
                    if (sz >= 256) {
                        return;
                    }
                    ExtensionHandler.sendCommentReq(peer, 256 - sz);
                    break block13;
                }
                if (this.wantedBytes == 0L && this._commentsNotRequested.incrementAndGet() >= 10) {
                    this._commentsLastRequested.set(this._util.getContext().clock().now());
                }
            }
            catch (InvalidBEncodingException invalidBEncodingException) {
                // empty catch block
            }
        }
    }

    public void setStorage(Storage stg) {
        this.storage = stg;
        this.setWantedPieces();
        for (Peer p : this.peers) {
            p.setMetaInfo(this.metainfo);
        }
    }

    @Override
    public void gotPort(Peer peer, int port, int rport) {
        DHT dht = this._util.getDHT();
        if (dht != null && port > 0 && port < 65535 && rport == port + 1) {
            dht.ping(peer.getDestination(), port);
        }
    }

    @Override
    public void gotPeers(Peer peer, List<PeerID> peers) {
        if (!this.needOutboundPeers()) {
            return;
        }
        Destination myDest = this._util.getMyDestination();
        if (myDest == null) {
            return;
        }
        byte[] myHash = myDest.calculateHash().getData();
        List<Peer> pList = this.peerList();
        for (PeerID id : peers) {
            if (PeerCoordinator.peerIDInList(id, pList) != null || DataHelper.eq(myHash, id.getDestHash())) continue;
            this.pexPeers.add(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void gotCommentReq(Peer peer, int num) {
        if (!this._util.utCommentsEnabled()) {
            return;
        }
        CommentSet comments = this.snark.getComments();
        if (comments != null) {
            int sz;
            int lastSent = peer.getTotalCommentsSent();
            CommentSet commentSet = comments;
            synchronized (commentSet) {
                sz = comments.size();
                if (sz <= lastSent) {
                    return;
                }
                ExtensionHandler.locked_sendComments(peer, num, comments);
            }
            peer.setTotalCommentsSent(sz);
        }
    }

    @Override
    public void gotComments(Peer peer, List<Comment> comments) {
        if (!this._util.utCommentsEnabled()) {
            return;
        }
        if (!comments.isEmpty()) {
            this.snark.addComments(comments);
        }
    }

    Set<PeerID> getPEXPeers() {
        return this.pexPeers;
    }

    public int allowedUploaders() {
        int up = this.uploaders.get();
        if (this.listener != null && this.listener.overUploadLimit(this.interestedUploaders.get())) {
            if (this._log.shouldDebug()) {
                this._log.debug("Over limit, uploaders was: " + up);
            }
            return up - 1;
        }
        if (up < 16) {
            return up + 1;
        }
        return 16;
    }

    public int getUploaders() {
        int max;
        int rv = this.uploaders.get();
        if (rv > 0 && rv > (max = this.getPeers())) {
            rv = max;
        }
        return rv;
    }

    public int getInterestedUploaders() {
        int max;
        int rv = this.interestedUploaders.get();
        if (rv > 0 && rv > (max = this.getPeers())) {
            rv = max;
        }
        return rv;
    }

    public void setUploaders(int upl, int inter) {
        if (upl < 0) {
            upl = 0;
        } else if (upl > 16) {
            upl = 16;
        }
        this.uploaders.set(upl);
        if (inter < 0) {
            inter = 0;
        } else if (inter > 16) {
            inter = 16;
        }
        this.interestedUploaders.set(inter);
    }

    public void decrementUploaders(boolean isInterested) {
        int up = this.uploaders.decrementAndGet();
        if (up < 0) {
            this.uploaders.set(0);
        }
        if (isInterested && (up = this.interestedUploaders.decrementAndGet()) < 0) {
            this.interestedUploaders.set(0);
        }
    }

    public int getInterestedAndChoking() {
        return this.interestedAndChoking.get();
    }

    public void addInterestedAndChoking(int toAdd) {
        this.interestedAndChoking.addAndGet(toAdd);
    }

    @Override
    public I2PSnarkUtil getUtil() {
        return this._util;
    }

    public synchronized void banWebPeer(String host, boolean isPermanent) {
        Long time;
        if (this._webPeerBans == null) {
            this._webPeerBans = new HashMap<String, Long>(4);
        }
        if (isPermanent) {
            time = Long.MAX_VALUE;
        } else {
            long now = this._util.getContext().clock().now();
            time = now + 1800000L;
        }
        Long old = this._webPeerBans.put(host, time);
        if (old != null && old > time) {
            this._webPeerBans.put(host, old);
        }
    }

    public synchronized boolean isWebPeerBanned(String host) {
        boolean rv;
        if (this._webPeerBans == null) {
            return false;
        }
        Long time = this._webPeerBans.get(host);
        if (time == null) {
            return false;
        }
        long now = this._util.getContext().clock().now();
        boolean bl = rv = time > now;
        if (!rv) {
            this._webPeerBans.remove(host);
        }
        return rv;
    }

    private class RerequestEvent
    extends SimpleTimer2.TimedEvent {
        public RerequestEvent() {
            super(PeerCoordinator.this._util.getContext().simpleTimer2());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void timeReached() {
            if (PeerCoordinator.this.bwListener.shouldRequest(null, 0)) {
                if (PeerCoordinator.this._log.shouldWarn()) {
                    PeerCoordinator.this._log.warn("Now unthrottled, rerequest timer poking all peers");
                }
                Object object = PeerCoordinator.this.rerequestLock;
                synchronized (object) {
                    PeerCoordinator.this.wasRequestAllowed = true;
                }
                for (Peer p : PeerCoordinator.this.peers) {
                    if (!p.isInteresting() || p.isChoked()) continue;
                    p.request();
                }
                object = PeerCoordinator.this.rerequestLock;
                synchronized (object) {
                    PeerCoordinator.this.isRerequestScheduled = false;
                }
            }
            if (PeerCoordinator.this._log.shouldWarn()) {
                PeerCoordinator.this._log.warn("Still throttled, rerequest timer reschedule");
            }
            Object object = PeerCoordinator.this.rerequestLock;
            synchronized (object) {
                PeerCoordinator.this.wasRequestAllowed = false;
            }
            this.schedule(2000L);
        }
    }

    private static class CheckEvent
    extends SimpleTimer2.TimedEvent {
        private final PeerCheckerTask _task;

        public CheckEvent(I2PAppContext ctx, PeerCheckerTask task) {
            super(ctx.simpleTimer2());
            this._task = task;
        }

        @Override
        public void timeReached() {
            this._task.run();
            this.schedule(5000L);
        }
    }
}

