/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.Collator;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.I2PAppContext;
import net.i2p.app.ClientApp;
import net.i2p.app.ClientAppManager;
import net.i2p.app.ClientAppState;
import net.i2p.app.NavService;
import net.i2p.app.NotificationService;
import net.i2p.client.streaming.I2PSocketManager;
import net.i2p.crypto.SHA1Hash;
import net.i2p.crypto.SigType;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.update.UpdateManager;
import net.i2p.update.UpdateMethod;
import net.i2p.update.UpdateType;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.FileSuffixFilter;
import net.i2p.util.FileUtil;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;
import net.i2p.util.OrderedProperties;
import net.i2p.util.SecureDirectory;
import net.i2p.util.SecureFileOutputStream;
import net.i2p.util.SimpleTimer;
import net.i2p.util.SimpleTimer2;
import net.i2p.util.SystemVersion;
import net.i2p.util.Translate;
import net.i2p.util.UIMessages;
import org.klomp.snark.BWLimits;
import org.klomp.snark.BandwidthListener;
import org.klomp.snark.BandwidthManager;
import org.klomp.snark.BitField;
import org.klomp.snark.CompleteListener;
import org.klomp.snark.ConnectionAcceptor;
import org.klomp.snark.I2PSnarkUtil;
import org.klomp.snark.IdleChecker;
import org.klomp.snark.MetaInfo;
import org.klomp.snark.PeerCoordinatorSet;
import org.klomp.snark.Snark;
import org.klomp.snark.Storage;
import org.klomp.snark.TorrentCreateFilter;
import org.klomp.snark.Tracker;
import org.klomp.snark.TrackerClient;
import org.klomp.snark.UpdateHandler;
import org.klomp.snark.comments.CommentSet;
import org.klomp.snark.dht.DHT;

public class SnarkManager
implements CompleteListener,
ClientApp,
I2PSocketManager.DisconnectListener {
    private final Map<String, Snark> _snarks;
    private final Map<SHA1Hash, Snark> _infoHashToSnark;
    private final Map<String, Snark> _filteredBaseNameToSnark;
    private final Set<String> _magnets;
    private final Object _addSnarkLock;
    private File _configFile;
    private File _configDir;
    private final Object _configLock = new Object();
    private Properties _config;
    private final I2PAppContext _context;
    private final String _contextPath;
    private final String _contextName;
    private final Log _log;
    private final UIMessages _messages;
    private final I2PSnarkUtil _util;
    private final PeerCoordinatorSet _peerCoordinatorSet;
    private final ConnectionAcceptor _connectionAcceptor;
    private final BandwidthManager _bwManager;
    private Thread _monitor;
    private volatile boolean _running;
    private volatile boolean _stopping;
    private final Map<String, Tracker> _trackerMap;
    private final Map<String, TorrentCreateFilter> _torrentCreateFilterMap;
    private UpdateManager _umgr;
    private UpdateHandler _uhandler;
    private SimpleTimer2.TimedEvent _idleChecker;
    public static final String PROP_I2CP_HOST = "i2psnark.i2cpHost";
    public static final String PROP_I2CP_PORT = "i2psnark.i2cpPort";
    public static final String PROP_I2CP_OPTS = "i2psnark.i2cpOptions";
    public static final String PROP_UPLOADERS_TOTAL = "i2psnark.uploaders.total";
    public static final String PROP_UPBW_MAX = "i2psnark.upbw.max";
    public static final String PROP_DOWNBW_MAX = "i2psnark.downbw.max";
    public static final String PROP_DIR = "i2psnark.dir";
    private static final String PROP_META_PREFIX = "i2psnark.zmeta.";
    private static final String PROP_META_RUNNING = "running";
    private static final String PROP_META_STAMP = "stamp";
    private static final String PROP_META_BASE = "base";
    private static final String PROP_META_BITFIELD = "bitfield";
    private static final String PROP_META_PRIORITY = "priority";
    private static final String PROP_META_PRESERVE_NAMES = "preserveFileNames";
    private static final String PROP_META_UPLOADED = "uploaded";
    private static final String PROP_META_ADDED = "added";
    private static final String PROP_META_COMPLETED = "completed";
    private static final String PROP_META_INORDER = "inOrder";
    private static final String PROP_META_MAGNET = "magnet";
    private static final String PROP_META_MAGNET_DN = "magnet_dn";
    private static final String PROP_META_MAGNET_TR = "magnet_tr";
    private static final String PROP_META_MAGNET_DIR = "magnet_dir";
    private static final String PROP_META_MAGNET_PREFIX = "i2psnark.magnet.";
    private static final String PROP_META_COMMENTS = "comments";
    private static final String PROP_META_ACTIVITY = "activity";
    private static final String CONFIG_FILE_SUFFIX = ".config";
    public static final String CONFIG_FILE = "i2psnark.config";
    private static final String COMMENT_FILE_SUFFIX = ".comments.txt.gz";
    public static final String PROP_FILES_PUBLIC = "i2psnark.filesPublic";
    public static final String PROP_OLD_AUTO_START = "i2snark.autoStart";
    public static final String PROP_AUTO_START = "i2psnark.autoStart";
    private final boolean DEFAULT_AUTO_START;
    public static final String PROP_STARTUP_DELAY = "i2psnark.startupDelay";
    public static final String PROP_REFRESH_DELAY = "i2psnark.refreshSeconds";
    public static final String PROP_PAGE_SIZE = "i2psnark.pageSize";
    public static final String RC_PROP_THEME = "routerconsole.theme";
    public static final String RC_PROP_UNIVERSAL_THEMING = "routerconsole.universal.theme";
    public static final String PROP_THEME = "i2psnark.theme";
    public static final String DEFAULT_THEME = "ubergine";
    public static final String PROP_COLLAPSE_PANELS = "i2psnark.collapsePanels";
    public static final String PROP_SHOW_STATUSFILTER = "i2psnark.showStatusFilter";
    public static final String DEFAULT_SHOW_STATUSFILTER = "false";
    public static final String PROP_ENABLE_LIGHTBOX = "i2psnark.enableLightbox";
    public static final String DEFAULT_ENABLE_LIGHTBOX = "true";
    public static final String PROP_ENABLE_ADDCREATE = "i2psnark.enableAddCreate";
    public static final String DEFAULT_ENABLE_ADDCREATE = "false";
    private static final String PROP_USE_OPENTRACKERS = "i2psnark.useOpentrackers";
    public static final String PROP_OPENTRACKERS = "i2psnark.opentrackers";
    public static final String PROP_PRIVATETRACKERS = "i2psnark.privatetrackers";
    private static final String PROP_USE_DHT = "i2psnark.enableDHT";
    private static final String PROP_SMART_SORT = "i2psnark.smartSort";
    private static final String PROP_LANG = "i2psnark.lang";
    private static final String PROP_COUNTRY = "i2psnark.country";
    private static final String PROP_RATINGS = "i2psnark.ratings";
    private static final String PROP_COMMENTS = "i2psnark.comments";
    private static final String PROP_COMMENTS_NAME = "i2psnark.commentsName";
    public static final String PROP_MAX_FILES_PER_TORRENT = "i2psnark.maxFilesPerTorrent";
    public static final String PROP_MAX_MESSAGES = "i2psnark.maxLogMessages";
    public static final int MIN_UP_BW = 30;
    public static final int MIN_DOWN_BW = 60;
    public static final int DEFAULT_MAX_UP_BW = 1024;
    private static final int DEFAULT_MAX_DOWN_BW = 1024;
    public static final int DEFAULT_STARTUP_DELAY = 3;
    public static final int DEFAULT_REFRESH_DELAY_SECS = 5;
    private static final int DEFAULT_PAGE_SIZE = 50;
    public static final int DEFAULT_TUNNEL_QUANTITY = 16;
    public static final int DEFAULT_MAX_FILES_PER_TORRENT = 2000;
    public static final String CONFIG_DIR_SUFFIX = ".d";
    private static final String SUBDIR_PREFIX = "s";
    private static final String B64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-~";
    private static final int DEFAULT_MAX_MESSAGES = 50;
    private static final String[] DEFAULT_TRACKERS = new String[]{"Postman", "http://tracker2.postman.i2p/announce.php=http://tracker2.postman.i2p/", "DgTrack", "http://opentracker.dg2.i2p/a=http://opentracker.dg2.i2p/", "R4SAS", "http://opentracker.r4sas.i2p/a=http://opentracker.r4sas.i2p/stats", "Skank", "http://opentracker.skank.i2p/a=http://opentracker.skank.i2p/tracker"};
    public static final String DEFAULT_BACKUP_TRACKER = "http://opentracker.dg2.i2p/a";
    private static final String DEFAULT_OPENTRACKERS = "http://opentracker.dg2.i2p/a,http://opentracker.r4sas.i2p/a,http://opentracker.skank.i2p/a,";
    public static final Set<String> DEFAULT_TRACKER_ANNOUNCES;
    static final Set<String> KNOWN_OPENTRACKERS;
    private static final String[] DEFAULT_TORRENT_CREATE_FILTERS;
    public static final String PROP_TRACKERS = "i2psnark.trackers";
    public static final String PROP_TORRENT_CREATE_FILTERS = "i2psnark.torrent_create_filters";
    public static final String PROP_TORRENT_FILTERS_CONFIG = "filters.conf";

    public SnarkManager(I2PAppContext ctx) {
        this(ctx, "/i2psnark", "i2psnark");
    }

    public SnarkManager(I2PAppContext ctx, String ctxPath, String ctxName) {
        this._snarks = new ConcurrentHashMap<String, Snark>();
        this._infoHashToSnark = new HashMap<SHA1Hash, Snark>();
        this._filteredBaseNameToSnark = new HashMap<String, Snark>();
        this._magnets = new ConcurrentHashSet<String>();
        this._addSnarkLock = new Object();
        this._context = ctx;
        this._contextPath = ctxPath;
        this._contextName = ctxName;
        this._log = this._context.logManager().getLog(SnarkManager.class);
        this._messages = new UIMessages(50);
        this._util = new I2PSnarkUtil(this._context, ctxName, this);
        this._peerCoordinatorSet = new PeerCoordinatorSet();
        this._connectionAcceptor = new ConnectionAcceptor(this._util, this._peerCoordinatorSet);
        this._bwManager = new BandwidthManager(ctx, 0x100000, 0x100000);
        this.DEFAULT_AUTO_START = true;
        String cfile = ctxName + CONFIG_FILE_SUFFIX;
        File configFile = new File(cfile);
        if (!configFile.isAbsolute()) {
            configFile = new File(this._context.getConfigDir(), cfile);
        }
        this._configDir = this.migrateConfig(configFile);
        this._configFile = new File(this._configDir, CONFIG_FILE);
        this._trackerMap = new ConcurrentHashMap<String, Tracker>(4);
        this._torrentCreateFilterMap = new ConcurrentHashMap<String, TorrentCreateFilter>(3);
        this.loadConfig(null);
        if (!ctx.isRouterContext()) {
            Runtime.getRuntime().addShutdownHook(new Thread((Runnable)new TempDeleter(this._util.getTempDir()), "SnarkDelTemp"));
        }
    }

    public void start() {
        String lang;
        NavService nav;
        this._running = true;
        ClientAppManager cmgr = this._context.clientAppManager();
        if ("i2psnark".equals(this._contextName)) {
            if (cmgr != null) {
                cmgr.register(this);
            }
        } else if (cmgr != null && (nav = (NavService)((Object)cmgr.getRegisteredApp("NavHelper"))) != null) {
            String name = DataHelper.stripHTML(this._contextPath.substring(1));
            nav.registerApp(name, name, this._contextPath, null, "/themes/console/images/i2psnark.png");
        }
        this._monitor = new I2PAppThread(new DirMonitor(), "SnarkDirMonitor", true);
        this._monitor.start();
        if (this._context.isRouterContext() && "i2psnark".equals(this._contextName)) {
            this._context.simpleTimer2().addEvent(new Register(), 240000L);
        }
        this._idleChecker = new IdleChecker(this, this._peerCoordinatorSet);
        this._idleChecker.schedule(180000L);
        if (!this._context.isRouterContext() && (lang = this._config.getProperty(PROP_LANG)) != null) {
            String country = this._config.getProperty(PROP_COUNTRY, "");
            Translate.setLanguage(lang, country);
        }
    }

    @Override
    public void sessionDisconnected() {
        if (!this._context.isRouterContext()) {
            this.addMessage(this._t("Unable to connect to I2P"));
            this.stopAllTorrents(true);
            this._stopping = false;
        }
    }

    public void stop() {
        NavService nav;
        if (this._log.shouldDebug()) {
            this._log.debug("Snark stop() begin", new Exception("I did it"));
        }
        if (this._umgr != null && this._uhandler != null) {
            this._umgr.unregister(this._uhandler, UpdateType.ROUTER_SIGNED, UpdateMethod.TORRENT);
            this._umgr.unregister(this._uhandler, UpdateType.ROUTER_SIGNED_SU3, UpdateMethod.TORRENT);
        }
        this._running = false;
        this._monitor.interrupt();
        this._connectionAcceptor.halt();
        this._idleChecker.cancel();
        this.stopAllTorrents(true);
        ClientAppManager cmgr = this._context.clientAppManager();
        if ("i2psnark".equals(this._contextName)) {
            if (cmgr != null) {
                cmgr.unregister(this);
            }
        } else if (cmgr != null && (nav = (NavService)((Object)cmgr.getRegisteredApp("NavHelper"))) != null) {
            String name = DataHelper.stripHTML(this._contextPath.substring(1));
            nav.unregisterApp(name);
        }
        if (this._log.shouldWarn()) {
            this._log.warn("Snark stop() end");
        }
    }

    public boolean isStopping() {
        return this._stopping;
    }

    @Override
    public void startup() {
    }

    @Override
    public void shutdown(String[] args) {
    }

    @Override
    public ClientAppState getState() {
        return ClientAppState.INITIALIZED;
    }

    @Override
    public String getName() {
        return "i2psnark";
    }

    @Override
    public String getDisplayName() {
        return "i2psnark: " + this._contextPath;
    }

    public I2PSnarkUtil util() {
        return this._util;
    }

    @Override
    public BandwidthListener getBandwidthListener() {
        return this._bwManager;
    }

    public void addMessage(String message) {
        this.addMessageNoEscape(message.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("&amp;nbsp", "&nbsp;"));
    }

    public void addMessageNoEscape(String message) {
        this._messages.addMessageNoEscape(this.getTime() + "&nbsp; " + message.replace("%20", " "));
        if (this._log.shouldInfo()) {
            this._log.info(message);
        }
    }

    public String getTime() {
        SimpleDateFormat fmt = new SimpleDateFormat("dd/MM HH:mm:ss");
        Long now = System.currentTimeMillis();
        fmt.setTimeZone(SystemVersion.getSystemTimeZone(this._context));
        String date = fmt.format(new Date(now));
        return date;
    }

    public List<UIMessages.Message> getMessages() {
        return this._messages.getMessages();
    }

    public void clearMessages() {
        this._messages.clear();
    }

    public void clearMessages(int id) {
        this._messages.clearThrough(id);
    }

    public boolean areFilesPublic() {
        return Boolean.parseBoolean(this._config.getProperty(PROP_FILES_PUBLIC));
    }

    @Override
    public boolean shouldAutoStart() {
        return Boolean.parseBoolean(this._config.getProperty(PROP_AUTO_START, Boolean.toString(this.DEFAULT_AUTO_START)));
    }

    public boolean isSmartSortEnabled() {
        String val = this._config.getProperty(PROP_SMART_SORT);
        if (val == null) {
            return false;
        }
        return Boolean.parseBoolean(val);
    }

    public boolean isCollapsePanelsEnabled() {
        String val = this._config.getProperty(PROP_COLLAPSE_PANELS);
        if (val == null) {
            return true;
        }
        return Boolean.parseBoolean(val);
    }

    public boolean isShowStatusFilter() {
        String val = this._config.getProperty(PROP_SHOW_STATUSFILTER);
        if (val == null) {
            return false;
        }
        return Boolean.parseBoolean(val);
    }

    public boolean isEnableLightbox() {
        String val = this._config.getProperty(PROP_ENABLE_LIGHTBOX);
        if (val == null) {
            return true;
        }
        return Boolean.parseBoolean(val);
    }

    public int getRefreshDelaySeconds() {
        try {
            return Integer.parseInt(this._config.getProperty(PROP_REFRESH_DELAY));
        }
        catch (NumberFormatException nfe) {
            return 5;
        }
    }

    public int getMaxFilesPerTorrent() {
        try {
            return Integer.parseInt(this._config.getProperty(PROP_MAX_FILES_PER_TORRENT));
        }
        catch (NumberFormatException nfe) {
            return 2000;
        }
    }

    public int getMaxLogMessages() {
        try {
            return Integer.parseInt(this._config.getProperty(PROP_MAX_MESSAGES));
        }
        catch (NumberFormatException nfe) {
            return 50;
        }
    }

    public int getPageSize() {
        try {
            return Integer.parseInt(this._config.getProperty(PROP_PAGE_SIZE));
        }
        catch (NumberFormatException nfe) {
            return 50;
        }
    }

    private int getStartupDelayMinutes() {
        if (!this._context.isRouterContext()) {
            return 0;
        }
        try {
            return Integer.parseInt(this._config.getProperty(PROP_STARTUP_DELAY));
        }
        catch (NumberFormatException nfe) {
            return 3;
        }
    }

    public File getDataDir() {
        String dir = this._config.getProperty(PROP_DIR, this._contextName);
        File f = this.areFilesPublic() ? new File(dir) : new SecureDirectory(dir);
        if (!f.isAbsolute()) {
            f = this.areFilesPublic() ? new File(this._context.getAppDir(), dir) : new SecureDirectory(this._context.getAppDir(), dir);
        }
        return f;
    }

    public File getConfigDir() {
        return this._configDir;
    }

    private File migrateConfig(File oldFile) {
        String oldDHT;
        File oldDHTFile;
        SecureDirectory dir = new SecureDirectory(oldFile + CONFIG_DIR_SUFFIX);
        if (!dir.exists() && !((File)dir).mkdirs()) {
            this._log.error("Error creating I2PSnark config dir " + dir);
            throw new RuntimeException("Error creating I2PSnark config dir " + dir);
        }
        String oldName = oldFile.toString();
        if (oldName.endsWith(CONFIG_FILE_SUFFIX) && (oldDHTFile = new File(oldDHT = oldName.replace(CONFIG_FILE_SUFFIX, ".dht.dat"))).exists()) {
            File newDHTFile = new File(dir, "i2psnark.dht.dat");
            FileUtil.rename(oldDHTFile, newDHTFile);
        }
        if (!oldFile.exists()) {
            return dir;
        }
        Properties oldProps = new Properties();
        try {
            DataHelper.loadProps(oldProps, oldFile);
            String auto = (String)oldProps.remove(PROP_OLD_AUTO_START);
            if (auto != null) {
                oldProps.setProperty(PROP_AUTO_START, auto);
            }
        }
        catch (IOException ioe) {
            this._log.error("Error loading I2PSnark config " + oldFile, ioe);
            return dir;
        }
        HashMap<String, Properties> configs = new HashMap<String, Properties>(16);
        Iterator<Map.Entry<Object, Object>> iter = oldProps.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Object, Object> entry = iter.next();
            String k = (String)entry.getKey();
            if (!k.startsWith(PROP_META_PREFIX)) continue;
            iter.remove();
            String v = (String)entry.getValue();
            try {
                k = k.substring(PROP_META_PREFIX.length());
                String h = k.substring(0, 28);
                k = k.substring(29);
                Properties tprops = (Properties)configs.get(h);
                if (tprops == null) {
                    tprops = new OrderedProperties();
                    configs.put(h, tprops);
                }
                if (k.equals(PROP_META_BITFIELD)) {
                    int comma = v.indexOf(44);
                    if (comma > 0 && v.length() > comma + 1) {
                        tprops.put(PROP_META_STAMP, v.substring(0, comma));
                        tprops.put(PROP_META_BITFIELD, v.substring(comma + 1));
                        continue;
                    }
                    tprops.put(PROP_META_STAMP, v);
                    continue;
                }
                tprops.put(k, v);
            }
            catch (IndexOutOfBoundsException ioobe) {}
        }
        for (Map.Entry<Object, Object> entry : configs.entrySet()) {
            File cfg;
            byte[] ih;
            String b64 = (String)entry.getKey();
            Properties props = (Properties)entry.getValue();
            if (props.isEmpty() || (ih = Base64.decode(b64 = b64.replace('$', '='))) == null || ih.length != 20 || (cfg = SnarkManager.configFile(dir, ih)).exists()) continue;
            File subdir = cfg.getParentFile();
            if (!subdir.exists()) {
                subdir.mkdirs();
            }
            try {
                DataHelper.storeProps(props, cfg);
            }
            catch (IOException ioe) {
                this._log.error("Error storing I2PSnark config " + cfg, ioe);
            }
        }
        File newFile = new File(dir, CONFIG_FILE);
        OrderedProperties orderedProperties = new OrderedProperties();
        orderedProperties.putAll((Map<?, ?>)oldProps);
        try {
            DataHelper.storeProps(orderedProperties, newFile);
        }
        catch (IOException ioe) {
            this._log.error("Error storing I2PSnark config " + newFile, ioe);
            return dir;
        }
        oldFile.delete();
        if (this._log.shouldWarn()) {
            this._log.warn("Legacy I2PSnark configuration file migrated from " + oldFile + " to " + dir);
        }
        return dir;
    }

    private Properties getConfig(Snark snark) {
        return this.getConfig(snark.getInfoHash());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getConfig(byte[] ih) {
        OrderedProperties rv = new OrderedProperties();
        File conf = SnarkManager.configFile(this._configDir, ih);
        Object object = this._configLock;
        synchronized (object) {
            try {
                I2PSnarkUtil.loadProps(rv, conf);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return rv;
    }

    private static File configFile(File confDir, byte[] ih) {
        String hex = I2PSnarkUtil.toHex(ih);
        SecureDirectory subdir = new SecureDirectory(confDir, SUBDIR_PREFIX + B64.charAt(ih[0] >> 2 & 0x3F));
        return new File(subdir, hex + CONFIG_FILE_SUFFIX);
    }

    private static File commentFile(File confDir, byte[] ih) {
        String hex = I2PSnarkUtil.toHex(ih);
        SecureDirectory subdir = new SecureDirectory(confDir, SUBDIR_PREFIX + B64.charAt(ih[0] >> 2 & 0x3F));
        return new File(subdir, hex + COMMENT_FILE_SUFFIX);
    }

    @Override
    public CommentSet getSavedComments(Snark snark) {
        block3: {
            File com = SnarkManager.commentFile(this._configDir, snark.getInfoHash());
            if (com.exists()) {
                try {
                    return new CommentSet(com);
                }
                catch (IOException ioe) {
                    if (!this._log.shouldWarn()) break block3;
                    this._log.warn("Comment load error", ioe);
                }
            }
        }
        return null;
    }

    @Override
    public void locked_saveComments(Snark snark, CommentSet comments) {
        block2: {
            File com = SnarkManager.commentFile(this._configDir, snark.getInfoHash());
            try {
                comments.save(com);
            }
            catch (IOException ioe) {
                if (!this._log.shouldWarn()) break block2;
                this._log.warn("Comment save error", ioe);
            }
        }
    }

    private static SHA1Hash configFileToInfoHash(File file) {
        String name = file.getName();
        if (name.length() != 40 + CONFIG_FILE_SUFFIX.length() || !name.endsWith(CONFIG_FILE_SUFFIX)) {
            return null;
        }
        String hex = name.substring(0, 40);
        byte[] ih = new byte[20];
        try {
            for (int i = 0; i < 20; ++i) {
                ih[i] = (byte)(Integer.parseInt(hex.substring(i * 2, i * 2 + 2), 16) & 0xFF);
            }
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        return new SHA1Hash(ih);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadConfig(String filename) {
        Object object = this._configLock;
        synchronized (object) {
            this.locked_loadConfig(filename);
        }
    }

    private void locked_loadConfig(String filename) {
        if (this._config == null) {
            this._config = new OrderedProperties();
        }
        if (filename != null) {
            File cfg = new File(filename);
            if (!cfg.isAbsolute()) {
                cfg = new File(this._context.getConfigDir(), filename);
            }
            this._configDir = this.migrateConfig(cfg);
            this._configFile = new File(this._configDir, CONFIG_FILE);
            if (this._configFile.exists()) {
                try {
                    DataHelper.loadProps(this._config, this._configFile);
                }
                catch (IOException ioe) {
                    this._log.error("Error loading I2PSnark config " + this._configFile, ioe);
                }
            }
        }
        if (!this._config.containsKey(PROP_I2CP_HOST)) {
            this._config.setProperty(PROP_I2CP_HOST, "127.0.0.1");
        }
        if (!this._config.containsKey(PROP_I2CP_PORT)) {
            this._config.setProperty(PROP_I2CP_PORT, Integer.toString(7654));
        }
        if (!this._config.containsKey(PROP_I2CP_OPTS)) {
            this._config.setProperty(PROP_I2CP_OPTS, "inbound.length=3 outbound.length=3 inbound.quantity=16 outbound.quantity=16");
        }
        if (!this._config.containsKey(PROP_UPLOADERS_TOTAL)) {
            this._config.setProperty(PROP_UPLOADERS_TOTAL, "50");
        }
        if (!this._config.containsKey(PROP_DIR)) {
            this._config.setProperty(PROP_DIR, this._contextName);
        }
        if (!this._config.containsKey(PROP_AUTO_START)) {
            this._config.setProperty(PROP_AUTO_START, Boolean.toString(this.DEFAULT_AUTO_START));
        }
        if (!this._config.containsKey(PROP_REFRESH_DELAY)) {
            this._config.setProperty(PROP_REFRESH_DELAY, Integer.toString(5));
        }
        if (!this._config.containsKey(PROP_STARTUP_DELAY)) {
            this._config.setProperty(PROP_STARTUP_DELAY, Integer.toString(3));
        }
        if (!this._config.containsKey(PROP_PAGE_SIZE)) {
            this._config.setProperty(PROP_PAGE_SIZE, Integer.toString(50));
        }
        if (!this._config.containsKey(PROP_THEME)) {
            this._config.setProperty(PROP_THEME, DEFAULT_THEME);
        }
        if (!this._config.containsKey(PROP_RATINGS)) {
            this._config.setProperty(PROP_RATINGS, DEFAULT_ENABLE_LIGHTBOX);
        }
        if (!this._config.containsKey(PROP_COMMENTS)) {
            this._config.setProperty(PROP_COMMENTS, DEFAULT_ENABLE_LIGHTBOX);
        }
        if (!this._config.containsKey(PROP_COMMENTS_NAME)) {
            this._config.setProperty(PROP_COMMENTS_NAME, "");
        }
        if (!this._config.containsKey(PROP_COLLAPSE_PANELS)) {
            this._config.setProperty(PROP_COLLAPSE_PANELS, Boolean.toString(true));
        }
        if (!this._config.containsKey(PROP_SHOW_STATUSFILTER)) {
            this._config.setProperty(PROP_SHOW_STATUSFILTER, "false");
        }
        if (!this._config.containsKey(PROP_ENABLE_LIGHTBOX)) {
            this._config.setProperty(PROP_ENABLE_LIGHTBOX, DEFAULT_ENABLE_LIGHTBOX);
        }
        this.updateConfig();
    }

    public boolean getUniversalTheming() {
        return this._context.getBooleanProperty(RC_PROP_UNIVERSAL_THEMING);
    }

    public String getTheme() {
        String theme;
        if (this.getUniversalTheming()) {
            theme = this._context.getProperty(RC_PROP_THEME, DEFAULT_THEME);
            String[] themes = this.getThemes();
            boolean themeExists = false;
            for (int i = 0; i < themes.length; ++i) {
                if (!themes[i].equals(theme)) continue;
                themeExists = true;
                break;
            }
            if (!themeExists) {
                theme = theme.equals("classic") ? "light" : DEFAULT_THEME;
                this._config.setProperty(PROP_THEME, DEFAULT_THEME);
            }
        } else {
            theme = this._config.getProperty(PROP_THEME, DEFAULT_THEME);
        }
        return theme;
    }

    public String[] getThemes() {
        String[] themes;
        if (this._context.isRouterContext()) {
            FileFilter fileFilter;
            File dir = new File(this._context.getBaseDir(), "docs/themes/snark");
            File[] dirnames = dir.listFiles(fileFilter = new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory();
                }
            });
            if (dirnames != null) {
                ArrayList<String> th = new ArrayList<String>(dirnames.length);
                for (int i = 0; i < dirnames.length; ++i) {
                    String name = dirnames[i].getName();
                    if (name.equals("images")) continue;
                    th.add(name);
                }
                themes = th.toArray(new String[th.size()]);
            } else {
                themes = new String[]{};
            }
        } else {
            themes = new String[]{"classic", "dark", "light", "midnight", DEFAULT_THEME, "vanilla", "zilvero"};
        }
        return themes;
    }

    private boolean getBWLimit() {
        int down;
        int[] limits = BWLimits.getBWLimits(this._util.getI2CPHost(), this._util.getI2CPPort());
        if (limits == null) {
            return false;
        }
        int up = limits[1];
        if (up > 0) {
            int maxup = this.getInt(PROP_UPBW_MAX, 1024);
            if (maxup > up) {
                maxup = up;
            }
            this._util.setMaxUpBW(maxup);
            this._bwManager.setUpBWLimit((long)maxup * 1000L);
        }
        if ((down = limits[0]) > 0) {
            int maxdown = this.getInt(PROP_DOWNBW_MAX, 1024);
            this._bwManager.setDownBWLimit((long)Math.min(down, maxdown) * 1000L);
        }
        return true;
    }

    private void updateConfig() {
        String i2cpHost = this._config.getProperty(PROP_I2CP_HOST);
        int i2cpPort = this.getInt(PROP_I2CP_PORT, 7654);
        String opts = this._config.getProperty(PROP_I2CP_OPTS);
        HashMap<String, String> i2cpOpts = new HashMap<String, String>();
        if (opts != null) {
            StringTokenizer tok = new StringTokenizer(opts, " ");
            while (tok.hasMoreTokens()) {
                String pair = tok.nextToken();
                int split = pair.indexOf(61);
                if (split <= 0) continue;
                i2cpOpts.put(pair.substring(0, split), pair.substring(split + 1));
            }
        }
        this._util.setI2CPConfig(i2cpHost, i2cpPort, i2cpOpts);
        String msg = this._t("Configuring I2PSnark with I2CP options") + ": " + i2cpOpts;
        if (this._log.shouldInfo()) {
            this._log.info(msg);
        }
        this._util.setMaxUploaders(this.getInt(PROP_UPLOADERS_TOTAL, 50));
        this._util.setMaxUpBW(this.getInt(PROP_UPBW_MAX, 1024));
        this._util.setMaxFilesPerTorrent(this.getInt(PROP_MAX_FILES_PER_TORRENT, 2000));
        this._util.setStartupDelay(this.getInt(PROP_STARTUP_DELAY, 3));
        this._util.setFilesPublic(this.areFilesPublic());
        this._util.setOpenTrackers(this.getListConfig(PROP_OPENTRACKERS, DEFAULT_OPENTRACKERS));
        String useOT = this._config.getProperty(PROP_USE_OPENTRACKERS);
        boolean bOT = useOT == null || Boolean.parseBoolean(useOT);
        this._util.setUseOpenTrackers(bOT);
        this._util.setUseDHT(Boolean.parseBoolean(this._config.getProperty(PROP_USE_DHT, Boolean.toString(true))));
        this._util.setRatingsEnabled(Boolean.parseBoolean(this._config.getProperty(PROP_RATINGS, DEFAULT_ENABLE_LIGHTBOX)));
        this._util.setCommentsEnabled(Boolean.parseBoolean(this._config.getProperty(PROP_COMMENTS, DEFAULT_ENABLE_LIGHTBOX)));
        this._util.setCommentsName(this._config.getProperty(PROP_COMMENTS_NAME, ""));
        this._util.setCollapsePanels(Boolean.parseBoolean(this._config.getProperty(PROP_COLLAPSE_PANELS, Boolean.toString(true))));
        this._util.setShowStatusFilter(Boolean.parseBoolean(this._config.getProperty(PROP_SHOW_STATUSFILTER, Boolean.toString(false))));
        this._util.setEnableLightbox(Boolean.parseBoolean(this._config.getProperty(PROP_ENABLE_LIGHTBOX, Boolean.toString(true))));
        File dd = this.getDataDir();
        if (dd.isDirectory()) {
            if (!dd.canWrite()) {
                msg = this._t("No write permissions for data directory") + ": " + dd;
                this.addMessage(msg);
                if (!this._context.isRouterContext()) {
                    System.out.println(" \u2022 " + msg);
                }
            }
        } else if (!dd.mkdirs()) {
            msg = this._t("Data directory cannot be created") + ": " + dd;
            this.addMessage(msg);
            if (!this._context.isRouterContext()) {
                System.out.println(" \u2022 " + msg);
            }
        }
        this.initTrackerMap();
        this.initTorrentCreateFilterMap();
    }

    private int getInt(String prop, int defaultVal) {
        String p = this._config.getProperty(prop);
        try {
            if (p != null && p.trim().length() > 0) {
                return Integer.parseInt(p.trim());
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return defaultVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConfig(String dataDir, boolean filesPublic, boolean autoStart, boolean smartSort, String refreshDelay, String startDelay, String pageSize, String seedPct, String eepHost, String eepPort, String i2cpHost, String i2cpPort, String i2cpOpts, String upLimit, String upBW, String downBW, boolean useOpenTrackers, boolean useDHT, String theme, String lang, boolean enableRatings, boolean enableComments, String commentName, boolean collapsePanels, boolean showStatusFilter, boolean enableLightbox, boolean enableAddCreate) {
        Object object = this._configLock;
        synchronized (object) {
            this.locked_updateConfig(dataDir, filesPublic, autoStart, smartSort, refreshDelay, startDelay, pageSize, seedPct, eepHost, eepPort, i2cpHost, i2cpPort, i2cpOpts, upLimit, upBW, downBW, useOpenTrackers, useDHT, theme, lang, enableRatings, enableComments, commentName, collapsePanels, showStatusFilter, enableLightbox, enableAddCreate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void locked_updateConfig(String dataDir, boolean filesPublic, boolean autoStart, boolean smartSort, String refreshDelay, String startDelay, String pageSize, String seedPct, String eepHost, String eepPort, String i2cpHost, String i2cpPort, String i2cpOpts, String upLimit, String upBW, String downBW, boolean useOpenTrackers, boolean useDHT, String theme, String lang, boolean enableRatings, boolean enableComments, String commentName, boolean collapsePanels, boolean showStatusFilter, boolean enableLightbox, boolean enableAddCreate) {
        boolean interruptMonitor;
        boolean changed;
        block130: {
            block132: {
                String msg;
                int port;
                block134: {
                    HashMap<String, String> oldOpts;
                    HashMap<String, String> opts;
                    String oldI2CPHost;
                    int oldI2CPPort;
                    block133: {
                        boolean reconnect;
                        block131: {
                            Object msg22;
                            int limit;
                            changed = false;
                            interruptMonitor = false;
                            if (upLimit != null) {
                                limit = this._util.getMaxUploaders();
                                try {
                                    limit = Integer.parseInt(upLimit.trim());
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                                if (limit != this._util.getMaxUploaders()) {
                                    if (limit >= 4) {
                                        this._util.setMaxUploaders(limit);
                                        changed = true;
                                        this._config.setProperty(PROP_UPLOADERS_TOTAL, Integer.toString(limit));
                                        msg22 = this._t("Total uploaders limit changed to {0}", limit);
                                        this.addMessage((String)msg22);
                                        if (!this._context.isRouterContext()) {
                                            System.out.println(" \u2022 " + (String)msg22);
                                        }
                                    } else {
                                        msg22 = this._t("Minimum total uploaders limit is {0}", 4);
                                        this.addMessage((String)msg22);
                                        if (!this._context.isRouterContext()) {
                                            System.out.println(" \u2022 " + (String)msg22);
                                        }
                                    }
                                }
                            }
                            if (upBW != null) {
                                limit = this._util.getMaxUpBW();
                                try {
                                    limit = Integer.parseInt(upBW.trim());
                                }
                                catch (NumberFormatException msg22) {
                                    // empty catch block
                                }
                                if (limit != this._util.getMaxUpBW()) {
                                    if (limit >= 30) {
                                        this._util.setMaxUpBW(limit);
                                        this._bwManager.setUpBWLimit((long)limit * 1000L);
                                        changed = true;
                                        this._config.setProperty(PROP_UPBW_MAX, Integer.toString(limit));
                                        msg22 = this._t("Up BW limit changed to {0}KBps", limit);
                                        this.addMessage((String)msg22);
                                        if (!this._context.isRouterContext()) {
                                            System.out.println(" \u2022 " + (String)msg22);
                                        }
                                    } else {
                                        msg22 = this._t("Minimum up bandwidth limit is {0}KBps", 30);
                                        this.addMessage((String)msg22);
                                        if (!this._context.isRouterContext()) {
                                            System.out.println(" \u2022 " + (String)msg22);
                                        }
                                    }
                                }
                            }
                            if (downBW != null) {
                                limit = (int)(this._bwManager.getDownBWLimit() / 1024L);
                                try {
                                    limit = Integer.parseInt(downBW.trim());
                                }
                                catch (NumberFormatException msg3) {
                                    // empty catch block
                                }
                                if ((long)limit != this._bwManager.getDownBWLimit() && limit >= 60) {
                                    this._bwManager.setDownBWLimit((long)limit * 1000L);
                                    changed = true;
                                    this._config.setProperty(PROP_DOWNBW_MAX, Integer.toString(limit));
                                }
                            }
                            if (startDelay != null && this._context.isRouterContext()) {
                                int minutes = this._util.getStartupDelay();
                                try {
                                    minutes = Integer.parseInt(startDelay.trim());
                                }
                                catch (NumberFormatException msg3) {
                                    // empty catch block
                                }
                                if (minutes != this._util.getStartupDelay()) {
                                    this._util.setStartupDelay(minutes);
                                    changed = true;
                                    this._config.setProperty(PROP_STARTUP_DELAY, Integer.toString(minutes));
                                    msg22 = this._t("Startup delay changed to {0}", DataHelper.formatDuration2((long)minutes * 60000L));
                                    this.addMessageNoEscape((String)msg22);
                                    if (!this._context.isRouterContext()) {
                                        System.out.println(" \u2022 " + (String)msg22);
                                    }
                                }
                            }
                            if (refreshDelay != null) {
                                try {
                                    int secs = Integer.parseInt(refreshDelay.trim());
                                    if (secs != this.getRefreshDelaySeconds()) {
                                        changed = true;
                                        this._config.setProperty(PROP_REFRESH_DELAY, Integer.toString(secs));
                                        if (secs >= 0) {
                                            msg22 = this._t("Refresh time changed to {0}", DataHelper.formatDuration2(secs * 1000));
                                            this.addMessageNoEscape((String)msg22);
                                            if (!this._context.isRouterContext()) {
                                                System.out.println(" \u2022 " + ((String)msg22).replace("&nbsp;", " "));
                                            }
                                        } else {
                                            msg22 = this._t("Refresh disabled");
                                            this.addMessage((String)msg22);
                                            if (!this._context.isRouterContext()) {
                                                System.out.println(" \u2022 " + (String)msg22);
                                            }
                                        }
                                    }
                                }
                                catch (NumberFormatException secs) {
                                    // empty catch block
                                }
                            }
                            if (pageSize != null) {
                                try {
                                    int size = Integer.parseInt(pageSize.trim());
                                    if (size <= 0) {
                                        size = 999999;
                                    } else if (size < 5) {
                                        size = 5;
                                    }
                                    if (size != this.getPageSize()) {
                                        changed = true;
                                        pageSize = Integer.toString(size);
                                        this._config.setProperty(PROP_PAGE_SIZE, pageSize);
                                        this.addMessage(this._t("Page size changed to {0}", pageSize));
                                    }
                                }
                                catch (NumberFormatException size) {
                                    // empty catch block
                                }
                            }
                            if (this.areFilesPublic() != filesPublic) {
                                String msg4;
                                this._config.setProperty(PROP_FILES_PUBLIC, Boolean.toString(filesPublic));
                                this._util.setFilesPublic(filesPublic);
                                if (filesPublic) {
                                    msg4 = this._t("New files will be publicly readable");
                                    this.addMessage(msg4);
                                    if (!this._context.isRouterContext()) {
                                        System.out.println(" \u2022 " + msg4);
                                    }
                                } else {
                                    msg4 = this._t("New files will not be publicly readable");
                                    this.addMessage(msg4);
                                    if (!this._context.isRouterContext()) {
                                        System.out.println(" \u2022 " + msg4);
                                    }
                                }
                                changed = true;
                            }
                            if (dataDir != null && !dataDir.equals(this.getDataDir().getAbsolutePath())) {
                                File dd;
                                dataDir = DataHelper.stripHTML(dataDir.trim());
                                File file = dd = this.areFilesPublic() ? new File(dataDir) : new SecureDirectory(dataDir);
                                if (this._util.connected()) {
                                    this.addMessage(this._t("Stop all torrents before changing data directory"));
                                } else if (!dd.isAbsolute()) {
                                    this.addMessage(this._t("Data directory must be an absolute path") + ": " + dataDir);
                                } else if (!dd.exists() && !dd.mkdirs()) {
                                    msg22 = this._t("Data directory cannot be created") + ": " + dataDir;
                                    this.addMessage((String)msg22);
                                    if (!this._context.isRouterContext()) {
                                        System.out.println(" \u2022 " + (String)msg22);
                                    }
                                } else if (!dd.isDirectory()) {
                                    msg22 = this._t("Not a directory") + ": " + dataDir;
                                    this.addMessage((String)msg22);
                                    if (!this._context.isRouterContext()) {
                                        System.out.println(" \u2022 " + (String)msg22);
                                    }
                                } else if (!dd.canRead()) {
                                    msg22 = this._t("Unreadable") + ": " + dataDir;
                                    this.addMessage((String)msg22);
                                    if (!this._context.isRouterContext()) {
                                        System.out.println(" \u2022 " + (String)msg22);
                                    }
                                } else {
                                    if (!dd.canWrite()) {
                                        msg22 = this._t("No write permissions for data directory") + ": " + dataDir;
                                        this.addMessage((String)msg22);
                                        if (!this._context.isRouterContext()) {
                                            System.out.println(" \u2022 " + (String)msg22);
                                        }
                                    }
                                    changed = true;
                                    interruptMonitor = true;
                                    msg22 = this._snarks;
                                    synchronized (msg22) {
                                        for (Snark snark : this._snarks.values()) {
                                            if (snark.getMetaInfo() == null) continue;
                                            this.stopTorrent(snark, true);
                                        }
                                        this._config.setProperty(PROP_DIR, dataDir);
                                    }
                                    msg22 = this._t("Data directory changed to {0}", dataDir);
                                    this.addMessage((String)msg22);
                                    if (!this._context.isRouterContext()) {
                                        System.out.println(" \u2022 " + (String)msg22);
                                    }
                                }
                            }
                            if (lang != null && !this._context.isRouterContext() && lang.length() >= 2 && lang.length() <= 6) {
                                String ncountry;
                                String nlang;
                                int under = lang.indexOf(95);
                                if (under > 0 && lang.length() > under + 1) {
                                    nlang = lang.substring(0, under);
                                    ncountry = lang.substring(under + 1);
                                } else {
                                    nlang = lang;
                                    ncountry = "";
                                }
                                String olang = this._config.getProperty(PROP_LANG);
                                String ocountry = this._config.getProperty(PROP_COUNTRY);
                                if (!nlang.equals(olang) || !ncountry.equals(ocountry)) {
                                    changed = true;
                                    this._config.setProperty(PROP_LANG, nlang);
                                    this._config.setProperty(PROP_COUNTRY, ncountry);
                                    Translate.setLanguage(nlang, ncountry);
                                }
                            }
                            oldI2CPPort = this._util.getI2CPPort();
                            oldI2CPHost = this._util.getI2CPHost();
                            port = oldI2CPPort;
                            if (i2cpPort != null) {
                                try {
                                    port = Integer.parseInt(i2cpPort);
                                }
                                catch (NumberFormatException olang) {
                                    // empty catch block
                                }
                            }
                            opts = new HashMap<String, String>();
                            i2cpOpts = DataHelper.stripHTML(i2cpOpts);
                            StringTokenizer tok = new StringTokenizer(i2cpOpts, " \t\n");
                            while (tok.hasMoreTokens()) {
                                String pair = tok.nextToken();
                                int split = pair.indexOf(61);
                                if (split <= 0) continue;
                                opts.put(pair.substring(0, split), pair.substring(split + 1));
                            }
                            oldOpts = new HashMap<String, String>();
                            String oldI2CPOpts = this._config.getProperty(PROP_I2CP_OPTS);
                            if (oldI2CPOpts == null) {
                                oldI2CPOpts = "";
                            }
                            tok = new StringTokenizer(oldI2CPOpts, " \t\n");
                            while (tok.hasMoreTokens()) {
                                String pair = tok.nextToken();
                                int split = pair.indexOf(61);
                                if (split <= 0) continue;
                                oldOpts.put(pair.substring(0, split), pair.substring(split + 1));
                            }
                            boolean bl = reconnect = i2cpHost != null && i2cpHost.trim().length() > 0 && port > 0 && (port != this._util.getI2CPPort() || !oldI2CPHost.equals(i2cpHost));
                            if (!reconnect && oldOpts.equals(opts)) break block130;
                            boolean snarksActive = false;
                            if (reconnect) {
                                for (Snark snark : this._snarks.values()) {
                                    if (snark.isStopped()) continue;
                                    snarksActive = true;
                                    break;
                                }
                            }
                            if (this._log.shouldDebug()) {
                                this._log.debug("i2cp host [" + i2cpHost + "] i2cp port " + port + " opts [" + opts + "] oldOpts [" + oldOpts + "]");
                            }
                            if (!snarksActive) break block131;
                            Properties p = new Properties();
                            p.putAll((Map<?, ?>)opts);
                            this._util.setI2CPConfig(i2cpHost, port, p);
                            int max = this.getInt(PROP_UPBW_MAX, 1024);
                            this._util.setMaxUpBW(max);
                            this._bwManager.setUpBWLimit(max * 1000);
                            String msg5 = this._t("I2CP and tunnel changes will take effect after stopping all torrents");
                            this.addMessage(msg5);
                            if (this._context.isRouterContext()) break block132;
                            System.out.println(" \u2022 " + msg5);
                            break block132;
                        }
                        if (reconnect) break block133;
                        this._config.setProperty(PROP_I2CP_OPTS, i2cpOpts.trim());
                        msg = this._t("I2CP options changed to {0}", i2cpOpts);
                        this.addMessage(msg);
                        if (!this._context.isRouterContext()) {
                            System.out.println(" \u2022 " + msg);
                        }
                        this._util.setI2CPConfig(oldI2CPHost, oldI2CPPort, opts);
                        break block132;
                    }
                    if (this._util.connected()) {
                        this._util.disconnect();
                        msg = this._t("Disconnecting old I2CP destination");
                        this.addMessage(msg);
                        if (!this._context.isRouterContext()) {
                            System.out.println(" \u2022 " + msg);
                        }
                    }
                    msg = this._t("I2CP settings changed to {0}", i2cpHost + ':' + port + ' ' + i2cpOpts);
                    this.addMessage(msg);
                    if (!this._context.isRouterContext()) {
                        System.out.println(" \u2022 " + msg);
                    }
                    this._util.setI2CPConfig(i2cpHost, port, opts);
                    int max = this.getInt(PROP_UPBW_MAX, 1024);
                    this._util.setMaxUpBW(max);
                    this._bwManager.setUpBWLimit(max * 1000);
                    boolean ok = this._util.connect();
                    if (ok) break block134;
                    msg = this._t("Unable to connect with the new settings, reverting to the old I2CP settings");
                    this.addMessage(msg);
                    if (!this._context.isRouterContext()) {
                        System.out.println(" \u2022 " + msg);
                    }
                    this._util.setI2CPConfig(oldI2CPHost, oldI2CPPort, oldOpts);
                    ok = this._util.connect();
                    if (ok) break block132;
                    msg = this._t("Unable to reconnect with the old settings!");
                    this.addMessage(msg);
                    if (!this._context.isRouterContext()) {
                        System.out.println(" \u2022 " + msg);
                    }
                    break block132;
                }
                msg = this._t("Reconnected on the new I2CP destination");
                this.addMessage(msg);
                if (!this._context.isRouterContext()) {
                    System.out.println(" \u2022 " + msg);
                }
                this._config.setProperty(PROP_I2CP_HOST, i2cpHost.trim());
                this._config.setProperty(PROP_I2CP_PORT, "" + port);
                this._config.setProperty(PROP_I2CP_OPTS, i2cpOpts.trim());
                for (Snark snark : this._snarks.values()) {
                    if (!snark.restartAcceptor()) continue;
                    msg = this._t("I2CP listener restarted for \"{0}\"", snark.getBaseName());
                    this.addMessage(msg);
                    if (this._context.isRouterContext()) break;
                    System.out.println(" \u2022 " + msg);
                    break;
                }
            }
            changed = true;
        }
        if (this.shouldAutoStart() != autoStart) {
            this._config.setProperty(PROP_AUTO_START, Boolean.toString(autoStart));
            if (autoStart) {
                this.addMessage(this._t("Enabled autostart"));
            } else {
                this.addMessage(this._t("Disabled autostart"));
            }
            changed = true;
        }
        if (this.isSmartSortEnabled() != smartSort) {
            this._config.setProperty(PROP_SMART_SORT, Boolean.toString(smartSort));
            if (smartSort) {
                this.addMessage(this._t("Enabled smart sort") + ".");
            } else {
                this.addMessage(this._t("Disabled smart sort") + ".");
            }
            changed = true;
        }
        if (this._util.shouldUseOpenTrackers() != useOpenTrackers) {
            String msg;
            this._config.setProperty(PROP_USE_OPENTRACKERS, useOpenTrackers + "");
            if (useOpenTrackers) {
                msg = this._t("Enabled open trackers - torrent restart required to take effect.");
                this.addMessage(msg);
                if (!this._context.isRouterContext()) {
                    System.out.println(" \u2022 " + msg);
                }
            } else {
                msg = this._t("Disabled open trackers - torrent restart required to take effect.");
                this.addMessage(msg);
                if (!this._context.isRouterContext()) {
                    System.out.println(" \u2022 " + msg);
                }
            }
            this._util.setUseOpenTrackers(useOpenTrackers);
            changed = true;
        }
        if (this._util.shouldUseDHT() != useDHT) {
            this._config.setProperty(PROP_USE_DHT, Boolean.toString(useDHT));
            if (useDHT) {
                this.addMessage(this._t("Enabled DHT."));
            } else {
                this.addMessage(this._t("Disabled DHT."));
            }
            if (this._util.connected()) {
                String msg = this._t("DHT change requires tunnel shutdown and reopen") + ".";
                this.addMessage(msg);
                if (!this._context.isRouterContext()) {
                    System.out.println(" \u2022 " + msg);
                }
            }
            this._util.setUseDHT(useDHT);
            changed = true;
        }
        if (this._util.ratingsEnabled() != enableRatings) {
            this._config.setProperty(PROP_RATINGS, Boolean.toString(enableRatings));
            if (enableRatings) {
                this.addMessage(this._t("Enabled Ratings."));
            } else {
                this.addMessage(this._t("Disabled Ratings."));
            }
            this._util.setRatingsEnabled(enableRatings);
            changed = true;
        }
        if (this._util.commentsEnabled() != enableComments) {
            this._config.setProperty(PROP_COMMENTS, Boolean.toString(enableComments));
            if (enableComments) {
                this.addMessage(this._t("Enabled Comments."));
            } else {
                this.addMessage(this._t("Disabled Comments."));
            }
            this._util.setCommentsEnabled(enableComments);
            changed = true;
        }
        if (commentName == null) {
            commentName = "";
        } else if ((commentName = commentName.trim().replaceAll("[\n\r<>#;]", "")).length() > 32) {
            commentName = commentName.substring(0, 32);
        }
        if (!this._util.getCommentsName().equals(commentName)) {
            this._config.setProperty(PROP_COMMENTS_NAME, commentName);
            this.addMessage(this._t("Comments name set to {0}.", '\"' + commentName + '\"'));
            this._util.setCommentsName(commentName);
            changed = true;
        }
        if (theme != null && !theme.equals(this._config.getProperty(PROP_THEME))) {
            this._config.setProperty(PROP_THEME, theme);
            changed = true;
        }
        if (this._util.collapsePanels() != collapsePanels) {
            this._config.setProperty(PROP_COLLAPSE_PANELS, Boolean.toString(collapsePanels));
            if (collapsePanels) {
                this.addMessage(this._t("Collapsible panels enabled."));
            } else {
                this.addMessage(this._t("Collapsible panels disabled."));
            }
            this._util.setCollapsePanels(collapsePanels);
            changed = true;
        }
        if (this._util.showStatusFilter() != showStatusFilter) {
            this._config.setProperty(PROP_SHOW_STATUSFILTER, Boolean.toString(showStatusFilter));
            if (this.getRefreshDelaySeconds() > 0) {
                if (showStatusFilter) {
                    this.addMessage(this._t("Torrent filter bar enabled."));
                } else {
                    this.addMessage(this._t("Torrent filter bar disabled."));
                }
                this._util.setShowStatusFilter(showStatusFilter);
                changed = true;
            }
        }
        if (this._util.enableLightbox() != enableLightbox) {
            this._config.setProperty(PROP_ENABLE_LIGHTBOX, Boolean.toString(enableLightbox));
            if (enableLightbox) {
                this.addMessage(this._t("Lightbox enabled for image thumbnails."));
            } else {
                this.addMessage(this._t("Lightbox disabled for image thumbnails."));
            }
            this._util.setEnableLightbox(enableLightbox);
            changed = true;
        }
        if (this._util.enableAddCreate() != enableAddCreate) {
            this._config.setProperty(PROP_ENABLE_ADDCREATE, Boolean.toString(enableAddCreate));
            if (enableAddCreate) {
                this.addMessage(this._t("Add and Create sections enabled on all torrent listing pages."));
            } else {
                this.addMessage(this._t("Add and Create sections to display only on first page of multipage torrent listing pages."));
            }
            this._util.setEnableAddCreate(enableAddCreate);
            changed = true;
        }
        if (changed) {
            this.saveConfig();
            if (interruptMonitor) {
                this._monitor.interrupt();
            }
        } else {
            this.addMessage(this._t("Configuration unchanged."));
        }
    }

    private List<String> getOpenTrackers() {
        if (!this._util.shouldUseOpenTrackers()) {
            return Collections.emptyList();
        }
        return this.getListConfig(PROP_OPENTRACKERS, DEFAULT_OPENTRACKERS);
    }

    public List<String> getPrivateTrackers() {
        return this.getListConfig(PROP_PRIVATETRACKERS, null);
    }

    public void saveOpenTrackers(List<String> ot) {
        this.setListConfig(PROP_OPENTRACKERS, ot);
        if (ot == null) {
            ot = this.getListConfig(PROP_OPENTRACKERS, DEFAULT_OPENTRACKERS);
        }
        this._util.setOpenTrackers(ot);
        String msg = this._t("Open Tracker list changed - torrent restart required to take effect.");
        this.addMessage(msg);
        if (!this._context.isRouterContext()) {
            System.out.println(" \u2022 " + msg);
        }
        this.saveConfig();
    }

    public void savePrivateTrackers(List<String> pt) {
        this.setListConfig(PROP_PRIVATETRACKERS, pt);
        String msg = this._t("Private tracker list changed - affects newly created torrents only.");
        this.addMessage(msg);
        if (!this._context.isRouterContext()) {
            System.out.println(" \u2022 " + msg);
        }
        this.saveConfig();
    }

    private List<String> getListConfig(String prop, String dflt) {
        String val = this._config.getProperty(prop);
        if (val == null) {
            val = dflt;
        }
        if (val == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(DataHelper.split(val, ","));
    }

    private String setListConfig(String prop, List<String> values) {
        if (values == null || values.isEmpty()) {
            this._config.remove(prop);
            return "";
        }
        StringBuilder buf = new StringBuilder(64);
        for (String s : values) {
            if (buf.length() > 0) {
                buf.append(',');
            }
            buf.append(s);
        }
        String rv = buf.toString();
        this._config.setProperty(prop, rv);
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveConfig() {
        block5: {
            try {
                Object object = this._configLock;
                synchronized (object) {
                    DataHelper.storeProps(this._config, this._configFile);
                }
            }
            catch (IOException ioe) {
                String msg = this._t("Unable to save the config to {0}", this._configFile.getAbsolutePath());
                this.addMessage(msg);
                if (this._context.isRouterContext()) break block5;
                System.out.println(" \u2022 " + msg);
            }
        }
    }

    public Set<String> listTorrentFiles() {
        return new HashSet<String>(this._snarks.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Snark getTorrent(String filename) {
        Map<String, Snark> map = this._snarks;
        synchronized (map) {
            return this._snarks.get(filename);
        }
    }

    public Collection<Snark> getTorrents() {
        return Collections.unmodifiableCollection(this._snarks.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Snark getTorrentByBaseName(String filename) {
        Map<String, Snark> map = this._snarks;
        synchronized (map) {
            return this._filteredBaseNameToSnark.get(filename);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Snark getTorrentByInfoHash(byte[] infohash) {
        Map<String, Snark> map = this._snarks;
        synchronized (map) {
            return this._infoHashToSnark.get(new SHA1Hash(infohash));
        }
    }

    private void putSnark(String torrentFile, Snark snark) {
        this._snarks.put(torrentFile, snark);
        this._infoHashToSnark.put(new SHA1Hash(snark.getInfoHash()), snark);
        Storage storage = snark.getStorage();
        if (storage != null) {
            this._filteredBaseNameToSnark.put(storage.getBaseName(), snark);
        }
    }

    private void removeSnark(Snark snark) {
        this._snarks.remove(snark.getName());
        this._infoHashToSnark.remove(new SHA1Hash(snark.getInfoHash()));
        Storage storage = snark.getStorage();
        if (storage != null) {
            this._filteredBaseNameToSnark.remove(storage.getBaseName());
        }
    }

    private Snark removeSnark(String torrentFile) {
        Snark snark = this._snarks.remove(torrentFile);
        if (snark != null) {
            this._infoHashToSnark.remove(new SHA1Hash(snark.getInfoHash()));
            Storage storage = snark.getStorage();
            if (storage != null) {
                this._filteredBaseNameToSnark.remove(storage.getBaseName());
            }
        }
        return snark;
    }

    private void disableTorrentFile(String torrentFile) {
        File sfile = new File(torrentFile);
        File rename = new File(torrentFile + ".BAD");
        if (rename.exists()) {
            if (sfile.delete()) {
                String msg = this._t("Torrent file deleted: {0}", sfile.toString());
                this.addMessage(msg);
                if (!this._context.isRouterContext()) {
                    System.out.println(" \u2022 " + msg);
                }
            } else if (FileUtil.rename(sfile, rename)) {
                String msg = this._t("Torrent file moved from {0} to {1}", sfile.toString(), rename.toString());
                this.addMessage(msg);
                if (!this._context.isRouterContext()) {
                    System.out.println(" \u2022 " + msg);
                }
            }
        }
    }

    private boolean addTorrent(String filename, File baseFile, boolean dontAutoStart) {
        return this.addTorrent(filename, baseFile, dontAutoStart, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean addTorrent(String filename, File baseFile, boolean dontAutoStart, File dataDir) {
        block67: {
            sfile = new File(filename);
            try {
                filename = sfile.getCanonicalPath();
            }
            catch (IOException ioe) {
                this._log.error("Unable to add torrent: " + filename + " (" + ioe.getMessage() + ")");
                msg = this._t("Error: Could not add torrent: {0}", filename) + " (" + ioe.getMessage() + ")";
                this.addMessage(msg);
                if (this._context.isRouterContext() != false) return false;
                System.out.println(" \u2022 " + msg);
                return false;
            }
            if (dataDir == null) {
                dataDir = this.getDataDir();
            }
            var8_15 = this._snarks;
            synchronized (var8_15) {
                torrent = this._snarks.get(filename);
                ** if (torrent == null) goto lbl23
            }
lbl-1000:
            // 1 sources

            {
                msg = this._t("Torrent already running: {0}", filename);
                this.addMessage(msg);
                if (this._context.isRouterContext() != false) return false;
                System.out.println(" \u2022 " + msg);
                return false;
            }
lbl23:
            // 1 sources

            var8_15 = this._addSnarkLock;
            synchronized (var8_15) {
                block66: {
                    block65: {
                        var9_16 = this._snarks;
                        synchronized (var9_16) {
                            if (this._snarks.get(filename) != null) {
                                msg = this._t("Torrent already running: {0}", filename);
                                this.addMessage(msg);
                                if (this._context.isRouterContext() != false) return false;
                                System.out.println(" \u2022 " + msg);
                                return false;
                            }
                        }
                        fis = null;
                        try {
                            fis = new FileInputStream(sfile);
                        }
                        catch (IOException ioe) {
                            msg = this._t("Cannot open \"{0}\"", sfile.getName()) + ": " + ioe.getLocalizedMessage();
                            this.addMessage(msg);
                            if (this._context.isRouterContext() != false) return false;
                            System.out.println(" \u2022 " + msg);
                            return false;
                        }
                        try {
                            info = new MetaInfo(fis);
                            try {
                                fis.close();
                                fis = null;
                            }
                            catch (IOException var11_23) {
                                // empty catch block
                            }
                            snark = this.getTorrentByInfoHash(info.getInfoHash());
                            if (snark != null) {
                                msg = this._t("Torrent with this info hash is already running: {0}", snark.getBaseName());
                                this.addMessage(msg);
                                if (!this._context.isRouterContext()) {
                                    System.out.println(" \u2022 " + msg);
                                }
                                var12_29 = false;
                                break block65;
                            }
                            filtered = Storage.filterName(info.getName());
                            snark = this.getTorrentByBaseName(filtered);
                            if (snark != null) {
                                msg = this._t("Torrent with the same data location is already running: {0}", snark.getBaseName());
                                this.addMessage(msg);
                                if (!this._context.isRouterContext()) {
                                    System.out.println(" \u2022 " + msg);
                                }
                                var13_34 = false;
                                break block66;
                            }
                            if (!TrackerClient.isValidAnnounce(info.getAnnounce())) {
                                if (info.isPrivate()) {
                                    msg = this._t("ERROR - No I2P trackers in private torrent \"{0}\"", info.getName());
                                } else if (!this._util.getOpenTrackers().isEmpty()) {
                                    msg = this._t("Warning - No I2P trackers in \"{0}\", will announce to I2P open trackers and DHT only.", info.getName());
                                } else if (this._util.shouldUseDHT()) {
                                    msg = this._t("Warning - No I2P trackers in \"{0}\", and open trackers are disabled, will announce to DHT only.", info.getName());
                                } else {
                                    msg = this._t("Warning - No I2P trackers in \"{0}\", and DHT and open trackers are disabled, you should enable open trackers or DHT before starting the torrent.", info.getName());
                                    dontAutoStart = true;
                                }
                                this.addMessage(msg);
                                if (!this._context.isRouterContext()) {
                                    System.out.println(" \u2022 " + msg);
                                }
                            }
                            if ((rejectMessage = this.validateTorrent(info)) != null) {
                                throw new IOException(rejectMessage);
                            }
                            if (baseFile == null) {
                                baseFile = this.getSavedBaseFile(info.getInfoHash());
                            }
                            if (this._log.shouldInfo()) {
                                this._log.info("New Snark loaded\n* Torrent: " + filename + "\n* Base: " + baseFile);
                            }
                            torrent = new Snark(this._util, filename, null, -1, null, null, this, this._peerCoordinatorSet, this._connectionAcceptor, dataDir.getPath(), baseFile);
                            this.loadSavedFilePriorities(torrent);
                            var14_38 = this._snarks;
                            synchronized (var14_38) {
                                this.putSnark(filename, torrent);
                                break block67;
                            }
                        }
                        catch (IOException ioe) {
                            if (fis != null) {
                                try {
                                    fis.close();
                                    fis = null;
                                }
                                catch (IOException snark) {
                                    // empty catch block
                                }
                            }
                            err = this._t("Torrent in \"{0}\" is invalid", sfile.toString()) + ": " + ioe.getLocalizedMessage();
                            this.addMessage(err);
                            if (!this._context.isRouterContext()) {
                                System.out.println(" \u2022 " + err);
                            }
                            this._log.error(err, ioe);
                            this.disableTorrentFile(filename);
                            filtered = false;
                            return filtered;
                        }
                        catch (OutOfMemoryError oom) {
                            s = this._t("ERROR - Out of memory, cannot create torrent from {0}", sfile.getName()) + ": " + oom.getLocalizedMessage();
                            this.addMessage(s);
                            throw new Snark.RouterException(s, oom);
                        }
                    }
                    return var12_29;
                }
                return var13_34;
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException var13_36) {}
                    }
                }
            }
        }
        config = this.getConfig(torrent);
        prop = config.getProperty("running");
        running = prop == null || Boolean.parseBoolean(prop) != false;
        prop = config.getProperty("activity");
        if (prop != null && torrent.getStorage() != null) {
            try {
                activity = Long.parseLong(prop);
                torrent.getStorage().setActivity(activity);
            }
            catch (NumberFormatException activity) {
                // empty catch block
            }
        }
        link = this.linkify(torrent).replace(" ", "%20").replace("a%20href", "a href");
        if (!dontAutoStart && this.shouldAutoStart() && running) {
            if (!this._util.connected()) {
                msg = this._t("Initializing I2PSnark and opening tunnels") + "...";
                if (!this._context.isRouterContext()) {
                    System.out.println(" \u2022 " + msg);
                }
                if (!(ok = this._util.connect())) {
                    if (this._context.isRouterContext()) {
                        this.addMessage(this._t("Unable to connect to I2P"));
                    } else {
                        msg = this._t("Error connecting to I2P - check your I2CP settings!") + ' ' + this._util.getI2CPHost() + ':' + this._util.getI2CPPort();
                        this.addMessage(msg);
                        System.out.println(" \u2022 " + msg);
                    }
                }
            }
            torrent.startTorrent();
            this.addMessageNoEscape(this._t("Torrent added and started: {0}", link));
            if (this._context.isRouterContext() != false) return true;
            System.out.println(" \u2022 " + this._t("Torrent added and started: {0}", torrent.getBaseName()));
            return true;
        }
        this.addMessageNoEscape(this._t("Torrent added: {0}", link));
        if (this._context.isRouterContext() != false) return true;
        System.out.println(" \u2022 " + this._t("Torrent added: {0}", torrent.getBaseName()));
        return true;
    }

    public void addMagnet(String name, byte[] ih, String trackerURL, boolean updateStatus) {
        this.addMagnet(name, ih, trackerURL, updateStatus, updateStatus, null, this);
    }

    public void addMagnet(String name, byte[] ih, String trackerURL, boolean updateStatus, File dataDir) {
        this.addMagnet(name, ih, trackerURL, updateStatus, updateStatus, dataDir, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Snark addMagnet(String name, byte[] ih, String trackerURL, boolean updateStatus, boolean autoStart, File dataDir, CompleteListener listener) {
        String dirPath = dataDir != null ? dataDir.getAbsolutePath() : this.getDataDir().getPath();
        Snark torrent = new Snark(this._util, name, ih, trackerURL, listener, this._peerCoordinatorSet, this._connectionAcceptor, dirPath);
        Map<String, Snark> map = this._snarks;
        synchronized (map) {
            Snark snark = this.getTorrentByInfoHash(ih);
            if (snark != null) {
                String msg = this._t("Torrent with this info hash is already running: {0}", snark.getBaseName());
                this.addMessage(msg);
                if (!this._context.isRouterContext()) {
                    System.out.println(" \u2022 " + msg);
                }
                return null;
            }
            this._magnets.add(name);
            if (updateStatus) {
                this.saveMagnetStatus(ih, dirPath, trackerURL, name);
            }
            this.putSnark(name, torrent);
        }
        if (autoStart) {
            boolean shouldWarn;
            this.startTorrent(ih);
            DHT dht = this._util.getDHT();
            boolean bl = shouldWarn = this._util.connected() && this._util.getOpenTrackers().isEmpty() && (!this._util.shouldUseDHT() || dht == null || dht.size() <= 0);
            if (shouldWarn) {
                String msg = this._t("Open trackers are disabled and we have no DHT peers. Fetch of {0} may not succeed until you start another torrent, enable open trackers, or enable DHT.", name);
                this.addMessage(msg);
                if (!this._context.isRouterContext()) {
                    System.out.println(" \u2022 " + msg);
                }
            }
        } else {
            String msg = this._t("Adding {0}", name);
            this.addMessage(msg);
            if (!this._context.isRouterContext()) {
                System.out.println(" \u2022 " + msg);
            }
        }
        return torrent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMagnet(Snark snark) {
        Map<String, Snark> map = this._snarks;
        synchronized (map) {
            this.removeSnark(snark);
        }
        snark.stopTorrent();
        this._magnets.remove(snark.getName());
        this.removeMagnetStatus(snark.getInfoHash());
        this.removeTorrentStatus(snark);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDownloader(Snark torrent) {
        Map<String, Snark> map = this._snarks;
        synchronized (map) {
            Snark snark = this.getTorrentByInfoHash(torrent.getInfoHash());
            if (snark != null) {
                String msg = this._t("Download already running: {0}", snark.getBaseName());
                this.addMessage(msg);
                if (!this._context.isRouterContext()) {
                    System.out.println(" \u2022 " + msg);
                }
                return;
            }
            String name = torrent.getName();
            this._magnets.add(name);
            this.putSnark(name, torrent);
        }
        torrent.startTorrent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addTorrent(MetaInfo metainfo, BitField bitfield, String filename, File baseFile, boolean dontAutoStart) throws IOException {
        Map<String, Snark> map = this._snarks;
        synchronized (map) {
            String msg;
            Snark snark = this.getTorrentByInfoHash(metainfo.getInfoHash());
            if (snark != null) {
                String msg2 = this._t("Torrent with this info hash is already running: {0}", snark.getBaseName());
                this.addMessage(msg2);
                if (!this._context.isRouterContext()) {
                    System.out.println(" \u2022 " + msg2);
                }
                return false;
            }
            String filtered = Storage.filterName(metainfo.getName());
            snark = this.getTorrentByBaseName(filtered);
            if (snark != null) {
                String msg3 = this._t("Torrent with the same data location is already running: {0}", snark.getBaseName());
                this.addMessage(msg3);
                if (!this._context.isRouterContext()) {
                    System.out.println(" \u2022 " + msg3);
                }
                return false;
            }
            if (bitfield != null) {
                this.saveTorrentStatus(metainfo, bitfield, null, false, baseFile, true, 0L, 0L, true);
            }
            if (filename == null) {
                File f = new File(this.getDataDir(), filtered + ".torrent");
                if (f.exists()) {
                    msg = this._t("Failed to copy torrent file to {0}", f.getAbsolutePath()) + this._t(" - torrent file already exists");
                    this.addMessage(msg);
                    if (!this._context.isRouterContext()) {
                        System.out.println(" \u2022 " + msg);
                    }
                    this._log.error("[I2PSnark] Torrent file already exists: " + f);
                }
                filename = f.getAbsolutePath();
            }
            try {
                SnarkManager.locked_writeMetaInfo(metainfo, filename, this.areFilesPublic());
                return this.addTorrent(filename, baseFile, dontAutoStart);
            }
            catch (IOException ioe) {
                msg = this._t("Failed to copy torrent file to {0}", filename);
                this.addMessage(msg);
                if (!this._context.isRouterContext()) {
                    System.out.println(" \u2022 " + msg);
                }
                this._log.error("[I2PSnark] Failed to write torrent file", ioe);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copyAndAddTorrent(File fromfile, String filename, File dataDir) throws IOException {
        Map<String, Snark> map = this._snarks;
        synchronized (map) {
            boolean success = FileUtil.copy(fromfile.getAbsolutePath(), filename, false);
            if (!success) {
                this.addMessage(this._t("Failed to copy torrent file to {0}", filename));
                this._log.error("Failed to write torrent file to " + filename);
                return false;
            }
            if (!this.areFilesPublic()) {
                SecureFileOutputStream.setPerms(new File(filename));
            }
            return this.addTorrent(filename, null, false, dataDir);
        }
    }

    private static void locked_writeMetaInfo(MetaInfo metainfo, String filename, boolean areFilesPublic) throws IOException {
        File file = new File(filename);
        if (file.exists()) {
            String msg = "Cannot overwrite an existing .torrent file: " + file.getPath();
            throw new IOException(msg);
        }
        FileOutputStream out = null;
        try {
            out = areFilesPublic ? new FileOutputStream(filename) : new SecureFileOutputStream(filename);
            ((OutputStream)out).write(metainfo.getTorrentData());
        }
        catch (IOException ioe) {
            file.delete();
            throw ioe;
        }
        finally {
            try {
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public long getSavedTorrentTime(Snark snark) {
        Properties config = this.getConfig(snark);
        String time = config.getProperty(PROP_META_STAMP);
        if (time == null) {
            return 0L;
        }
        try {
            return Long.parseLong(time);
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    @Override
    public BitField getSavedTorrentBitField(Snark snark) {
        MetaInfo metainfo = snark.getMetaInfo();
        if (metainfo == null) {
            return null;
        }
        Properties config = this.getConfig(snark);
        String bf = config.getProperty(PROP_META_BITFIELD);
        if (bf == null) {
            return null;
        }
        int len = metainfo.getPieces();
        if (bf.equals(".")) {
            BitField bitfield = new BitField(len);
            for (int i = 0; i < len; ++i) {
                bitfield.set(i);
            }
            return bitfield;
        }
        byte[] bitfield = Base64.decode(bf);
        if (bitfield == null) {
            return null;
        }
        if (bitfield.length * 8 < len) {
            return null;
        }
        return new BitField(bitfield, len);
    }

    public void loadSavedFilePriorities(Snark snark) {
        MetaInfo metainfo = snark.getMetaInfo();
        Storage storage = snark.getStorage();
        if (metainfo == null || storage == null) {
            return;
        }
        if (metainfo.getFiles() == null) {
            return;
        }
        Properties config = this.getConfig(snark);
        String pri = config.getProperty(PROP_META_PRIORITY);
        if (pri != null) {
            int filecount = metainfo.getFiles().size();
            int[] rv = new int[filecount];
            String[] arr = DataHelper.split(pri, ",");
            for (int i = 0; i < filecount && i < arr.length; ++i) {
                if (arr[i].length() <= 0) continue;
                try {
                    rv[i] = Integer.parseInt(arr[i]);
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            storage.setFilePriorities(rv);
        }
        boolean inOrder = Boolean.parseBoolean(config.getProperty(PROP_META_INORDER));
        storage.setInOrder(inOrder);
    }

    private File getSavedBaseFile(byte[] ih) {
        Properties config = this.getConfig(ih);
        String base = config.getProperty(PROP_META_BASE);
        if (base == null) {
            return null;
        }
        return new File(base);
    }

    @Override
    public boolean getSavedPreserveNamesSetting(Snark snark) {
        Properties config = this.getConfig(snark);
        return Boolean.parseBoolean(config.getProperty(PROP_META_PRESERVE_NAMES));
    }

    @Override
    public long getSavedUploaded(Snark snark) {
        Properties config = this.getConfig(snark);
        if (config != null) {
            try {
                return Long.parseLong(config.getProperty(PROP_META_UPLOADED));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0L;
    }

    public long[] getSavedAddedAndCompleted(Snark snark) {
        long[] rv = new long[2];
        Properties config = this.getConfig(snark);
        if (config != null) {
            try {
                rv[0] = Long.parseLong(config.getProperty(PROP_META_ADDED));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                rv[1] = Long.parseLong(config.getProperty(PROP_META_COMPLETED));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return rv;
    }

    public boolean getSavedCommentsEnabled(Snark snark) {
        String s;
        boolean rv = true;
        Properties config = this.getConfig(snark);
        if (config != null && (s = config.getProperty(PROP_META_COMMENTS)) != null) {
            rv = Boolean.parseBoolean(s);
        }
        return rv;
    }

    public void setSavedCommentsEnabled(Snark snark, boolean yes) {
        this.saveTorrentStatus(snark, yes);
    }

    public void saveTorrentStatus(Snark snark) {
        this.saveTorrentStatus(snark, null);
    }

    private void saveTorrentStatus(Snark snark, Boolean comments) {
        MetaInfo meta = snark.getMetaInfo();
        Storage storage = snark.getStorage();
        if (meta == null || storage == null) {
            return;
        }
        this.saveTorrentStatus(meta, storage.getBitField(), storage.getFilePriorities(), storage.getInOrder(), storage.getBase(), storage.getPreserveFileNames(), snark.getUploaded(), storage.getActivity(), snark.isStopped(), comments);
    }

    private void saveTorrentStatus(MetaInfo metainfo, BitField bitfield, int[] priorities, boolean inOrder, File base, boolean preserveNames, long uploaded, long activity, boolean stopped) {
        this.saveTorrentStatus(metainfo, bitfield, priorities, inOrder, base, preserveNames, uploaded, activity, stopped, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveTorrentStatus(MetaInfo metainfo, BitField bitfield, int[] priorities, boolean inOrder, File base, boolean preserveNames, long uploaded, long activity, boolean stopped, Boolean comments) {
        Object object = this._configLock;
        synchronized (object) {
            this.locked_saveTorrentStatus(metainfo, bitfield, priorities, inOrder, base, preserveNames, uploaded, activity, stopped, comments);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void locked_saveTorrentStatus(MetaInfo metainfo, BitField bitfield, int[] priorities, boolean inOrder, File base, boolean preserveNames, long uploaded, long activity, boolean stopped, Boolean comments) {
        String bfs;
        byte[] ih = metainfo.getInfoHash();
        Properties config = this.getConfig(ih);
        String now = Long.toString(System.currentTimeMillis());
        config.setProperty(PROP_META_STAMP, now);
        if (config.getProperty(PROP_META_ADDED) == null) {
            config.setProperty(PROP_META_ADDED, now);
        }
        BitField bitField = bitfield;
        synchronized (bitField) {
            if (bitfield.complete()) {
                bfs = ".";
                if (config.getProperty(PROP_META_COMPLETED) == null) {
                    config.setProperty(PROP_META_COMPLETED, now);
                }
            } else {
                byte[] bf = bitfield.getFieldBytes();
                bfs = Base64.encode(bf);
                config.remove(PROP_META_COMPLETED);
            }
        }
        config.setProperty(PROP_META_BITFIELD, bfs);
        config.setProperty(PROP_META_PRESERVE_NAMES, Boolean.toString(preserveNames));
        config.setProperty(PROP_META_UPLOADED, Long.toString(uploaded));
        boolean running = !stopped;
        config.setProperty(PROP_META_RUNNING, Boolean.toString(running));
        config.setProperty(PROP_META_INORDER, Boolean.toString(inOrder));
        if (base != null) {
            config.setProperty(PROP_META_BASE, base.getAbsolutePath());
        }
        if (comments != null) {
            config.setProperty(PROP_META_COMMENTS, comments.toString());
        }
        if (activity > 0L) {
            config.setProperty(PROP_META_ACTIVITY, Long.toString(activity));
        }
        if (priorities != null) {
            boolean nonzero = false;
            for (int i = 0; i < priorities.length; ++i) {
                if (priorities[i] == 0) continue;
                nonzero = true;
                break;
            }
            if (nonzero) {
                StringBuilder buf = new StringBuilder(2 * priorities.length);
                for (int i = 0; i < priorities.length; ++i) {
                    if (!(priorities[i] == 0 || inOrder && priorities[i] >= 0)) {
                        buf.append(Integer.toString(priorities[i]));
                    }
                    if (i == priorities.length - 1) continue;
                    buf.append(',');
                }
                config.setProperty(PROP_META_PRIORITY, buf.toString());
            } else {
                config.remove(PROP_META_PRIORITY);
            }
        } else {
            config.remove(PROP_META_PRIORITY);
        }
        config.remove(PROP_META_MAGNET);
        config.remove(PROP_META_MAGNET_DIR);
        config.remove(PROP_META_MAGNET_DN);
        config.remove(PROP_META_MAGNET_TR);
        this.locked_saveTorrentStatus(ih, config);
    }

    private void locked_saveTorrentStatus(byte[] ih, Properties config) {
        File subdir;
        File conf = SnarkManager.configFile(this._configDir, ih);
        if (this.shouldAutoStart() && !conf.exists()) {
            config.setProperty(PROP_META_RUNNING, DEFAULT_ENABLE_LIGHTBOX);
        }
        if (!(subdir = conf.getParentFile()).exists()) {
            subdir.mkdirs();
        }
        try {
            I2PSnarkUtil.storeProps(config, conf);
            if (this._log.shouldInfo()) {
                this._log.info("Saved config to " + conf);
            }
        }
        catch (IOException ioe) {
            this._log.error("Unable to save the config to " + conf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTorrentStatus(Snark snark) {
        byte[] ih = snark.getInfoHash();
        File conf = SnarkManager.configFile(this._configDir, ih);
        File comm = SnarkManager.commentFile(this._configDir, ih);
        Object object = this._configLock;
        synchronized (object) {
            File subdir;
            String[] files;
            comm.delete();
            boolean ok = conf.delete();
            if (ok) {
                if (this._log.shouldInfo()) {
                    this._log.info("Deleted " + conf + " for " + snark.getName());
                }
            } else if (this._log.shouldWarn()) {
                this._log.warn("Failed to delete " + conf + " for " + snark.getName());
            }
            if ((files = (subdir = conf.getParentFile()).list()) != null && files.length == 0) {
                subdir.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupTorrentStatus() {
        HashSet<SHA1Hash> torrents = new HashSet<SHA1Hash>(32);
        int found = 0;
        int totalDeleted = 0;
        Map<String, Snark> map = this._snarks;
        synchronized (map) {
            for (Snark snark : this._snarks.values()) {
                torrents.add(new SHA1Hash(snark.getInfoHash()));
            }
            Object object = this._configLock;
            synchronized (object) {
                for (int i = 0; i < B64.length(); ++i) {
                    File subdir = new File(this._configDir, SUBDIR_PREFIX + B64.charAt(i));
                    File[] configs = subdir.listFiles();
                    if (configs == null) continue;
                    int deleted = 0;
                    for (int j = 0; j < configs.length; ++j) {
                        File config = configs[j];
                        SHA1Hash ih = SnarkManager.configFileToInfoHash(config);
                        if (ih == null) continue;
                        ++found;
                        if (torrents.contains(ih)) {
                            if (!this._log.shouldInfo()) continue;
                            this._log.info("Torrent for " + config + " exists");
                            continue;
                        }
                        boolean ok = config.delete();
                        if (ok) {
                            if (this._log.shouldInfo()) {
                                this._log.info("Deleted " + config + " for " + ih);
                            }
                            ++deleted;
                            continue;
                        }
                        if (!this._log.shouldWarn()) continue;
                        this._log.warn("Failed to delete " + config + " for " + ih);
                    }
                    if (deleted == configs.length) {
                        if (this._log.shouldInfo()) {
                            this._log.info("Deleting " + subdir);
                        }
                        subdir.delete();
                    }
                    totalDeleted += deleted;
                }
            }
        }
        if (this._log.shouldInfo()) {
            this._log.info("Cleanup found " + torrents.size() + " torrents and " + found + " configs, deleted " + totalDeleted + " old configs");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveMagnetStatus(byte[] ih, String dir, String trackerURL, String dn) {
        String infohash = Base64.encode(ih);
        infohash = infohash.replace('=', '$');
        this._config.setProperty(PROP_META_MAGNET_PREFIX + infohash, ".");
        OrderedProperties config = new OrderedProperties();
        config.setProperty(PROP_META_MAGNET, DEFAULT_ENABLE_LIGHTBOX);
        if (dir != null) {
            config.setProperty(PROP_META_MAGNET_DIR, dir);
        }
        if (trackerURL != null) {
            config.setProperty(PROP_META_MAGNET_TR, trackerURL);
        }
        if (dn != null) {
            config.setProperty(PROP_META_MAGNET_DN, dn);
        }
        String now = Long.toString(System.currentTimeMillis());
        config.setProperty(PROP_META_ADDED, now);
        config.setProperty(PROP_META_STAMP, now);
        config.setProperty(PROP_META_RUNNING, DEFAULT_ENABLE_LIGHTBOX);
        Object object = this._configLock;
        synchronized (object) {
            this.saveConfig();
            this.locked_saveTorrentStatus(ih, config);
        }
    }

    public void removeMagnetStatus(byte[] ih) {
        String infohash = Base64.encode(ih);
        infohash = infohash.replace('=', '$');
        if (this._config.remove(PROP_META_MAGNET_PREFIX + infohash) != null) {
            this.saveConfig();
        }
    }

    private String validateTorrent(MetaInfo info) {
        List<List<String>> files = info.getFiles();
        if (files != null && files.size() > this._util.getMaxFilesPerTorrent()) {
            return this._t("Too many files in \"{0}\" ({1})!", info.getName(), files.size()) + " - limit is " + this._util.getMaxFilesPerTorrent() + ", zip them or set " + PROP_MAX_FILES_PER_TORRENT + '=' + files.size() + " in " + this._configFile.getAbsolutePath() + " and restart";
        }
        if (files == null && info.getName().endsWith(".torrent")) {
            return this._t("Torrent file \"{0}\" cannot end in \".torrent\"!", info.getName());
        }
        if (info.getPieces() <= 0) {
            return this._t("No pieces in \"{0}\"!", info.getName());
        }
        if (info.getPieces() > 65536) {
            return this._t("Too many pieces in \"{0}\", limit is {1}!", info.getName(), 65536);
        }
        if (info.getPieceLength(0) > 0x2000000) {
            return this._t("Pieces are too large in \"{0}\" ({1}B)!", info.getName(), DataHelper.formatSize2(info.getPieceLength(0))) + ' ' + this._t("Limit is {0}B", DataHelper.formatSize2(0x2000000L));
        }
        if (info.getTotalLength() <= 0L) {
            return this._t("Torrent \"{0}\" has no data!", info.getName());
        }
        if (info.getTotalLength() > 0x20000000000L) {
            return this._t("Torrents larger than {0}B are not supported yet \"{1}\"!", 0x20000000000L, info.getName());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Snark stopTorrent(String filename, boolean shouldRemove) {
        File sfile = new File(filename);
        try {
            filename = sfile.getCanonicalPath();
        }
        catch (IOException ioe) {
            this._log.error("Unable to remove the torrent " + filename, ioe);
            this.addMessage(this._t("Error: Could not remove the torrent {0}", filename) + ": " + ioe.getLocalizedMessage());
            return null;
        }
        int remaining = 0;
        Snark torrent = null;
        Map<String, Snark> map = this._snarks;
        synchronized (map) {
            torrent = shouldRemove ? this.removeSnark(filename) : this._snarks.get(filename);
            remaining = this._snarks.size();
        }
        if (torrent != null) {
            boolean wasStopped = torrent.isStopped();
            torrent.stopTorrent();
            if (remaining == 0) {
                // empty if block
            }
            if (shouldRemove) {
                this.removeTorrentStatus(torrent);
            }
            if (!wasStopped) {
                this.addMessageNoEscape(this._t("Torrent stopped: {0}", this.linkify(torrent).replace("Magnet ", "")));
            }
        }
        return torrent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTorrent(Snark torrent, boolean shouldRemove) {
        if (shouldRemove) {
            Map<String, Snark> map = this._snarks;
            synchronized (map) {
                this.removeSnark(torrent);
            }
        }
        boolean wasStopped = torrent.isStopped();
        torrent.stopTorrent();
        if (!wasStopped) {
            this.addMessageNoEscape(this._t("Torrent stopped: {0}", this.linkify(torrent).replace("Magnet ", "")));
        }
        if (shouldRemove) {
            this.removeTorrentStatus(torrent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTorrent(String filename) {
        Snark torrent;
        Map<String, Snark> map = this._snarks;
        synchronized (map) {
            torrent = this.stopTorrent(filename, true);
            if (torrent == null) {
                return;
            }
            File torrentFile = new File(filename);
            torrentFile.delete();
        }
        this.addMessage(this._t("Torrent removed: \"{0}\"", torrent.getBaseName()));
    }

    @Override
    public void torrentComplete(Snark snark) {
        MetaInfo meta = snark.getMetaInfo();
        Storage storage = snark.getStorage();
        if (meta == null || storage == null) {
            return;
        }
        if (snark.getDownloaded() > 0L) {
            NotificationService ns;
            this.addMessageNoEscape(this._t("Download finished: {0}", this.linkify(snark)));
            ClientAppManager cmgr = this._context.clientAppManager();
            if (cmgr != null && (ns = (NotificationService)((Object)cmgr.getRegisteredApp("desktopgui"))) != null) {
                ns.notify("I2PSnark", null, 20, this._t("I2PSnark"), this._t("Download finished: {0}", snark.getName()), "/i2psnark/" + this.linkify(snark));
            }
        }
        this.updateStatus(snark);
    }

    @Override
    public void updateStatus(Snark snark) {
        MetaInfo meta = snark.getMetaInfo();
        Storage storage = snark.getStorage();
        if (meta != null && storage != null) {
            this.saveTorrentStatus(meta, storage.getBitField(), storage.getFilePriorities(), storage.getInOrder(), storage.getBase(), storage.getPreserveFileNames(), snark.getUploaded(), storage.getActivity(), snark.isStopped());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String gotMetaInfo(Snark snark) {
        MetaInfo meta = snark.getMetaInfo();
        Storage storage = snark.getStorage();
        if (meta != null && storage != null) {
            String rejectMessage = this.validateTorrent(meta);
            if (rejectMessage != null) {
                this.addMessage(rejectMessage);
                snark.stopTorrent();
                return null;
            }
            this.saveTorrentStatus(meta, storage.getBitField(), null, false, storage.getBase(), storage.getPreserveFileNames(), 0L, 0L, snark.isStopped());
            String name = storage.getBaseName();
            try {
                name = new File(this.getDataDir(), storage.getBaseName() + ".torrent").getCanonicalPath();
                String announce = snark.getTrackerURL();
                if (announce != null) {
                    meta = meta.reannounce(announce);
                }
                Map<String, Snark> map = this._snarks;
                synchronized (map) {
                    SnarkManager.locked_writeMetaInfo(meta, name, this.areFilesPublic());
                    this.removeSnark(snark);
                    this.putSnark(name, snark);
                }
                this._magnets.remove(snark.getName());
                this.removeMagnetStatus(snark.getInfoHash());
                this.addMessageNoEscape(this._t("Starting torrent: {0}", this.linkify(snark)));
                return name;
            }
            catch (IOException ioe) {
                this.addMessage(this._t("Failed to copy torrent file to {0}", name));
                this._log.error("Failed to write torrent file", ioe);
            }
        }
        return null;
    }

    @Override
    public void fatal(Snark snark, String error) {
        this.addMessage(error);
    }

    @Override
    public void addMessage(Snark snark, String message) {
        this.addMessage(message);
    }

    @Override
    public void gotPiece(Snark snark) {
    }

    private String linkify(Snark snark) {
        MetaInfo meta = snark.getMetaInfo();
        Storage storage = snark.getStorage();
        if (meta == null || storage == null) {
            return DataHelper.escapeHTML(snark.getBaseName().replace("%20", " "));
        }
        StringBuilder buf = new StringBuilder(256);
        String base = DataHelper.escapeHTML(storage.getBaseName());
        String enc = base.replace("[", "%5B").replace("]", "%5D").replace("|", "%7C").replace(" ", "%20").replace("\u00e8", "&egrave;").replace("\u00e9", "&eacute;").replace("\u00e0", "&agrave;");
        buf.append("<a href=\"").append(this._contextPath).append('/').append(enc);
        if (meta.getFiles() != null || !storage.complete()) {
            buf.append('/');
        }
        buf.append("\">").append(base.replace("%20", " ").replace("&egrave;", "\u00e8").replace("&eacute;", "\u00e9").replace("&agrave;", "\u00e0")).append("</a>");
        return buf.toString();
    }

    private void addMagnets(boolean autostart) {
        boolean changed = false;
        Iterator<Object> iter = this._config.keySet().iterator();
        while (iter.hasNext()) {
            String k = (String)iter.next();
            if (!k.startsWith(PROP_META_MAGNET_PREFIX)) continue;
            String b64 = k.substring(PROP_META_MAGNET_PREFIX.length());
            byte[] ih = Base64.decode(b64 = b64.replace('$', '='));
            if (ih != null && ih.length == 20) {
                Properties config = this.getConfig(ih);
                String name = config.getProperty(PROP_META_MAGNET_DN);
                if (name == null) {
                    name = this._t("Magnet") + ' ' + I2PSnarkUtil.toHex(ih);
                }
                String tracker = config.getProperty(PROP_META_MAGNET_TR);
                String dir = config.getProperty(PROP_META_MAGNET_DIR);
                File dirf = dir != null ? new File(dir) : null;
                this.addMagnet(name, ih, tracker, false, autostart, dirf, this);
                continue;
            }
            iter.remove();
            changed = true;
        }
        if (changed) {
            this.saveConfig();
        }
    }

    private boolean monitorTorrents(File dir, boolean shouldStart) {
        boolean rv = true;
        File[] files = dir.listFiles(new FileSuffixFilter(".torrent"));
        ArrayList<String> foundNames = new ArrayList<String>(0);
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                try {
                    foundNames.add(files[i].getCanonicalPath());
                    continue;
                }
                catch (IOException ioe) {
                    this._log.error("Error resolving '" + files[i] + "' in '" + dir, ioe);
                }
            }
            Collections.sort(foundNames, Collator.getInstance());
        }
        Set<String> existingNames = this.listTorrentFiles();
        int count = 0;
        for (String name : foundNames) {
            if (existingNames.contains(name)) continue;
            try {
                boolean ok = this.addTorrent(name, null, !shouldStart);
                if (!ok) {
                    this.addMessage(this._t("Error: Could not add torrent: {0}", name));
                    this._log.error("Unable to add torrent: " + name);
                    this.disableTorrentFile(name);
                    rv = false;
                }
            }
            catch (Snark.RouterException e) {
                this.addMessage(this._t("Error: Could not add torrent: {0}", name) + ": " + e.getMessage());
                this._log.error("Unable to add torrent: " + name + "\n* Reason: " + e.getMessage());
                return false;
            }
            catch (RuntimeException e) {
                this.addMessage(this._t("Error: Could not add torrent: {0}", name) + ": " + e.getMessage());
                this._log.error("Unable to add torrent: " + name + "\n* Reason: " + e.getMessage());
                this.disableTorrentFile(name);
                rv = false;
            }
            if (!shouldStart || (count++ & 0xF) != 15) continue;
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
        }
        existingNames.removeAll(this._magnets);
        for (String name : existingNames) {
            if (foundNames.contains(name)) continue;
            try {
                this.stopTorrent(name, true);
            }
            catch (RuntimeException runtimeException) {}
        }
        return rv;
    }

    private String _t(String s) {
        return this._util.getString(s);
    }

    private String _t(String s, Object o) {
        return this._util.getString(s, o);
    }

    private String _t(String s, Object o, Object o2) {
        return this._util.getString(s, o, o2);
    }

    private static String _x(String s) {
        return s;
    }

    public Map<String, Tracker> getTrackerMap() {
        return this._trackerMap;
    }

    public Map<String, TorrentCreateFilter> getTorrentCreateFilterMap() {
        return this._torrentCreateFilterMap;
    }

    public int getCreateFilterCount() {
        return this._torrentCreateFilterMap.size();
    }

    public Collection<Tracker> getTrackers() {
        return this._trackerMap.values();
    }

    public Collection<TorrentCreateFilter> getTorrentCreateFilterStrings() {
        return this._torrentCreateFilterMap.values();
    }

    public List<Tracker> getSortedTrackers() {
        ArrayList<Tracker> rv = new ArrayList<Tracker>(this._trackerMap.values());
        Collections.sort(rv, new IgnoreCaseComparator());
        return rv;
    }

    public List<TorrentCreateFilter> getSortedTorrentCreateFilterStrings() {
        ArrayList<TorrentCreateFilter> fv = new ArrayList<TorrentCreateFilter>(this._torrentCreateFilterMap.values());
        Collections.sort(fv, new IgnoreCaseComparatorF());
        return fv;
    }

    public boolean hasModifiedTrackers() {
        return this._config.containsKey(PROP_TRACKERS);
    }

    private void initTrackerMap() {
        String trackers = this._config.getProperty(PROP_TRACKERS);
        if (trackers == null || trackers.trim().length() <= 0) {
            trackers = this._context.getProperty(PROP_TRACKERS);
        }
        if (trackers == null || trackers.trim().length() <= 0) {
            this.setDefaultTrackerMap(true);
        } else {
            String[] toks = DataHelper.split(trackers, ",");
            for (int i = 0; i < toks.length; i += 2) {
                String name = toks[i].trim().replace("&#44;", ",");
                String url = toks[i + 1].trim().replace("&#44;", ",");
                if (name.length() <= 0 || url.length() <= 0) continue;
                String[] urls = DataHelper.split(url, "=", 2);
                String url2 = urls.length > 1 ? urls[1] : "";
                this._trackerMap.put(name, new Tracker(name, urls[0], url2));
            }
        }
    }

    private void convertFiltersToNewConfig() {
        String torrentCreateFilters = this._config.getProperty(PROP_TORRENT_CREATE_FILTERS);
        if (torrentCreateFilters == null || torrentCreateFilters.trim().length() <= 1) {
            return;
        }
        String[] toks = DataHelper.split(torrentCreateFilters, ",");
        for (int i = 0; i < toks.length; i += 2) {
            String name = toks[i].trim().replace("&#44;", ",");
            String filterPattern = toks[i + 1].trim().replace("&#44;", ",");
            if (name.length() <= 0 || filterPattern.length() <= 0) continue;
            String[] data = DataHelper.split(filterPattern, "=", 2);
            boolean isDefault = data.length > 1;
            this._torrentCreateFilterMap.put(name, new TorrentCreateFilter(name, data[0], "contains", isDefault));
        }
        this.saveTorrentCreateFilterMap();
    }

    private void initTorrentCreateFilterMap() {
        block7: {
            String torrentCreateFilters = this._config.getProperty(PROP_TORRENT_CREATE_FILTERS);
            if (torrentCreateFilters != null && torrentCreateFilters.trim().length() > 0) {
                this.convertFiltersToNewConfig();
                this._config.remove(PROP_TORRENT_CREATE_FILTERS);
                this.saveConfig();
                return;
            }
            File f = new File(this._configDir + "/" + PROP_TORRENT_FILTERS_CONFIG);
            if (!f.exists()) {
                this.setDefaultTorrentCreateFilterMap(true);
                return;
            }
            try {
                FileInputStream file = new FileInputStream(this._configDir + "/" + PROP_TORRENT_FILTERS_CONFIG);
                ObjectInputStream in = new ObjectInputStream(file);
                Map filterMap = (Map)in.readObject();
                for (Map.Entry entry : filterMap.entrySet()) {
                    this._torrentCreateFilterMap.put((String)entry.getKey(), (TorrentCreateFilter)entry.getValue());
                }
                in.close();
                file.close();
            }
            catch (IOException ex) {
                String msg = this._t("Unable to load torrent create file filter config: ");
                this._log.error(msg + ex.getMessage());
                this.addMessage(msg + ex.getMessage());
                if (!this._context.isRouterContext()) {
                    System.out.println(" \u2022 " + msg + ex.getMessage());
                }
            }
            catch (ClassNotFoundException ex) {
                String msg = this._t("Unable to load torrent create file filter config: ");
                this._log.error(msg + ex.getMessage());
                this.addMessage(msg + ex.getMessage());
                if (this._context.isRouterContext()) break block7;
                System.out.println(" \u2022 " + msg + ex.getMessage());
            }
        }
    }

    public void setDefaultTrackerMap() {
        this.setDefaultTrackerMap(true);
    }

    public void setDefaultTorrentCreateFilterMap() {
        this.setDefaultTorrentCreateFilterMap(true);
    }

    private void setDefaultTrackerMap(boolean save) {
        this._trackerMap.clear();
        for (int i = 0; i < DEFAULT_TRACKERS.length; i += 2) {
            String name = DEFAULT_TRACKERS[i];
            if (name.equals("TheBland") && !SigType.ECDSA_SHA256_P256.isAvailable()) continue;
            String[] urls = DataHelper.split(DEFAULT_TRACKERS[i + 1], "=", 2);
            String url2 = urls.length > 1 ? urls[1] : null;
            this._trackerMap.put(name, new Tracker(name, urls[0], url2));
        }
        if (save && this._config.remove(PROP_TRACKERS) != null) {
            this.saveConfig();
        }
    }

    private void setDefaultTorrentCreateFilterMap(boolean save) {
        this._torrentCreateFilterMap.clear();
        for (int i = 0; i < DEFAULT_TORRENT_CREATE_FILTERS.length; i += 3) {
            String name = DEFAULT_TORRENT_CREATE_FILTERS[i];
            String filterPattern = DEFAULT_TORRENT_CREATE_FILTERS[i + 1];
            String filterType = DEFAULT_TORRENT_CREATE_FILTERS[i + 2];
            this._torrentCreateFilterMap.put(name, new TorrentCreateFilter(name, filterPattern, filterType, false));
        }
        if (save) {
            this.saveTorrentCreateFilterMap();
        }
    }

    public void saveTrackerMap() {
        StringBuilder buf = new StringBuilder(2048);
        boolean comma = false;
        for (Map.Entry<String, Tracker> e : this._trackerMap.entrySet()) {
            if (comma) {
                buf.append(',');
            } else {
                comma = true;
            }
            Tracker t = e.getValue();
            buf.append(e.getKey().replace(",", "&#44;")).append(',').append(t.announceURL.replace(",", "&#44;"));
            if (t.baseURL == null) continue;
            buf.append('=').append(t.baseURL);
        }
        this._config.setProperty(PROP_TRACKERS, buf.toString());
        this.saveConfig();
    }

    public void saveTorrentCreateFilterMap() {
        try {
            FileOutputStream file = new FileOutputStream(this._configDir + "/" + PROP_TORRENT_FILTERS_CONFIG);
            ObjectOutputStream out = new ObjectOutputStream(file);
            out.writeObject(this._torrentCreateFilterMap);
            out.close();
            file.close();
        }
        catch (IOException ex) {
            this._log.error("[I2PSnark] " + this._t("Unable to save torrent create file filter config: ") + ex);
            this.addMessage(this._t("Unable to save torrent create file filter config: ") + ex.getMessage());
        }
    }

    public void startTorrent(byte[] infoHash) {
        for (Snark snark : this._snarks.values()) {
            if (!DataHelper.eq(infoHash, snark.getInfoHash())) continue;
            this.startTorrent(snark);
            return;
        }
        this.addMessage(this._t("Torrent not found"));
    }

    public void startTorrent(Snark snark) {
        if (snark.isStarting() || !snark.isStopped()) {
            this.addMessageNoEscape(this._t("Torrent already running: {0}", this.linkify(snark)));
            return;
        }
        boolean connected = this._util.connected();
        if (!connected && !this._util.isConnecting()) {
            this.addMessage(this._t("Opening the I2P tunnel"));
        }
        this.addMessageNoEscape(this._t("Starting torrent: {0}", this.linkify(snark)).replace("Magnet ", ""));
        if (connected) {
            snark.startTorrent();
        } else {
            snark.setStarting();
            new I2PAppThread(new ThreadedStarter(snark), "TorrentStarter", true).start();
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void startAllTorrents() {
        if (!this._util.connected()) {
            this.addMessage(this._t("Opening the I2P tunnel and starting all torrents."));
            for (Snark snark : this._snarks.values()) {
                snark.setStarting();
            }
        }
        new I2PAppThread(new ThreadedStarter(null), "TorrentStarterAll", true).start();
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void startAll() {
        int count = 0;
        for (Snark snark : this._snarks.values()) {
            if (!snark.isStopped()) continue;
            try {
                snark.startTorrent();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            if ((count++ & 0xF) != 15) continue;
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAllTorrents(boolean finalShutdown) {
        this._stopping = true;
        if (finalShutdown && this._log.shouldWarn()) {
            this._log.warn("SnarkManager final shutdown");
        }
        int count = 0;
        Collection<Snark> snarks = this._snarks.values();
        for (Snark snark : snarks) {
            Storage storage;
            if (snark.isStopped() || (storage = snark.getStorage()) == null || storage.complete()) continue;
            if (count == 0) {
                String msg = this._t("Stopping all torrents and closing the I2P tunnel.");
                this.addMessage(msg);
                if (!this._context.isRouterContext()) {
                    System.out.println(" \u2022 " + msg);
                }
            }
            ++count;
            if (finalShutdown) {
                snark.stopTorrent(true);
            } else {
                this.stopTorrent(snark, false);
            }
            if (count % 8 != 0) continue;
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {}
        }
        for (Snark snark : snarks) {
            if (!snark.isStopped()) {
                if (count == 0) {
                    String msg = this._t("Stopping all torrents and closing the I2P tunnel.");
                    this.addMessage(msg);
                    if (!this._context.isRouterContext()) {
                        System.out.println(" \u2022 " + msg);
                    }
                }
                ++count;
                if (finalShutdown) {
                    snark.stopTorrent(true);
                } else {
                    this.stopTorrent(snark, false);
                }
                if (count % 8 != 0) continue;
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException msg) {}
                continue;
            }
            CommentSet cs = snark.getComments();
            if (cs == null) continue;
            CommentSet commentSet = cs;
            synchronized (commentSet) {
                if (cs.isModified()) {
                    this.locked_saveComments(snark, cs);
                }
            }
        }
        if (this._util.connected()) {
            if (count > 0) {
                DHT dht = this._util.getDHT();
                if (dht != null) {
                    dht.stop();
                }
                String msg = this._t("Closing I2P tunnel after notifying trackers.");
                this.addMessage(msg);
                if (!this._context.isRouterContext()) {
                    System.out.println(" \u2022 " + msg);
                }
                if (finalShutdown) {
                    long toWait = 5000L;
                    if (SystemVersion.isARM()) {
                        toWait *= 2L;
                    }
                    try {
                        Thread.sleep(toWait);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this._util.disconnect();
                    this._stopping = false;
                } else {
                    this._context.simpleTimer2().addEvent(new Disconnector(), 60000L);
                }
            } else {
                this._util.disconnect();
                this._stopping = false;
                this.addMessage(this._t("I2P tunnel closed."));
            }
        }
    }

    public void recheckTorrent(Snark snark) {
        if (snark.isStarting() || !snark.isStopped()) {
            this.addMessage("Cannot check " + snark.getBaseName() + ", torrent already started");
            return;
        }
        Storage storage = snark.getStorage();
        if (storage == null) {
            this.addMessage("Cannot check " + snark.getBaseName() + ", no storage");
            return;
        }
        new I2PAppThread(new ThreadedRechecker(snark), "TorrentRechecker", true).start();
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static {
        KNOWN_OPENTRACKERS = new HashSet<String>(Arrays.asList("opentracker.dg2.i2p", "w7tpbzncbcocrqtwwm3nezhnnsw4ozadvi2hmvzdhrqzfxfum7wa.b32.i2p", "opentracker.r4sas.i2p", "punzipidirfqspstvzpj6gb4tkuykqp6quurj6e23bgxcxhdoe7q.b32.i2p", "opentracker.skank.i2p", "by7luzwhx733fhc5ug2o75dcaunblq2ztlshzd7qvptaoa73nqua.b32.i2p"));
        DEFAULT_TORRENT_CREATE_FILTERS = new String[]{".backup files", ".backup", "ends_with", ".bak files", ".bak", "ends_with", ".nfo files", ".nfo", "ends_with", "DO_NOT_MIRROR.exe", "DO_NOT_MIRROR.exe", "contains", "Hidden unix files", ".", "starts_with", "macOS folder metadata", "DS_Store", "contains", "Synology NAS metadata", "@eaDir", "contains", "Temporary backup files", "~", "ends_with"};
        HashSet<String> ann = new HashSet<String>(8);
        for (int i = 1; i < DEFAULT_TRACKERS.length; i += 2) {
            if (DEFAULT_TRACKERS[i - 1].equals("TheBland") && !SigType.ECDSA_SHA256_P256.isAvailable()) continue;
            String[] urls = DataHelper.split(DEFAULT_TRACKERS[i], "=", 2);
            ann.add(urls[0]);
        }
        DEFAULT_TRACKER_ANNOUNCES = Collections.unmodifiableSet(ann);
    }

    private static class IgnoreCaseComparatorF
    implements Comparator<TorrentCreateFilter>,
    Serializable {
        private final Collator coll = Collator.getInstance();

        private IgnoreCaseComparatorF() {
        }

        @Override
        public int compare(TorrentCreateFilter l, TorrentCreateFilter r) {
            return this.coll.compare(l.name, r.name);
        }
    }

    private static class IgnoreCaseComparator
    implements Comparator<Tracker>,
    Serializable {
        private final Collator coll = Collator.getInstance();

        private IgnoreCaseComparator() {
        }

        @Override
        public int compare(Tracker l, Tracker r) {
            return this.coll.compare(l.name, r.name);
        }
    }

    private class ThreadedRechecker
    implements Runnable {
        private final Snark snark;

        public ThreadedRechecker(Snark s) {
            this.snark = s;
        }

        @Override
        public void run() {
            try {
                boolean changed;
                if (SnarkManager.this._log.shouldWarn()) {
                    SnarkManager.this._log.warn("Starting recheck of " + this.snark.getBaseName());
                }
                if (changed = this.snark.getStorage().recheck()) {
                    SnarkManager.this.updateStatus(this.snark);
                }
                if (SnarkManager.this._log.shouldWarn()) {
                    SnarkManager.this._log.warn("Finished recheck of " + this.snark.getBaseName() + " -> " + (changed ? "File changes detected" : "Unchanged"));
                }
                String link = SnarkManager.this.linkify(this.snark);
                if (changed) {
                    int pieces = this.snark.getPieces();
                    double completion = (double)((long)pieces - this.snark.getNeeded()) / (double)pieces;
                    String complete = new DecimalFormat("0.00%").format(completion);
                    SnarkManager.this.addMessageNoEscape(SnarkManager.this._t("Finished recheck of torrent {0}, now {1} complete", link, complete));
                } else {
                    SnarkManager.this.addMessageNoEscape(SnarkManager.this._t("Finished recheck of torrent {0}, unchanged", link));
                }
            }
            catch (IOException e) {
                SnarkManager.this._log.error("Error rechecking " + this.snark.getBaseName(), e);
                SnarkManager.this.addMessage(SnarkManager.this._t("Error checking the torrent {0}", this.snark.getBaseName()) + " (" + e.getMessage() + ")");
            }
        }
    }

    private class Disconnector
    implements SimpleTimer.TimedEvent {
        private Disconnector() {
        }

        @Override
        public void timeReached() {
            if (SnarkManager.this._util.connected()) {
                SnarkManager.this._util.disconnect();
                SnarkManager.this._stopping = false;
                SnarkManager.this.addMessage(SnarkManager.this._t("I2P tunnel closed."));
            }
        }
    }

    private class ThreadedStarter
    implements Runnable {
        private final Snark snark;

        public ThreadedStarter(Snark s) {
            this.snark = s;
        }

        @Override
        public void run() {
            if (this.snark != null) {
                if (this.snark.isStopped()) {
                    try {
                        this.snark.startTorrent();
                    }
                    catch (RuntimeException runtimeException) {}
                }
            } else {
                SnarkManager.this.startAll();
            }
        }
    }

    private class DirMonitor
    implements Runnable {
        private DirMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long delay = 60000L * (long)SnarkManager.this.getStartupDelayMinutes();
            boolean autostart = SnarkManager.this.shouldAutoStart();
            if (delay == 0L) {
                delay = 30000L;
            }
            if (delay > 30000L && autostart) {
                int id = SnarkManager.this._messages.addMessageNoEscape(SnarkManager.this.getTime() + "&nbsp; " + SnarkManager.this._t("Adding torrents in {0}&hellip;", DataHelper.formatDuration2(delay)));
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                SnarkManager.this._messages.clearThrough(id);
            } else if (SnarkManager.this._context.isRouterContext()) {
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException id) {
                    // empty catch block
                }
            }
            boolean routerOK = false;
            boolean doMagnets = true;
            while (SnarkManager.this._running) {
                boolean ok;
                File dir = SnarkManager.this.getDataDir();
                if (SnarkManager.this._log.shouldDebug()) {
                    SnarkManager.this._log.debug("DirectoryMonitor scanning I2PSnark data dir: " + dir.getAbsolutePath());
                }
                if (routerOK && (SnarkManager.this._context.isRouterContext() || SnarkManager.this._util.connected() || SnarkManager.this._util.isConnecting())) {
                    autostart = SnarkManager.this.shouldAutoStart();
                } else {
                    boolean oldOK = routerOK;
                    if (doMagnets && !SnarkManager.this._context.isRouterContext()) {
                        System.out.println(" \u2022 " + SnarkManager.this._t("Connecting to I2P") + ' ' + SnarkManager.this._util.getI2CPHost() + ':' + SnarkManager.this._util.getI2CPPort() + "...");
                    }
                    if (routerOK = SnarkManager.this.getBWLimit()) {
                        autostart = SnarkManager.this.shouldAutoStart();
                        if (autostart && !oldOK && !doMagnets && !SnarkManager.this._snarks.isEmpty()) {
                            for (Snark snark : SnarkManager.this._snarks.values()) {
                                Properties config = SnarkManager.this.getConfig(snark);
                                String prop = config.getProperty(SnarkManager.PROP_META_RUNNING);
                                if (prop != null && !Boolean.parseBoolean(prop)) continue;
                                if (!SnarkManager.this._util.connected()) {
                                    boolean ok2;
                                    String msg = SnarkManager.this._t("Connecting to I2P") + "...";
                                    SnarkManager.this.addMessage(msg);
                                    if (!SnarkManager.this._context.isRouterContext()) {
                                        System.out.println(" \u2022 " + msg + ' ' + SnarkManager.this._util.getI2CPHost() + ':' + SnarkManager.this._util.getI2CPPort() + "...");
                                    }
                                    if (!(ok2 = SnarkManager.this._util.connect())) {
                                        if (SnarkManager.this._context.isRouterContext()) {
                                            SnarkManager.this.addMessage(SnarkManager.this._t("Unable to connect to I2P"));
                                        } else {
                                            msg = SnarkManager.this._t("Error connecting to I2P - check your I2CP settings!") + ' ' + SnarkManager.this._util.getI2CPHost() + ':' + SnarkManager.this._util.getI2CPPort();
                                            SnarkManager.this.addMessage(msg);
                                            System.out.println(" \u2022 " + msg);
                                        }
                                        routerOK = false;
                                        autostart = false;
                                        break;
                                    }
                                    if (!SnarkManager.this._context.isRouterContext()) {
                                        msg = "Connected to I2P at  " + SnarkManager.this._util.getI2CPHost() + ':' + SnarkManager.this._util.getI2CPPort();
                                        System.out.println(" \u2022 " + msg);
                                    }
                                }
                                SnarkManager.this.addMessageNoEscape(SnarkManager.this._t("Starting up torrent {0}", SnarkManager.this.linkify(snark)));
                                try {
                                    snark.startTorrent();
                                }
                                catch (Snark.RouterException re) {
                                    break;
                                }
                                catch (RuntimeException runtimeException) {
                                }
                            }
                            if (routerOK) {
                                SnarkManager.this.addMessage(SnarkManager.this._t("Down bandwidth limit is {0} KBps", SnarkManager.this._bwManager.getUpBWLimit() / 1024L) + "; " + SnarkManager.this._t("Up bandwidth limit is {0} KBps", SnarkManager.this._util.getMaxUpBW()));
                            }
                        }
                    } else {
                        autostart = false;
                    }
                }
                try {
                    Map map = SnarkManager.this._snarks;
                    synchronized (map) {
                        ok = SnarkManager.this.monitorTorrents(dir, autostart);
                    }
                }
                catch (RuntimeException e) {
                    SnarkManager.this._log.error("Error in the DirectoryMonitor", e);
                    ok = false;
                }
                if (doMagnets) {
                    try {
                        SnarkManager.this.addMagnets(autostart);
                        doMagnets = false;
                    }
                    catch (RuntimeException e) {
                        SnarkManager.this._log.error("Error in the DirectoryMonitor", e);
                    }
                    if (!SnarkManager.this._context.isRouterContext()) {
                        String msg = SnarkManager.this._t("I2P+ I2PSnark standalone version {0} started", "2.6.0");
                        SnarkManager.this.addMessage(msg);
                        if (!SnarkManager.this._context.isRouterContext()) {
                            System.out.println(" \u2022 " + msg);
                        }
                    }
                    if (routerOK && !SnarkManager.this._snarks.isEmpty()) {
                        SnarkManager.this.addMessage(SnarkManager.this._t("Upload bandwidth limit is {0} KBps to a maximum of {1} concurrent peers.", SnarkManager.this._util.getMaxUpBW(), SnarkManager.this._util.getMaxUploaders()));
                    }
                    if (ok) {
                        SnarkManager.this.cleanupTorrentStatus();
                        long freeSpace = dir.getUsableSpace();
                        int freeSpaceMB = (int)(freeSpace / 0x100000L);
                        String msg = SnarkManager.this._t("Storage: {0}MB currently available for downloads on configured data partition", freeSpaceMB);
                        if (freeSpaceMB < 100) {
                            msg = SnarkManager.this._t("Warning - Only {0}MB available for downloads on configured data partition", freeSpaceMB);
                            if (SnarkManager.this._log.shouldWarn()) {
                                SnarkManager.this._log.warn("[I2PSnark] Partition containing data directory only has " + freeSpaceMB + "MB free");
                            }
                        }
                        SnarkManager.this.addMessage(msg);
                        if (!SnarkManager.this._context.isRouterContext()) {
                            System.out.println(" \u2022 " + msg);
                        }
                    }
                    if (!routerOK) {
                        if (SnarkManager.this._context.isRouterContext()) {
                            SnarkManager.this.addMessage(SnarkManager.this._t("Unable to connect to I2P"));
                        } else {
                            String msg = SnarkManager.this._t("Error connecting to I2P - check your I2CP settings!") + ' ' + SnarkManager.this._util.getI2CPHost() + ':' + SnarkManager.this._util.getI2CPPort();
                            SnarkManager.this.addMessage(msg);
                            System.out.println(" \u2022 " + msg);
                        }
                    }
                }
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private class Register
    implements SimpleTimer.TimedEvent {
        private Register() {
        }

        @Override
        public void timeReached() {
            if (!SnarkManager.this._running) {
                return;
            }
            ClientAppManager cmgr = SnarkManager.this._context.clientAppManager();
            if (cmgr != null) {
                SnarkManager.this._umgr = (UpdateManager)((Object)cmgr.getRegisteredApp("update"));
            }
            if (SnarkManager.this._umgr != null) {
                SnarkManager.this._uhandler = new UpdateHandler(SnarkManager.this._context, SnarkManager.this._umgr, SnarkManager.this);
                SnarkManager.this._umgr.register(SnarkManager.this._uhandler, UpdateType.ROUTER_SIGNED, UpdateMethod.TORRENT, 10);
                SnarkManager.this._umgr.register(SnarkManager.this._uhandler, UpdateType.ROUTER_SIGNED_SU3, UpdateMethod.TORRENT, 10);
                SnarkManager.this._log.info("Registered I2PSnark with Update Manager for Router updates");
            } else {
                SnarkManager.this._log.warn("No Update Manager found: cannot register I2PSnark for Router updates");
            }
        }
    }

    private static class TempDeleter
    implements Runnable {
        private final File file;

        public TempDeleter(File f) {
            this.file = f;
        }

        @Override
        public void run() {
            FileUtil.rmdir(this.file, false);
        }
    }
}

