/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import net.i2p.crypto.SigType;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.util.ConvertToHash;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;
import net.i2p.util.RandomSource;
import net.i2p.util.SimpleTimer2;
import org.klomp.snark.I2PSnarkUtil;
import org.klomp.snark.MetaInfo;
import org.klomp.snark.Peer;
import org.klomp.snark.PeerCoordinator;
import org.klomp.snark.PeerID;
import org.klomp.snark.Snark;
import org.klomp.snark.TrackerInfo;
import org.klomp.snark.WebPeer;
import org.klomp.snark.bencode.InvalidBEncodingException;
import org.klomp.snark.dht.DHT;

public class TrackerClient
implements Runnable {
    private final Log _log;
    private static final String NO_EVENT = "";
    private static final String STARTED_EVENT = "started";
    private static final String COMPLETED_EVENT = "completed";
    private static final String STOPPED_EVENT = "stopped";
    private static final String NOT_REGISTERED = "torrent not registered";
    private static final String NOT_REGISTERED_2 = "torrent not found";
    private static final String NOT_REGISTERED_3 = "torrent unauthorised";
    private static final String ERROR_GOT_HTML = "received html (invalid response)";
    private static final int SLEEP = 5;
    private static final int DELAY_MIN = 2000;
    private static final int DELAY_RAND = 6000;
    private static final int MAX_REGISTER_FAILS = 15;
    private static final int INITIAL_SLEEP = 90000;
    private static final int MAX_CONSEC_FAILS = 10;
    private static final int LONG_SLEEP = 600000;
    private static final long MIN_TRACKER_ANNOUNCE_INTERVAL = 600000L;
    private static final long MIN_DHT_ANNOUNCE_INTERVAL = 900000L;
    private static final int DHT_ANNOUNCE_PEERS = 8;
    public static final int PORT = 6881;
    private static final int MAX_TRACKERS = 12;
    private static final Hash DSA_ONLY_TRACKER = ConvertToHash.getHash("cfmqlafjfmgkzbt4r3jsfyhgsr5abgxryl6fnz3d3y5a365di5aa.b32.i2p");
    private final I2PSnarkUtil _util;
    private MetaInfo meta;
    private final String infoHash;
    private final String peerID;
    private final String additionalTrackerURL;
    private final PeerCoordinator coordinator;
    private final Snark snark;
    private final int port;
    private final String _threadName;
    private volatile boolean stop = true;
    private volatile boolean started;
    private volatile boolean _initialized;
    private volatile int _runCount;
    private volatile Thread _thread;
    private volatile SimpleTimer2.TimedEvent _event;
    private volatile boolean runStarted;
    private volatile int consecutiveFails;
    private boolean completed;
    private volatile boolean _fastUnannounce;
    private long lastDHTAnnounce;
    private final List<TCTracker> trackers;
    private final List<TCTracker> backupTrackers;
    private long _startedOn;

    public TrackerClient(I2PSnarkUtil util, MetaInfo meta, String additionalTrackerURL, PeerCoordinator coordinator, Snark snark) {
        byte[] hash = snark.getInfoHash();
        this._threadName = "TrackerClient " + I2PSnarkUtil.toHex(hash);
        this._util = util;
        this._log = util.getContext().logManager().getLog(TrackerClient.class);
        this.meta = meta;
        this.additionalTrackerURL = additionalTrackerURL;
        this.coordinator = coordinator;
        this.snark = snark;
        this.port = 6881;
        this.infoHash = TrackerClient.urlencode(hash);
        this.peerID = TrackerClient.urlencode(snark.getID());
        this.trackers = new ArrayList<TCTracker>(2);
        this.backupTrackers = new ArrayList<TCTracker>(2);
    }

    public synchronized void start() {
        if (!this.stop) {
            if (this._log.shouldWarn()) {
                this._log.warn("Already started: " + this._threadName);
            }
            return;
        }
        this.stop = false;
        this.consecutiveFails = 0;
        this.runStarted = false;
        this._fastUnannounce = false;
        this.snark.setTrackerProblems(null);
        this._thread = new I2PAppThread(this, this._threadName + " #" + ++this._runCount, true);
        this._thread.start();
        this.started = true;
    }

    public boolean halted() {
        return this.stop;
    }

    public boolean started() {
        return this.started;
    }

    public synchronized void halt(boolean fast) {
        Thread t;
        SimpleTimer2.TimedEvent e;
        boolean wasStopped = this.stop;
        if (wasStopped) {
            if (this._log.shouldWarn()) {
                this._log.warn("Already stopped: " + this._threadName);
            }
        } else {
            if (this._log.shouldWarn()) {
                this._log.warn("Stopping: " + this._threadName);
            }
            this.stop = true;
        }
        if ((e = this._event) != null) {
            if (this._log.shouldDebug()) {
                this._log.debug("Cancelling next announce " + this._threadName);
            }
            e.cancel();
            this._event = null;
        }
        if ((t = this._thread) != null) {
            if (this._log.shouldDebug()) {
                this._log.debug("Interrupting " + t.getName());
            }
            t.interrupt();
        }
        this._fastUnannounce = true;
        if (!wasStopped) {
            this.unannounce();
        }
    }

    private void queueLoop(long delay) {
        this._event = new Runner(delay);
    }

    private boolean verifyConnected() {
        while (!this.stop && !this._util.connected()) {
            boolean ok = this._util.connect();
            if (ok) continue;
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return !this.stop && this._util.connected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long begin = this._util.getContext().clock().now();
        if (this._log.shouldDebug()) {
            this._log.debug("Start " + Thread.currentThread().getName());
        }
        try {
            if (!this._initialized) {
                this.setup();
            }
            if (this.trackers.isEmpty() && this._util.getDHT() == null) {
                this.stop = true;
                this.snark.addMessage(this._util.getString("No valid trackers for {0} - enable opentrackers or DHT?", this.snark.getBaseName()));
                this._log.error("No valid trackers for " + this.snark.getBaseName());
                this.snark.stopTorrent();
                return;
            }
            if (!this._initialized) {
                this._initialized = true;
                long delay = this._util.getContext().random().nextInt(30000);
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.loop();
        }
        finally {
            this._thread = null;
            if (this._log.shouldDebug()) {
                this._log.debug("Finish " + Thread.currentThread().getName() + " after " + DataHelper.formatDuration(this._util.getContext().clock().now() - begin));
            }
        }
    }

    public synchronized void reinitialize() {
        if (!this._initialized || !this.stop) {
            return;
        }
        this.trackers.clear();
        this.backupTrackers.clear();
        this.meta = this.snark.getMetaInfo();
        this.setup();
    }

    private void setup() {
        String url;
        List<String> tlist;
        List<List<String>> list;
        String primary = null;
        if (this.meta != null) {
            primary = this.meta.getAnnounce();
        } else if (this.additionalTrackerURL != null) {
            primary = this.additionalTrackerURL;
        }
        HashSet<Hash> trackerHashes = new HashSet<Hash>(8);
        if (primary != null) {
            if (this.isNewValidTracker(trackerHashes, primary)) {
                this.trackers.add(new TCTracker(primary, true));
                if (this._log.shouldDebug()) {
                    this._log.debug("Announce: [" + primary + "] [InfoHash " + this.infoHash + "]");
                }
            } else if (this._log.shouldWarn()) {
                this._log.warn("Skipping invalid or non-i2p announce: " + primary + "\n* + Torrent: " + this.snark.getBaseName());
            }
        } else if (this._log.shouldWarn()) {
            this._log.warn("No primary announce for " + this.snark.getBaseName());
        }
        if (this.meta != null && !this.meta.isPrivate() && (list = this.meta.getAnnounceList()) != null) {
            for (List<String> llist : list) {
                for (String url2 : llist) {
                    if (!this.isNewValidTracker(trackerHashes, url2)) continue;
                    this.trackers.add(new TCTracker(url2, this.trackers.isEmpty()));
                    if (!this._log.shouldDebug()) continue;
                    this._log.debug("Additional announce (list): [" + url2 + "] for [InfoHash " + this.infoHash + "]");
                }
            }
            if (this.trackers.size() > 2) {
                TCTracker pri = this.trackers.remove(0);
                this.trackers.add(0, pri);
            }
        }
        if (this.meta == null || !this.meta.isPrivate()) {
            tlist = this._util.getOpenTrackers();
            for (int i = 0; i < tlist.size(); ++i) {
                url = tlist.get(i);
                if (!this.isNewValidTracker(trackerHashes, url)) continue;
                this.trackers.add(new TCTracker(url, this.trackers.isEmpty()));
                if (!this._log.shouldDebug()) continue;
                this._log.debug("Additional announce: [" + url + "] for [InfoHash " + this.infoHash + "]");
            }
        }
        if (this.trackers.isEmpty() && (this.meta == null || !this.meta.isPrivate())) {
            tlist = this._util.getBackupTrackers();
            for (int i = 0; i < tlist.size(); ++i) {
                url = tlist.get(i);
                if (!this.isNewValidTracker(trackerHashes, url)) continue;
                this.backupTrackers.add(new TCTracker(url, false));
                if (!this._log.shouldDebug()) continue;
                this._log.debug("Backup announce: [" + url + "] for [InfoHash " + this.infoHash + "]");
            }
            if (this.backupTrackers.isEmpty()) {
                this.backupTrackers.add(new TCTracker("http://opentracker.dg2.i2p/a", false));
            } else if (this.trackers.size() > 1) {
                Collections.shuffle(this.backupTrackers, this._util.getContext().random());
            }
        }
        this.completed = this.coordinator.getLeft() == 0L;
        this._startedOn = this._util.getContext().clock().now();
    }

    private boolean isNewValidTracker(Set<Hash> existing, String ann) {
        Destination dest;
        Hash h = TrackerClient.getHostHash(ann);
        if (h == null) {
            if (this._log.shouldWarn()) {
                this._log.warn("Bad announce URL: [" + ann + "] \n* Torrent:" + this.snark.getBaseName());
            }
            return false;
        }
        if (h.equals(DSA_ONLY_TRACKER) && (dest = this._util.getMyDestination()) != null && dest.getSigType() != SigType.DSA_SHA1) {
            if (this._log.shouldWarn()) {
                this._log.warn("Skipping incompatible tracker: " + ann + "\n* Torrent: " + this.snark.getBaseName());
            }
            return false;
        }
        if (existing.size() >= 12) {
            if (this._log.shouldInfo()) {
                this._log.info("Not using announce URL, we have enough: [" + ann + "] \n* Torrent: " + this.snark.getBaseName());
            }
            return false;
        }
        boolean rv = existing.add(h);
        if (!rv && this._log.shouldInfo()) {
            this._log.info("Duplicate announce URL: [" + ann + "] \n* Torrent: " + this.snark.getBaseName());
        }
        return rv;
    }

    private void loop() {
        block4: while (true) {
            try {
                while (!this.stop) {
                    int p;
                    if (!this.verifyConnected()) {
                        this.stop = true;
                        return;
                    }
                    int webPeers = this.getWebPeers();
                    DHT dht = this._util.getDHT();
                    if (!(dht == null || this.meta != null && this.meta.isPrivate())) {
                        dht.announce(this.snark.getInfoHash(), this.coordinator.completed());
                    }
                    int oldSeenPeers = this.snark.getTrackerSeenPeers();
                    int maxSeenPeers = 0;
                    if (!this.trackers.isEmpty() && (maxSeenPeers = this.getPeersFromTrackers(this.trackers)) > oldSeenPeers) {
                        this.snark.setTrackerSeenPeers(maxSeenPeers);
                    }
                    if ((p = this.getPeersFromPEX()) > maxSeenPeers) {
                        maxSeenPeers = p;
                    }
                    if ((p = this.getPeersFromDHT()) > maxSeenPeers && (maxSeenPeers = p) > oldSeenPeers) {
                        this.snark.setTrackerSeenPeers(maxSeenPeers);
                    }
                    if (this.trackers.isEmpty() && !this.backupTrackers.isEmpty() && dht != null && dht.size() < 16 && (p = this.getPeersFromTrackers(this.backupTrackers)) > maxSeenPeers) {
                        maxSeenPeers = p;
                    }
                    this.snark.setTrackerSeenPeers(maxSeenPeers + webPeers);
                    if (this.stop) {
                        return;
                    }
                    try {
                        RandomSource r = this._util.getContext().random();
                        int random = ((Random)r).nextInt(120000);
                        int delay = this.completed && this.runStarted ? 900000 + random : (this.snark.getTrackerProblems() != null && ++this.consecutiveFails < 10 ? 90000 : (!this.runStarted && this._runCount < 10 ? 90000 : 300000 + random));
                        if (delay > 20000) {
                            if (this._log.shouldDebug()) {
                                this._log.debug("Requeueing in " + DataHelper.formatDuration(delay) + ": " + Thread.currentThread().getName());
                            }
                            this.queueLoop(delay);
                            return;
                        }
                        if (delay <= 0) continue block4;
                        Thread.sleep(delay);
                        continue block4;
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                break;
            }
            catch (Throwable t) {
                this._log.error("TrackerClient: " + t, t);
                if (!(t instanceof OutOfMemoryError)) break;
                throw (OutOfMemoryError)t;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private int getPeersFromTrackers(List<TCTracker> trckrs) {
        left = this.coordinator.getLeft();
        if (!this.completed && left == 0L) {
            this.completed = true;
            newlyCompleted = true;
        } else {
            newlyCompleted = false;
        }
        maxSeenPeers = 0;
        for (TCTracker tr : trckrs) {
            if (!(this.stop || tr.stop || !this.completed && !this.coordinator.needOutboundPeers() && tr.started || !newlyCompleted && System.currentTimeMillis() <= tr.lastRequestTime + tr.interval)) {
                try {
                    uploaded = this.coordinator.getUploaded();
                    downloaded = this.coordinator.getDownloaded();
                    len = this.snark.getTotalLength();
                    if (len > 0L && downloaded > len) {
                        downloaded = len;
                    }
                    left = this.coordinator.getLeft();
                    event = tr.started == false ? "started" : (newlyCompleted != false ? "completed" : "");
                    info = this.doRequest(tr, this.infoHash, this.peerID, uploaded, downloaded, left, event);
                    this.snark.setTrackerProblems(null);
                    tr.trackerProblems = null;
                    tr.registerFails = 0;
                    tr.consecutiveFails = 0;
                    if (tr.isPrimary) {
                        this.consecutiveFails = 0;
                    }
                    this.runStarted = true;
                    tr.started = true;
                    tr.seenPeers = info.getPeerCount();
                    if (this.snark.getTrackerSeenPeers() < tr.seenPeers) {
                        this.snark.setTrackerSeenPeers(tr.seenPeers);
                    }
                    if (this.completed && tr.isPrimary && this.snark.isAutoStoppable() && !this.snark.isChecking() && info.getSeedCount() > 100 && this.coordinator.getPeerCount() <= 0 && this._util.getContext().clock().now() > this._startedOn + 1800000L && this.snark.getTotalLength() > 0L && uploaded >= this.snark.getTotalLength() / 2L) {
                        if (this._log.shouldWarn()) {
                            this._log.warn("Auto stopping " + this.snark.getBaseName());
                        }
                        this.snark.setAutoStoppable(false);
                        this.snark.stopTorrent();
                        return tr.seenPeers;
                    }
                    peers = info.getPeers();
                    dht = this._util.getDHT();
                    if (dht != null) {
                        for (Peer peer : peers) {
                            dht.announce(this.snark.getInfoHash(), peer.getPeerID().getDestHash(), false);
                        }
                    }
                    if (!this.coordinator.needOutboundPeers()) ** GOTO lbl74
                    ordered = new ArrayList<Peer>(peers);
                    r = this._util.getContext().random();
                    Collections.shuffle(ordered, r);
                    it = ordered.iterator();
                    while (!this.stop && it.hasNext() && this.coordinator.needOutboundPeers()) {
                        cur = (Peer)it.next();
                        if (!this.coordinator.addPeer(cur) || !it.hasNext()) continue;
                        delay = r.nextInt(6000) + 2000;
                        try {
                            Thread.sleep(delay);
                        }
                        catch (InterruptedException var23_21) {}
                    }
                }
                catch (IOException ioe) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Error communicating with tracker [" + tr.announce.replace("ahsplxkbhemefwvvml7qovzl5a2b5xo5i7lyai7ntdunvcyfdtna.b32.i2p", "tracker2.postman.i2p").replace("lnQ6yoBTxQuQU8EQ1FlF395ITIQF-HGJxUeFvzETLFnoczNjQvKDbtSB7aHhn853zjVXrJBgwlB9sO57KakBDaJ50lUZgVPhjlI19TgJ-CxyHhHSCeKx5JzURdEW-ucdONMynr-b2zwhsx8VQCJwCEkARvt21YkOyQDaB9IdV8aTAmP~PUJQxRwceaTMn96FcVenwdXqleE16fI8CVFOV18jbJKrhTOYpTtcZKV4l1wNYBDwKgwPx5c0kcrRzFyw5~bjuAKO~GJ5dR7BQsL7AwBoQUS4k1lwoYrG1kOIBeDD3XF8BWb6K3GOOoyjc1umYKpur3G~FxBuqtHAsDRICkEbKUqJ9mPYQlTSujhNxiRIW-oLwMtvayCFci99oX8MvazPS7~97x0Gsm-onEK1Td9nBdmq30OqDxpRtXBimbzkLbR1IKObbg9HvrKs3L-kSyGwTUmHG9rSQSoZEvFMA-S0EXO~o4g21q1oikmxPMhkeVwQ22VHB0-LZJfmLr4SAAAA.i2p", "tracker2.postman.i2p").replace("w7tpbzncbcocrqtwwm3nezhnnsw4ozadvi2hmvzdhrqzfxfum7wa.b32.i2p", "opentracker.dg2.i2p").replace("afuuortfaqejkesne272krqvmafn65mhls6nvcwv3t7l2ic2p4kq.b32.i2p", "lyoko.i2p").replace("s5ikrdyjwbcgxmqetxb3nyheizftms7euacuub2hic7defkh3xhq.b32.i2p", "tracker.thebland.i2p").replace("nfrjvknwcw47itotkzmk6mdlxmxfxsxhbhlr5ozhlsuavcogv4hq.b32.i2p", "torrfreedom.i2p").replace("by7luzwhx733fhc5ug2o75dcaunblq2ztlshzd7qvptaoa73nqua.b32.i2p", "opentracker.skank.i2p").replace("punzipidirfqspstvzpj6gb4tkuykqp6quurj6e23bgxcxhdoe7q.b32.i2p", "opentracker.r4sas.i2p").replace("http://", "") + "]");
                    }
                    tr.trackerProblems = ioe.getMessage();
                    if (tr.isPrimary && this.coordinator.getPeers() <= 0 && (!this.completed || this._util.getDHT() == null || this._util.getDHT().size() <= 0)) {
                        this.snark.setTrackerProblems(tr.trackerProblems);
                    }
                    if ((tplc = tr.trackerProblems.toLowerCase(Locale.US)).startsWith("torrent not registered") || tplc.startsWith("torrent not found") || tplc.startsWith("torrent unauthorised") || tplc.startsWith("received html (invalid response)")) {
                        if ((tr.registerFails++ > 15 || !this.completed || tplc.startsWith("received html (invalid response)") || !tr.isPrimary && tr.registerFails > 7) && this._log.shouldWarn()) {
                            this._log.warn("No longer announcing to " + tr.announce + " : " + tr.trackerProblems + " after " + tr.registerFails + " failures");
                        }
                        tr.stop = true;
                    }
                    if (++tr.consecutiveFails != 10) ** GOTO lbl74
                    tr.seenPeers = 0;
                    if (tr.interval >= 600000L) ** GOTO lbl74
                    tr.interval = 600000L;
                }
            } else if (this._log.shouldInfo()) {
                this._log.info("Not announcing to " + tr.announce + "\n* Last announce: " + new Date(tr.lastRequestTime) + " (interval: " + DataHelper.formatDuration(tr.interval) + ")");
            }
lbl74:
            // 8 sources

            if (tr.stop || maxSeenPeers >= tr.seenPeers) continue;
            maxSeenPeers = tr.seenPeers;
        }
        return maxSeenPeers;
    }

    private int getPeersFromPEX() {
        int rv = 0;
        if (!(!this.coordinator.needOutboundPeers() || this.meta != null && this.meta.isPrivate() || this.stop)) {
            Set<PeerID> pids = this.coordinator.getPEXPeers();
            if (!pids.isEmpty()) {
                if (this._log.shouldInfo()) {
                    this._log.info("Received " + pids.size() + " from PEX");
                }
                ArrayList<Peer> peers = new ArrayList<Peer>(pids.size());
                for (PeerID pID : pids) {
                    peers.add(new Peer(pID, this.snark.getID(), this.snark.getInfoHash(), this.snark.getMetaInfo()));
                }
                RandomSource r = this._util.getContext().random();
                Collections.shuffle(peers, r);
                Iterator it = peers.iterator();
                while (!this.stop && it.hasNext() && this.coordinator.needOutboundPeers()) {
                    Peer cur = (Peer)it.next();
                    if (!this.coordinator.addPeer(cur) || !it.hasNext()) continue;
                    int delay = ((Random)r).nextInt(6000) + 2000;
                    try {
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                rv = pids.size();
                pids.clear();
            }
        } else if (this._log.shouldInfo()) {
            this._log.info("Not requesting PEX peers for [" + this.snark.getInfoHash() + "]");
        }
        return rv;
    }

    private int getPeersFromDHT() {
        int rv = 0;
        DHT dht = this._util.getDHT();
        if (!(dht == null || this.meta != null && this.meta.isPrivate() || this.stop || this.meta != null && this._util.getContext().clock().now() <= this.lastDHTAnnounce + 900000L)) {
            int numwant = !this.coordinator.needOutboundPeers() ? 1 : this._util.getMaxConnections();
            Collection<Hash> hashes = dht.getPeersAndAnnounce(this.snark.getInfoHash(), numwant, 300000L, 8, 180000L, this.coordinator.completed(), numwant <= 1);
            if (!hashes.isEmpty()) {
                this.runStarted = true;
                this.lastDHTAnnounce = this._util.getContext().clock().now();
                rv = hashes.size();
            } else {
                this.lastDHTAnnounce = 0L;
            }
            if (this._log.shouldInfo()) {
                this._log.info("Received " + hashes.size() + " peer hashes from DHT");
            }
            if (this._log.shouldDebug()) {
                this._log.debug("DHT Peers: " + hashes);
            }
            if (!this.stop && !hashes.isEmpty()) {
                ArrayList<Peer> peers = new ArrayList<Peer>(hashes.size());
                for (Hash h : hashes) {
                    try {
                        PeerID pID = new PeerID(h.getData(), this._util);
                        peers.add(new Peer(pID, this.snark.getID(), this.snark.getInfoHash(), this.snark.getMetaInfo()));
                    }
                    catch (InvalidBEncodingException pID) {}
                }
                RandomSource r = this._util.getContext().random();
                Collections.shuffle(peers, r);
                Iterator it = peers.iterator();
                while (!this.stop && it.hasNext() && this.coordinator.needOutboundPeers()) {
                    Peer cur = (Peer)it.next();
                    if (!this.coordinator.addPeer(cur) || !it.hasNext()) continue;
                    int delay = ((Random)r).nextInt(6000) + 2000;
                    try {
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        } else if (this._log.shouldInfo()) {
            this._log.info("Not getting DHT peers");
        }
        return rv;
    }

    private int getWebPeers() {
        if (this.meta == null) {
            return 0;
        }
        if (this.coordinator.getNeededLength() <= 0L) {
            return 0;
        }
        List<String> urls = this.meta.getWebSeedURLs();
        if (urls == null || urls.isEmpty()) {
            return 0;
        }
        ArrayList<WebPeer> peers = new ArrayList<WebPeer>(urls.size());
        for (String url : urls) {
            Hash h = TrackerClient.getHostHash(url);
            if (h == null) continue;
            try {
                PeerID pID = new PeerID(h.getData(), this._util);
                byte[] id = new byte[20];
                System.arraycopy(WebPeer.IDBytes, 0, id, 0, 12);
                System.arraycopy(h.getData(), 0, id, 12, 8);
                pID.setID(id);
                URI uri = new URI(url);
                String host = uri.getHost();
                if (host == null) continue;
                if (this.coordinator.isWebPeerBanned(host)) {
                    if (!this._log.shouldWarn()) continue;
                    this._log.warn("Skipping banned webseed " + url);
                    continue;
                }
                peers.add(new WebPeer(this.coordinator, uri, pID, this.snark.getMetaInfo()));
            }
            catch (InvalidBEncodingException pID) {
            }
            catch (URISyntaxException pID) {}
        }
        if (peers.isEmpty()) {
            return 0;
        }
        RandomSource r = this._util.getContext().random();
        if (peers.size() > 1) {
            Collections.shuffle(peers, r);
        }
        Iterator it = peers.iterator();
        while (!this.stop && it.hasNext() && this.coordinator.needOutboundPeers()) {
            Peer cur = (Peer)it.next();
            if (!this.coordinator.addPeer(cur) || !it.hasNext()) continue;
            int delay = ((Random)r).nextInt(6000) + 2000;
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException interruptedException) {}
        }
        return peers.size();
    }

    private void unannounce() {
        DHT dht = this._util.getDHT();
        if (dht != null) {
            dht.unannounce(this.snark.getInfoHash());
        }
        int i = 0;
        for (TCTracker tr : this.trackers) {
            if (this._util.connected() && tr.started && !tr.stop && tr.trackerProblems == null) {
                try {
                    new I2PAppThread(new Unannouncer(tr), this._threadName + " U" + ++i, true).start();
                }
                catch (OutOfMemoryError oom) {
                    tr.reset();
                }
                continue;
            }
            tr.reset();
        }
    }

    private TrackerInfo doRequest(TCTracker tr, String infoHash, String peerID, long uploaded, long downloaded, long left, String event) throws IOException {
        String failure;
        boolean small;
        StringBuilder buf = new StringBuilder(512);
        buf.append(tr.announce);
        if (tr.announce.contains("?")) {
            buf.append('&');
        } else {
            buf.append('?');
        }
        buf.append("info_hash=").append(infoHash).append("&peer_id=").append(peerID).append("&port=").append(this.port).append("&ip=").append(this._util.getOurIPString()).append(".i2p").append("&uploaded=").append(uploaded).append("&downloaded=").append(downloaded).append("&left=");
        if (left >= 0L) {
            buf.append(left);
        } else {
            buf.append('1');
        }
        buf.append("&compact=1");
        if (!event.equals(NO_EVENT)) {
            buf.append("&event=").append(event);
        }
        buf.append("&numwant=");
        boolean bl = small = left == 0L || event.equals(STOPPED_EVENT) || !this.coordinator.needOutboundPeers();
        if (small) {
            buf.append('0');
        } else {
            buf.append(this._util.getMaxConnections());
        }
        String s = buf.toString();
        if (this._log.shouldDebug()) {
            this._log.debug("Sending TrackerClient request\n* URL: " + s);
        }
        tr.lastRequestTime = System.currentTimeMillis();
        boolean fast = this._fastUnannounce && event.equals(STOPPED_EVENT);
        byte[] fetched = this._util.get(s, true, fast ? -1 : 0, small ? 128 : 1024, small ? 1024 : 32768);
        if (fetched == null) {
            throw new IOException("No response from " + tr.host);
        }
        if (fetched.length == 0) {
            throw new IOException("No data from " + tr.host);
        }
        if (fetched[0] == 60) {
            throw new IOException("received html (invalid response) from " + tr.host);
        }
        ByteArrayInputStream in = new ByteArrayInputStream(fetched);
        TrackerInfo info = new TrackerInfo(in, this.snark.getID(), this.snark.getInfoHash(), this.snark.getMetaInfo(), this._util);
        if (this._log.shouldInfo()) {
            this._log.info("TrackerClient " + tr.host + " response: " + info);
        }
        if ((failure = info.getFailureReason()) != null) {
            throw new IOException(tr.host + " response: " + failure);
        }
        tr.interval = Math.max(600000L, (long)info.getInterval() * 1000L);
        return info;
    }

    public static String urlencode(byte[] bs) {
        StringBuilder sb = new StringBuilder(bs.length * 3);
        for (int i = 0; i < bs.length; ++i) {
            int c = bs[i] & 0xFF;
            if (c >= 48 && c <= 57 || c >= 65 && c <= 90 || c >= 97 && c <= 122) {
                sb.append((char)c);
                continue;
            }
            sb.append('%');
            if (c < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(c));
        }
        return sb.toString();
    }

    public static boolean isValidAnnounce(String ann) {
        URI url;
        if (ann == null) {
            return false;
        }
        try {
            url = new URI(ann);
        }
        catch (URISyntaxException use) {
            return false;
        }
        String path = url.getPath();
        if (path == null || !path.startsWith("/")) {
            return false;
        }
        return "http".equals(url.getScheme()) && url.getHost() != null && (url.getHost().endsWith(".i2p") || url.getHost().equals("i2p"));
    }

    private static Hash getHostHash(String ann) {
        URI url;
        try {
            url = new URI(ann);
        }
        catch (URISyntaxException use) {
            return null;
        }
        if (!"http".equals(url.getScheme())) {
            return null;
        }
        String host = url.getHost();
        if (host == null) {
            int slash;
            if (ann.startsWith("http://") && ann.length() >= 523 && ann.contains("~") && (slash = (ann = ann.substring(7)).indexOf(47)) >= 516) {
                if ((ann = ann.substring(0, slash)).endsWith(".i2p")) {
                    ann = ann.substring(0, ann.length() - 4);
                }
                return ConvertToHash.getHash(ann);
            }
            return null;
        }
        if (host.endsWith(".i2p")) {
            String path = url.getPath();
            if (path == null || !path.startsWith("/")) {
                return null;
            }
            return ConvertToHash.getHash(host);
        }
        if (host.equals("i2p")) {
            String path = url.getPath();
            if (path == null || path.length() < 517 || !path.startsWith("/")) {
                return null;
            }
            String[] parts = DataHelper.split(path.substring(1), "[/\\?&;]", 2);
            return ConvertToHash.getHash(parts[0]);
        }
        return null;
    }

    private static class TCTracker {
        final String announce;
        final String host;
        final boolean isPrimary;
        long interval;
        long lastRequestTime;
        String trackerProblems;
        boolean stop;
        boolean started;
        int registerFails;
        int consecutiveFails;
        int seenPeers;

        public TCTracker(String a, boolean p) {
            this.announce = a;
            String s = a.substring(7);
            this.host = s.substring(0, s.indexOf(47));
            this.isPrimary = p;
            this.interval = 90000L;
        }

        public void reset() {
            this.lastRequestTime = 0L;
            this.trackerProblems = null;
            this.stop = false;
            this.started = false;
            this.registerFails = 0;
            this.consecutiveFails = 0;
            this.seenPeers = 0;
        }
    }

    private class Unannouncer
    implements Runnable {
        private final TCTracker tr;

        public Unannouncer(TCTracker tr) {
            this.tr = tr;
        }

        @Override
        public void run() {
            if (TrackerClient.this._log.shouldDebug()) {
                TrackerClient.this._log.debug("Running unannounce " + TrackerClient.this._threadName + " to " + this.tr.announce);
            }
            long uploaded = TrackerClient.this.coordinator.getUploaded();
            long downloaded = TrackerClient.this.coordinator.getDownloaded();
            long len = TrackerClient.this.snark.getTotalLength();
            if (len > 0L && downloaded > len) {
                downloaded = len;
            }
            long left = TrackerClient.this.coordinator.getLeft();
            try {
                if (TrackerClient.this._util.connected() && this.tr.started && !this.tr.stop && this.tr.trackerProblems == null) {
                    TrackerClient.this.doRequest(this.tr, TrackerClient.this.infoHash, TrackerClient.this.peerID, uploaded, downloaded, left, TrackerClient.STOPPED_EVENT);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.tr.reset();
        }
    }

    private class Runner
    extends SimpleTimer2.TimedEvent {
        public Runner(long delay) {
            super(TrackerClient.this._util.getContext().simpleTimer2(), delay);
        }

        @Override
        public void timeReached() {
            TrackerClient.this._event = null;
            TrackerClient.this._thread = new I2PAppThread(TrackerClient.this, TrackerClient.this._threadName + " #" + ++TrackerClient.this._runCount, true);
            TrackerClient.this._thread.start();
        }
    }
}

