/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.io.File;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import net.i2p.I2PAppContext;
import net.i2p.crypto.TrustedUpdate;
import net.i2p.data.DataHelper;
import net.i2p.update.UpdateManager;
import net.i2p.update.UpdateMethod;
import net.i2p.update.UpdateTask;
import net.i2p.update.UpdateType;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer2;
import org.klomp.snark.BandwidthListener;
import org.klomp.snark.BitField;
import org.klomp.snark.CompleteListener;
import org.klomp.snark.MagnetURI;
import org.klomp.snark.MetaInfo;
import org.klomp.snark.Snark;
import org.klomp.snark.SnarkManager;
import org.klomp.snark.Storage;
import org.klomp.snark.comments.CommentSet;

class UpdateRunner
implements UpdateTask,
CompleteListener {
    private final I2PAppContext _context;
    private final Log _log;
    private final UpdateManager _umgr;
    private final SnarkManager _smgr;
    private final UpdateType _type;
    private final List<URI> _urls;
    private volatile boolean _isRunning;
    private volatile boolean _hasMetaInfo;
    private volatile boolean _isComplete;
    private final String _newVersion;
    private URI _currentURI;
    private Snark _snark;
    private static final long MAX_LENGTH = 0x8000000L;
    private static final long METAINFO_TIMEOUT = 3600000L;
    private static final long COMPLETE_TIMEOUT = 43200000L;
    private static final long CHECK_INTERVAL = 180000L;

    public UpdateRunner(I2PAppContext ctx, UpdateManager umgr, SnarkManager smgr, UpdateType type, List<URI> uris, String newVersion) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(this.getClass());
        this._umgr = umgr;
        this._smgr = smgr;
        this._type = type;
        this._urls = uris;
        this._newVersion = newVersion;
    }

    @Override
    public boolean isRunning() {
        return this._isRunning;
    }

    @Override
    public void shutdown() {
        this._isRunning = false;
        if (this._snark != null) {
            // empty if block
        }
    }

    @Override
    public UpdateType getType() {
        return this._type;
    }

    @Override
    public UpdateMethod getMethod() {
        return UpdateMethod.TORRENT;
    }

    @Override
    public URI getURI() {
        return this._currentURI;
    }

    @Override
    public String getID() {
        return "";
    }

    @Override
    public void start() {
        this._isRunning = true;
        this.update();
    }

    private void update() {
        Iterator<URI> iterator = this._urls.iterator();
        while (iterator.hasNext()) {
            URI uri;
            this._currentURI = uri = iterator.next();
            String updateURL = uri.toString();
            try {
                MagnetURI magnet = new MagnetURI(this._smgr.util(), updateURL);
                byte[] ih = magnet.getInfoHash();
                this._snark = this._smgr.getTorrentByInfoHash(ih);
                if (this._snark != null) {
                    if (this._snark.getMetaInfo() != null) {
                        this._hasMetaInfo = true;
                        Storage storage = this._snark.getStorage();
                        if (storage != null && storage.complete()) {
                            this.processComplete(this._snark);
                        }
                    }
                    if (this._isComplete) break;
                    if (this._snark.isStopped() && !this._snark.isStarting()) {
                        this._snark.startTorrent();
                    }
                    new Watcher();
                    break;
                }
                String name = magnet.getName();
                String trackerURL = magnet.getTrackerURL();
                if (trackerURL == null && !this._smgr.util().shouldUseDHT() && !this._smgr.util().shouldUseOpenTrackers()) {
                    this._umgr.notifyAttemptFailed(this, "No tracker, no DHT, no OT", null);
                    continue;
                }
                this._snark = this._smgr.addMagnet(name, ih, trackerURL, true, true, null, this);
                if (this._snark == null) continue;
                this.updateStatus("<b>" + this._smgr.util().getString("Updating from {0}", UpdateRunner.linkify(updateURL)) + "</b>");
                new Timeout();
                break;
            }
            catch (IllegalArgumentException iae) {
                this._log.error("Invalid update URL", iae);
            }
        }
        if (this._snark == null) {
            this.fatal("No valid URLs");
        }
    }

    private void fatal(String error) {
        if (this._snark != null) {
            if (this._hasMetaInfo) {
                if (!this._snark.isStopped()) {
                    this._smgr.stopTorrent(this._snark, true);
                }
                String file = this._snark.getName();
                this._smgr.removeTorrent(file);
                File f = new File(this._smgr.getDataDir(), file);
                f.delete();
                file = this._snark.getBaseName();
                f = new File(this._smgr.getDataDir(), file);
                f.delete();
            } else {
                this._smgr.deleteMagnet(this._snark);
            }
        }
        this._umgr.notifyTaskFailed(this, error, null);
        this._log.error(error);
        this._isRunning = false;
        if (this._smgr.util().connected() && !this._smgr.util().isConnecting()) {
            for (Snark s : this._smgr.getTorrents()) {
                if (s.isStopped()) continue;
                return;
            }
            this._smgr.util().disconnect();
        }
    }

    private void processComplete(Snark snark) {
        String dataFile = snark.getBaseName();
        File f = new File(this._smgr.getDataDir(), dataFile);
        String sudVersion = TrustedUpdate.getVersionString(f);
        if (this._newVersion.equals(sudVersion)) {
            this._umgr.notifyComplete(this, this._newVersion, f);
        } else {
            this.fatal("version mismatch");
        }
        this._isComplete = true;
    }

    private void notifyProgress() {
        if (this._hasMetaInfo) {
            long total = this._snark.getTotalLength();
            long remaining = this._snark.getRemainingLength();
            String status = "<b>" + this._smgr.util().getString("Updating") + "</b>";
            this._umgr.notifyProgress(this, status, total - remaining, total);
        }
    }

    @Override
    public void torrentComplete(Snark snark) {
        this.processComplete(snark);
        this._smgr.torrentComplete(snark);
    }

    @Override
    public void updateStatus(Snark snark) {
        if (snark.isStopped() && !this._isComplete) {
            this.fatal("stopped by user");
        }
        this._smgr.updateStatus(snark);
    }

    @Override
    public String gotMetaInfo(Snark snark) {
        MetaInfo info = snark.getMetaInfo();
        if (info.getFiles() != null) {
            this.fatal("more than 1 file");
            return null;
        }
        if (info.isPrivate()) {
            this.fatal("private torrent");
            return null;
        }
        if (info.getTotalLength() > 0x8000000L) {
            this.fatal("too big");
            return null;
        }
        this._hasMetaInfo = true;
        this.notifyProgress();
        snark.setAutoStoppable(true);
        return this._smgr.gotMetaInfo(snark);
    }

    @Override
    public void fatal(Snark snark, String error) {
        this.fatal(error);
        this._smgr.fatal(snark, error);
    }

    @Override
    public void addMessage(Snark snark, String message) {
        this._smgr.addMessage(snark, message);
    }

    @Override
    public void gotPiece(Snark snark) {
        this.notifyProgress();
        this._smgr.gotPiece(snark);
    }

    @Override
    public long getSavedTorrentTime(Snark snark) {
        return this._smgr.getSavedTorrentTime(snark);
    }

    @Override
    public BitField getSavedTorrentBitField(Snark snark) {
        return this._smgr.getSavedTorrentBitField(snark);
    }

    @Override
    public boolean getSavedPreserveNamesSetting(Snark snark) {
        return this._smgr.getSavedPreserveNamesSetting(snark);
    }

    @Override
    public long getSavedUploaded(Snark snark) {
        return this._smgr.getSavedUploaded(snark);
    }

    @Override
    public CommentSet getSavedComments(Snark snark) {
        return this._smgr.getSavedComments(snark);
    }

    @Override
    public void locked_saveComments(Snark snark, CommentSet comments) {
        this._smgr.locked_saveComments(snark, comments);
    }

    @Override
    public boolean shouldAutoStart() {
        return this._smgr.shouldAutoStart();
    }

    @Override
    public BandwidthListener getBandwidthListener() {
        return this._smgr.getBandwidthListener();
    }

    private static String linkify(String url) {
        String durl = url.length() <= 28 ? DataHelper.escapeHTML(url) : DataHelper.escapeHTML(url.substring(0, 25)) + "&hellip;";
        return "<a target=_blank href=\"" + DataHelper.escapeHTML(url) + "\"/>" + durl + "</a>";
    }

    private void updateStatus(String s) {
        this._umgr.notifyProgress(this, s);
    }

    public String toString() {
        return this.getClass().getName() + ' ' + (Object)((Object)this.getType()) + ' ' + this.getID() + ' ' + (Object)((Object)this.getMethod()) + ' ' + this.getURI();
    }

    private class Watcher
    extends SimpleTimer2.TimedEvent {
        private final long _start;

        public Watcher() {
            super(UpdateRunner.this._context.simpleTimer2(), 180000L);
            this._start = UpdateRunner.this._context.clock().now();
        }

        @Override
        public void timeReached() {
            if (UpdateRunner.this._hasMetaInfo && UpdateRunner.this._snark.getRemainingLength() == 0L && !UpdateRunner.this._isComplete) {
                UpdateRunner.this.processComplete(UpdateRunner.this._snark);
            }
            if (UpdateRunner.this._isComplete || !UpdateRunner.this._isRunning) {
                return;
            }
            if (UpdateRunner.this._context.clock().now() - this._start >= 3600000L && !UpdateRunner.this._hasMetaInfo) {
                UpdateRunner.this.fatal("Metainfo timeout");
                return;
            }
            if (UpdateRunner.this._context.clock().now() - this._start >= 43200000L) {
                UpdateRunner.this.fatal("Complete timeout");
                return;
            }
            UpdateRunner.this.notifyProgress();
            this.reschedule(180000L);
        }
    }

    private class Timeout
    extends SimpleTimer2.TimedEvent {
        private final long _start;

        public Timeout() {
            super(UpdateRunner.this._context.simpleTimer2(), 3600000L);
            this._start = UpdateRunner.this._context.clock().now();
        }

        @Override
        public void timeReached() {
            if (UpdateRunner.this._isComplete || !UpdateRunner.this._isRunning) {
                return;
            }
            if (!UpdateRunner.this._hasMetaInfo) {
                UpdateRunner.this.fatal("Metainfo timeout");
                return;
            }
            if (UpdateRunner.this._context.clock().now() - this._start >= 43200000L) {
                UpdateRunner.this.fatal("Complete timeout");
                return;
            }
            this.reschedule(39600000L);
        }
    }
}

