/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.client.impl.I2PSessionImpl;
import net.i2p.client.impl.I2PSessionMuxedImpl;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.i2cp.I2CPMessage;
import net.i2p.util.I2PAppThread;

class SubSession
extends I2PSessionMuxedImpl {
    private final I2PSessionMuxedImpl _primary;

    public SubSession(I2PSession primary, InputStream destKeyStream, Properties options) throws I2PSessionException {
        super((I2PSessionMuxedImpl)primary, destKeyStream, options);
        this._primary = (I2PSessionMuxedImpl)primary;
        if (this.getPrivateKey().equals(this._primary.getPrivateKey())) {
            throw new I2PSessionException("Signing Key must differ");
        }
    }

    @Override
    public I2PSession addSubsession(InputStream destKeyStream, Properties opts) throws I2PSessionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeSubsession(I2PSession session) {
    }

    @Override
    public List<I2PSession> getSubsessions() {
        return Collections.emptyList();
    }

    @Override
    public void updateOptions(Properties options) {
    }

    public Properties getPrimaryOptions() {
        return this._primary.getOptions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() throws I2PSessionException {
        Object object = this._stateLock;
        synchronized (object) {
            if (this._state != I2PSessionImpl.State.OPEN) {
                this.changeState(I2PSessionImpl.State.OPENING);
            }
        }
        boolean success = false;
        try {
            Object object2;
            this._primary.connect();
            int waitcount = 0;
            while (this._leaseSet == null) {
                if (waitcount++ > 600) {
                    throw new IOException("No tunnels built after waiting 5 minutes. Your network connection may be down, or there is severe network congestion.");
                }
                object2 = this._leaseSetWait;
                synchronized (object2) {
                    this._leaseSetWait.wait(500L);
                }
            }
            object2 = this._stateLock;
            synchronized (object2) {
                if (this._state != I2PSessionImpl.State.OPEN) {
                    I2PAppThread notifier = new I2PAppThread(this._availabilityNotifier, "ClientNotifier " + this.getName(), true);
                    ((Thread)notifier).start();
                    this.changeState(I2PSessionImpl.State.OPEN);
                }
            }
            success = true;
        }
        catch (InterruptedException ie) {
            throw new I2PSessionException("Interrupted", ie);
        }
        catch (IOException ioe) {
            throw new I2PSessionException(this.getPrefix() + "Cannot connect to the router on " + this._hostname + ':' + this._portNum, ioe);
        }
        finally {
            if (!success) {
                this._availabilityNotifier.stopNotifying();
                this.changeState(I2PSessionImpl.State.CLOSED);
            }
        }
    }

    @Override
    public boolean isClosed() {
        return super.isClosed() || this._primary.isClosed();
    }

    @Override
    void sendMessage(I2CPMessage message) throws I2PSessionException {
        if (this.isClosed() && message.getType() != 1 && message.getType() != 4) {
            throw new I2PSessionException("Already closed");
        }
        this._primary.sendMessage_unchecked(message);
    }

    @Override
    void sendMessage_unchecked(I2CPMessage message) throws I2PSessionException {
        this._primary.sendMessage_unchecked(message);
    }

    @Override
    void propogateError(String msg, Throwable error) {
        this._primary.propogateError(msg, error);
        if (this._sessionListener != null) {
            this._sessionListener.errorOccurred(this, msg, error);
        }
    }

    @Override
    public void destroySession() {
        this._primary.destroySession();
        if (this._availabilityNotifier != null) {
            this._availabilityNotifier.stopNotifying();
        }
        if (this._sessionListener != null) {
            this._sessionListener.disconnected(this);
        }
        this.changeState(I2PSessionImpl.State.CLOSED);
    }

    @Override
    protected void disconnect() {
        this._primary.disconnect();
    }

    @Override
    protected boolean reconnect() {
        return this._primary.reconnect();
    }

    @Override
    void destReceived(Destination d) {
        this._primary.destReceived(d);
    }

    @Override
    void destLookupFailed(Hash h) {
        this._primary.destLookupFailed(h);
    }

    @Override
    void destReceived(long nonce, Destination d) {
        this._primary.destReceived(nonce, d);
    }

    @Override
    void destLookupFailed(long nonce, int code) {
        this._primary.destLookupFailed(nonce, code);
    }

    @Override
    void bwReceived(int[] i) {
        this._primary.bwReceived(i);
    }

    @Override
    public Destination lookupDest(Hash h) throws I2PSessionException {
        return this._primary.lookupDest(h);
    }

    @Override
    public Destination lookupDest(Hash h, long maxWait) throws I2PSessionException {
        return this._primary.lookupDest(h, maxWait);
    }

    @Override
    public Destination lookupDest(String name) throws I2PSessionException {
        return this._primary.lookupDest(name);
    }

    @Override
    public Destination lookupDest(String name, long maxWait) throws I2PSessionException {
        return this._primary.lookupDest(name, maxWait);
    }

    @Override
    public int[] bandwidthLimits() throws I2PSessionException {
        return this._primary.bandwidthLimits();
    }

    @Override
    protected void updateActivity() {
        this._primary.updateActivity();
    }

    @Override
    public long lastActivity() {
        return this._primary.lastActivity();
    }

    @Override
    public void setReduced() {
        this._primary.setReduced();
    }
}

