/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.naming;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import net.i2p.I2PAppContext;
import net.i2p.client.naming.DummyNamingService;
import net.i2p.data.Destination;
import net.i2p.util.EepGet;

public class EepGetNamingService
extends DummyNamingService {
    private static final String PROP_EEPGET_LIST = "i2p.naming.eepget.list";
    private static final String DEFAULT_EEPGET_LIST = "http://i2host.i2p/cgi-bin/i2hostquery?";
    private static final int MAX_RESPONSE = 594;

    public EepGetNamingService(I2PAppContext context) {
        super(context);
    }

    private List<String> getURLs() {
        String list = this._context.getProperty(PROP_EEPGET_LIST, DEFAULT_EEPGET_LIST);
        StringTokenizer tok = new StringTokenizer(list, ",");
        ArrayList<String> rv = new ArrayList<String>(tok.countTokens());
        while (tok.hasMoreTokens()) {
            rv.add(tok.nextToken());
        }
        return rv;
    }

    @Override
    public Destination lookup(String hostname, Properties lookupOptions, Properties storedOptions) {
        String url;
        int i;
        Destination d = super.lookup(hostname, null, null);
        if (d != null) {
            return d;
        }
        if ((hostname = hostname.toLowerCase(Locale.US)).length() == 60 && hostname.endsWith(".b32.i2p")) {
            return null;
        }
        List<String> URLs = this.getURLs();
        if (URLs.isEmpty()) {
            return null;
        }
        for (i = 0; i < URLs.size(); ++i) {
            url = URLs.get(i);
            if (!url.startsWith("http://" + hostname + "/")) continue;
            this._log.error("Lookup loop: " + hostname);
            return null;
        }
        for (i = 0; i < URLs.size(); ++i) {
            url = URLs.get(i);
            String key = this.fetchAddr(url, hostname);
            if (key == null) continue;
            this._log.error("Success: " + url + hostname);
            d = this.lookupBase64(key);
            EepGetNamingService.putCache(hostname, d);
            return d;
        }
        return null;
    }

    private String fetchAddr(String url, String hostname) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(594);
        try {
            EepGet get = new EepGet(this._context, true, "localhost", 4444, 0, 516L, 594L, null, baos, url + hostname, false, null, null);
            if (get.fetch(10000L, 15000L, -1L)) {
                if (baos.size() < 516) {
                    this._log.error("Short response: " + url + hostname);
                    return null;
                }
                String key = baos.toString();
                if (key.startsWith(hostname + "=")) {
                    key = key.substring(hostname.length() + 1);
                }
                if (!(key = key.substring(0, 516)).endsWith("AA")) {
                    this._log.error("Invalid key: " + url + hostname);
                    return null;
                }
                if (key.replaceAll("[a-zA-Z0-9~-]", "").length() != 0) {
                    this._log.error("Invalid chars: " + url + hostname);
                    return null;
                }
                return key;
            }
            this._log.error("Transfer failed: " + url + hostname);
            return null;
        }
        catch (Throwable t) {
            this._log.error("Error fetching the addr", t);
            this._log.error("Caught from: " + url + hostname);
            return null;
        }
    }
}

