/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.naming;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArraySet;
import net.i2p.I2PAppContext;
import net.i2p.client.naming.DummyNamingService;
import net.i2p.client.naming.HostsTxtNamingService;
import net.i2p.client.naming.NamingServiceListener;
import net.i2p.client.naming.NamingServiceUpdater;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.util.Log;

public abstract class NamingService {
    protected final Log _log;
    protected final I2PAppContext _context;
    protected final Set<NamingServiceListener> _listeners;
    protected final Set<NamingServiceUpdater> _updaters;
    public static final String PROP_IMPL = "i2p.naming.impl";
    private static final String DEFAULT_IMPL = "net.i2p.router.naming.BlockfileNamingService";
    private static final String OLD_DEFAULT_IMPL = "net.i2p.client.naming.BlockfileNamingService";
    private static final String BACKUP_IMPL = "net.i2p.client.naming.HostsTxtNamingService";

    protected NamingService(I2PAppContext context) {
        this._context = context;
        this._log = context.logManager().getLog(this.getClass());
        this._listeners = new CopyOnWriteArraySet<NamingServiceListener>();
        this._updaters = new CopyOnWriteArraySet<NamingServiceUpdater>();
    }

    public Destination lookup(String hostname) {
        return this.lookup(hostname, null, null);
    }

    public String reverseLookup(Destination dest) {
        return this.reverseLookup(dest, null);
    }

    public String reverseLookup(Hash h) {
        return null;
    }

    protected Destination lookupBase64(String hostname) {
        try {
            Destination result = new Destination();
            result.fromBase64(hostname);
            return result;
        }
        catch (DataFormatException dfe) {
            if (this._log.shouldWarn()) {
                this._log.warn("Bad B64 dest [" + hostname + "]", dfe);
            }
            return null;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public Properties getConfiguration() {
        return null;
    }

    public boolean setConfiguration(Properties p) {
        return true;
    }

    public List<NamingService> getNamingServices() {
        return null;
    }

    public NamingService getParent() {
        return null;
    }

    public boolean addNamingService(NamingService ns) {
        return this.addNamingService(ns, false);
    }

    public boolean addNamingService(NamingService ns, boolean head) {
        return false;
    }

    public boolean removeNamingService(NamingService ns) {
        return false;
    }

    public int size() {
        return this.size(null);
    }

    public int size(Properties options) {
        return -1;
    }

    public Map<String, Destination> getEntries() {
        return this.getEntries(null);
    }

    public Map<String, Destination> getEntries(Properties options) {
        return Collections.emptyMap();
    }

    public Map<String, String> getBase64Entries(Properties options) {
        Map<String, Destination> entries = this.getEntries(options);
        if (entries.size() <= 0) {
            return Collections.emptyMap();
        }
        TreeMap<String, String> rv = new TreeMap<String, String>();
        for (Map.Entry<String, Destination> e : entries.entrySet()) {
            rv.put(e.getKey(), e.getValue().toBase64());
        }
        return rv;
    }

    public void export(Writer out) throws IOException {
        this.export(out, null);
    }

    public void export(Writer out, Properties options) throws IOException {
        String list;
        Map<String, String> entries = this.getBase64Entries(options);
        out.write("# Address book: ");
        out.write(this.getName());
        if (options != null && (list = options.getProperty("list")) != null) {
            out.write(" (" + list + ')');
        }
        String nl = System.getProperty("line.separator", "\n");
        out.write(nl);
        int sz = entries.size();
        if (sz <= 0) {
            out.write("# No entries");
            out.write(nl);
            return;
        }
        out.write("# Exported: ");
        out.write(new Date().toString());
        out.write(nl);
        if (sz > 1) {
            out.write("# " + sz + " entries");
            out.write(nl);
        }
        for (Map.Entry<String, String> e : entries.entrySet()) {
            out.write(e.getKey());
            out.write(61);
            out.write(e.getValue());
            out.write(nl);
        }
    }

    public Set<String> getNames() {
        return this.getNames(null);
    }

    public Set<String> getNames(Properties options) {
        return Collections.emptySet();
    }

    public boolean put(String hostname, Destination d) {
        return this.put(hostname, d, null);
    }

    public boolean put(String hostname, Destination d, Properties options) {
        return false;
    }

    public boolean putIfAbsent(String hostname, Destination d) {
        return this.putIfAbsent(hostname, d, null);
    }

    public boolean putIfAbsent(String hostname, Destination d, Properties options) {
        return false;
    }

    public boolean putAll(Map<String, Destination> entries, Properties options) {
        boolean rv = true;
        for (Map.Entry<String, Destination> entry : entries.entrySet()) {
            if (this.put(entry.getKey(), entry.getValue(), options)) continue;
            rv = false;
        }
        return rv;
    }

    public boolean update(String hostname, Destination d, Properties options) {
        return false;
    }

    public boolean remove(String hostname) {
        return this.remove(hostname, (Properties)null);
    }

    public boolean remove(String hostname, Properties options) {
        return false;
    }

    public void requestUpdate(Properties options) {
        for (NamingServiceUpdater nsu : this._updaters) {
            nsu.update(options);
        }
    }

    public void registerListener(NamingServiceListener nsl) {
        this._listeners.add(nsl);
    }

    public void unregisterListener(NamingServiceListener nsl) {
        this._listeners.remove(nsl);
    }

    public void registerUpdater(NamingServiceUpdater nsu) {
        this._updaters.add(nsu);
    }

    public void unregisterUpdater(NamingServiceUpdater nsu) {
        this._updaters.remove(nsu);
    }

    public abstract Destination lookup(String var1, Properties var2, Properties var3);

    public String reverseLookup(Destination d, Properties options) {
        return null;
    }

    public Destination lookupBase32(String hostname, int timeout) {
        return null;
    }

    public Destination lookup(Hash hash, int timeout) {
        return null;
    }

    public void start() {
    }

    public void shutdown() {
    }

    public List<Destination> lookupAll(String hostname) {
        return this.lookupAll(hostname, null, null);
    }

    public List<Destination> lookupAll(String hostname, Properties lookupOptions, List<Properties> storedOptions) {
        List<Destination> rv;
        Properties props = storedOptions != null ? new Properties() : null;
        Destination d = this.lookup(hostname, lookupOptions, props);
        if (d != null) {
            rv = Collections.singletonList(d);
            if (storedOptions != null) {
                storedOptions.add(props.isEmpty() ? null : props);
            }
        } else {
            rv = null;
        }
        return rv;
    }

    public boolean addDestination(String hostname, Destination d) {
        return this.addDestination(hostname, d, null);
    }

    public boolean addDestination(String hostname, Destination d, Properties options) {
        return this.putIfAbsent(hostname, d, options);
    }

    public boolean remove(String hostname, Destination d) {
        return this.remove(hostname, d, null);
    }

    public boolean remove(String hostname, Destination d, Properties options) {
        Destination old = this.lookup(hostname, options, null);
        if (!d.equals(old)) {
            return false;
        }
        return this.remove(hostname, options);
    }

    public List<String> reverseLookupAll(Hash h) {
        String s = this.reverseLookup(h);
        return s != null ? Collections.singletonList(s) : null;
    }

    public List<String> reverseLookupAll(Destination dest) {
        return this.reverseLookupAll(dest, null);
    }

    public List<String> reverseLookupAll(Destination d, Properties options) {
        String s = this.reverseLookup(d, options);
        return s != null ? Collections.singletonList(s) : null;
    }

    public static boolean isI2PHost(String hostname) {
        String lc = hostname.toLowerCase(Locale.US);
        return lc.endsWith(".i2p") || lc.endsWith(".i2p.alt");
    }

    public static boolean isB32Host(String hostname) {
        int len = hostname.length();
        if (len < 60) {
            return false;
        }
        String lc = hostname.toLowerCase(Locale.US);
        return lc.endsWith(".b32.i2p") || len >= 64 && lc.endsWith(".b32.i2p.alt");
    }

    public static boolean isBlindedHost(String hostname) {
        int len = hostname.length();
        if (len < 64) {
            return false;
        }
        String lc = hostname.toLowerCase(Locale.US);
        return lc.endsWith(".b32.i2p") || len >= 68 && lc.endsWith(".b32.i2p.alt");
    }

    public static final synchronized NamingService createInstance(I2PAppContext context) {
        NamingService instance = null;
        String dflt = context.isRouterContext() ? DEFAULT_IMPL : BACKUP_IMPL;
        String impl = context.getProperty(PROP_IMPL, dflt);
        if (impl.equals(OLD_DEFAULT_IMPL)) {
            impl = dflt;
        }
        try {
            Class<?> cls = Class.forName(impl);
            Constructor<?> con = cls.getConstructor(I2PAppContext.class);
            instance = (NamingService)con.newInstance(context);
        }
        catch (Exception ex) {
            Log log = context.logManager().getLog(NamingService.class);
            if (!impl.equals(BACKUP_IMPL)) {
                log.error("Cannot load naming service " + impl + ", using HostsTxtNamingService", ex);
                instance = new HostsTxtNamingService(context);
            }
            log.error("Cannot load naming service " + impl + ", only .b32.i2p lookups will succeed", ex);
            instance = new DummyNamingService(context);
        }
        return instance;
    }
}

