/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming.impl;

import java.util.List;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.streaming.impl.Connection;
import net.i2p.client.streaming.impl.Packet;
import net.i2p.client.streaming.impl.PacketLocal;
import net.i2p.data.ByteArray;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.SigningPublicKey;
import net.i2p.util.ByteCache;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer;

class ConnectionPacketHandler {
    private final I2PAppContext _context;
    private final Log _log;
    private final ByteCache _cache = ByteCache.getInstance(32, 4096);
    public static final int MAX_SLOW_START_WINDOW = 64;
    private static final int IMMEDIATE_ACK_DELAY = 120;
    static final String PROP_IMMEDIATE_ACK_DELAY = "i2p.streaming.immediateAckDelay";
    private static final long[] RATES = new long[]{60000L, 600000L, 3600000L, 86400000L};
    private static final int MAX_INITIAL_PACKETS = 3;

    public ConnectionPacketHandler(I2PAppContext context) {
        this._context = context;
        this._log = context.logManager().getLog(ConnectionPacketHandler.class);
        this._context.statManager().createFrequencyStat("stream.ack.dup.immediate", "How often duplicate packets get ACKed immediately", "Stream", RATES);
        this._context.statManager().createRateStat("stream.ack.dup.sent", "Was the ACK for a duplicate packet sent as scheduled?", "Stream", RATES);
        this._context.statManager().createRateStat("stream.con.initialRTT.in", "RTT for the first packet of an inbound connection", "Stream", RATES);
        this._context.statManager().createRateStat("stream.con.initialRTT.out", "RTT for the first packet of an outbound connection", "Stream", RATES);
        this._context.statManager().createRateStat("stream.con.packetsAckedPerMessageReceived", "Avg number of ACKs in a message", "Stream", RATES);
        this._context.statManager().createRateStat("stream.con.receiveDuplicateSize", "Size of a duplicate message received on a connection", "Stream", RATES);
        this._context.statManager().createRateStat("stream.con.receiveMessageSize", "Size of a message received on a connection", "Stream", RATES);
        this._context.statManager().createRateStat("stream.resetReceived", "Number of successful sent messages before receiving a RESET", "Stream", RATES);
        this._context.statManager().createRateStat("stream.sendsBeforeAck", "Number of times a message was sent before it was ACKed", "Stream", RATES);
    }

    void receivePacket(Packet packet, Connection con) throws I2PException {
        boolean isNew;
        int size;
        boolean ok = this.verifyPacket(packet, con);
        if (!ok) {
            boolean isTooFast;
            boolean bl = isTooFast = con.getSendStreamId() <= 0L;
            if (!packet.isFlagSet(4) && !isTooFast && this._log.shouldWarn()) {
                this._log.warn("Received packet that does NOT verify: " + packet + " on " + con);
            }
            packet.releasePayload();
            return;
        }
        long seqNum = packet.getSequenceNum();
        if (con.getHardDisconnected()) {
            if (seqNum > 0L || packet.getPayloadSize() > 0 || packet.isFlagSet(3)) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Received a data packet after hard disconnect: " + packet + " on " + con);
                }
                con.disconnect(false);
            } else if (this._log.shouldWarn()) {
                this._log.warn("Received a packet after hard disconnect, ignoring: " + packet + " on " + con);
            }
            packet.releasePayload();
            return;
        }
        if (con.getCloseSentOn() > 0L && con.getUnackedPacketsSent() <= 0 && seqNum > 0L && packet.getPayloadSize() > 0 && this._log.shouldInfo()) {
            this._log.info("Received new data when we've sent them data and all of our data is ACKed: " + packet + " on " + con + "");
        }
        if (packet.isFlagSet(128)) {
            if (!con.isInbound() || !packet.isFlagSet(1)) {
                int mtu;
                size = packet.getOptionalMaxSize();
                if (size < 512) {
                    size = 512;
                }
                if (size < (mtu = con.getOptions().getMaxMessageSize())) {
                    if (this._log.shouldInfo()) {
                        this._log.info("Reducing MTU to " + size + " bytes from " + mtu);
                    }
                    con.getOptions().setMaxMessageSize(size);
                    con.getOutputStream().setBufferSize(size);
                } else if (size > con.getOptions().getMaxInitialMessageSize()) {
                    if (size > mtu) {
                        size = mtu;
                    }
                    if (this._log.shouldInfo()) {
                        this._log.info("Increasing MTU to " + size + " bytes from " + con.getOptions().getMaxInitialMessageSize());
                    }
                    if (size != mtu) {
                        con.getOptions().setMaxMessageSize(size);
                    }
                    con.getOutputStream().setBufferSize(size);
                }
            }
        } else if (!con.isInbound() && packet.isFlagSet(1)) {
            size = 1730;
            if (1730 < con.getOptions().getMaxMessageSize()) {
                if (this._log.shouldInfo()) {
                    this._log.info("Received SYN ACK without MTU; reducing MTU to 1730 bytes (Max: " + con.getOptions().getMaxMessageSize() + ")");
                }
                con.getOptions().setMaxMessageSize(1730);
                con.getOutputStream().setBufferSize(1730);
            }
        }
        con.packetReceived();
        boolean choke = false;
        boolean delayReq = packet.isFlagSet(64);
        if (delayReq) {
            if (packet.getOptionalDelay() >= 60001) {
                choke = true;
                if (this._log.shouldWarn()) {
                    this._log.warn("Received a choke on " + con + ": " + packet);
                }
            }
            con.setChoked(choke);
        }
        if (!con.getInputStream().canAccept(seqNum, packet.getPayloadSize())) {
            if (con.getInputStream().isLocallyClosed()) {
                if (this._log.shouldWarn()) {
                    this._log.warn("More data received after local close on " + con + " -> Sending RESET and dropping " + packet);
                }
                con.disconnect(false);
            } else {
                if (this._log.shouldWarn()) {
                    this._log.warn("Inbound buffer exceeded on " + con + " -> Choking and dropping " + packet);
                }
                con.setChoking(true);
            }
            packet.releasePayload();
            return;
        }
        this._context.statManager().addRateData("stream.con.receiveMessageSize", packet.getPayloadSize());
        boolean allowAck = true;
        boolean isSYN = packet.isFlagSet(1);
        if (!isSYN && packet.getReceiveStreamId() <= 0L) {
            allowAck = false;
        }
        if ((isNew = seqNum > 0L || isSYN ? con.getInputStream().messageReceived(seqNum, packet.getPayload()) && allowAck : false) && packet.getPayloadSize() > 1500) {
            con.setChoking(false);
        }
        if (this._log.shouldDebug()) {
            String type = !allowAck ? "Non-SYN before SYN" : (isNew ? "New" : (packet.getPayloadSize() <= 0 ? "ACK-only" : "DUP"));
            this._log.debug(type + " Inbound packet: " + packet + " on " + con);
        }
        boolean ackOnly = false;
        if (isNew) {
            con.incrementUnackedPacketsReceived();
            con.incrementBytesReceived(packet.getPayloadSize());
            if (delayReq && packet.getOptionalDelay() <= 0) {
                if (this._log.shouldDebug()) {
                    this._log.debug("Scheduling immediate ACK for " + packet);
                }
                con.setNextSendTime(this._context.clock().now() + (long)Math.min(this._context.getProperty(PROP_IMMEDIATE_ACK_DELAY, 120), con.getOptions().getRTT() / 8));
            } else {
                int delay = delayReq ? packet.getOptionalDelay() : con.getOptions().getSendAckDelay();
                con.setNextSendTime((long)delay + this._context.clock().now());
                if (this._log.shouldDebug()) {
                    this._log.debug("Scheduling ACK in " + delay + "ms for received packet " + packet);
                }
            }
        } else if (seqNum > 0L || packet.getPayloadSize() > 0 || isSYN) {
            long nextSendTime;
            this._context.statManager().addRateData("stream.con.receiveDuplicateSize", packet.getPayloadSize());
            con.incrementDupMessagesReceived(1);
            long now = this._context.clock().now();
            int ackDelay = con.getOptions().getSendAckDelay();
            long lastSendTime = con.getLastSendTime();
            if (this._log.shouldInfo()) {
                this._log.info(String.format("%s \n* Congestion: DUP packet %s ACKDelay %d; Last Send: %s ago", con, packet, ackDelay, DataHelper.formatDuration(now - lastSendTime)));
            }
            if ((nextSendTime = lastSendTime + (long)Math.min(ackDelay, con.getOptions().getRTT() / 2)) <= now) {
                if (this._log.shouldInfo()) {
                    this._log.info("Immediate ACK");
                }
                con.ackImmediately();
                this._context.statManager().updateFrequency("stream.ack.dup.immediate");
            } else {
                long delay = nextSendTime - now;
                if (this._log.shouldInfo()) {
                    this._log.info("Scheduling ACK in " + delay);
                }
                con.schedule(new AckDup(con), delay);
            }
        } else if (isSYN) {
            con.setNextSendTime(this._context.clock().now() + (long)con.getOptions().getSendAckDelay());
        } else {
            if (this._log.shouldDebug()) {
                this._log.debug("Received ACK-only packet: " + packet);
            }
            ackOnly = true;
        }
        boolean fastAck = isSYN && packet.getSendStreamId() <= 0L ? false : this.ack(con, packet.getAckThrough(), packet.getNacks(), packet, isNew, choke);
        con.eventOccurred();
        if (fastAck && !choke && isNew) {
            long timeSinceSend = this._context.clock().now() - con.getLastSendTime();
            if (timeSinceSend >= 2000L) {
                if (this._log.shouldDebug()) {
                    this._log.debug("Fast ACK for DUP " + packet);
                }
                con.ackImmediately();
            } else if (this._log.shouldDebug()) {
                this._log.debug("Not fast ACKing DUP " + packet + " since we last sent " + timeSinceSend + "ms ago");
            }
        }
        if (ackOnly || !isNew) {
            packet.releasePayload();
        }
        if (packet.isFlagSet(2) && packet.isFlagSet(8)) {
            con.closeReceived();
            if (isNew) {
                con.updateShareOpts();
            }
        }
    }

    private boolean ack(Connection con, long ackThrough, long[] nacks, Packet packet, boolean isNew, boolean choke) {
        if (ackThrough < 0L) {
            return false;
        }
        boolean firstAck = isNew && con.getHighestAckedThrough() < 0L;
        int numResends = 0;
        List<PacketLocal> acked = null;
        if (packet == null || packet.getSendStreamId() <= 0L || packet.getReceiveStreamId() <= 0L || con == null || con.getSendStreamId() <= 0L || con.getReceiveStreamId() <= 0L || packet.getSendStreamId() == 0L || packet.getReceiveStreamId() == 0L || con.getSendStreamId() == 0L || con.getReceiveStreamId() == 0L) {
            return false;
        }
        acked = con.ackPackets(ackThrough, nacks);
        boolean lastPacketAcked = false;
        boolean receivedAck = con.getOptions().receivedAck();
        if (acked != null && !acked.isEmpty()) {
            if (this._log.shouldDebug()) {
                this._log.debug(acked.size() + " of our packets ACKed with " + packet);
            }
            int highestRTT = -1;
            for (int i = 0; i < acked.size(); ++i) {
                PacketLocal p = acked.get(i);
                int numSends = p.getNumSends();
                int ackTime = p.getAckTime();
                if (numSends > 1 && receivedAck) {
                    ++numResends;
                } else if (ackTime > highestRTT) {
                    highestRTT = ackTime;
                }
                this._context.statManager().addRateData("stream.sendsBeforeAck", numSends, ackTime);
                if (!this._log.shouldDebug()) continue;
                this._log.debug("Packet ACKed after " + ackTime + "ms: " + p);
            }
            if (highestRTT > 0) {
                if (this._log.shouldInfo()) {
                    int oldrtt = con.getOptions().getRTT();
                    int oldrto = con.getOptions().getRTO();
                    int olddev = con.getOptions().getRTTDev();
                    con.getOptions().updateRTT(highestRTT);
                    this._log.info("ACKed: " + acked.size() + " [Highest RTT: " + highestRTT + "; RTT: " + oldrtt + " -> " + con.getOptions().getRTT() + "; RTO: " + oldrto + " -> " + con.getOptions().getRTO() + "; Deviance: " + olddev + " -> " + con.getOptions().getRTTDev() + "]");
                } else {
                    con.getOptions().updateRTT(highestRTT);
                }
                if (firstAck) {
                    if (con.isInbound()) {
                        this._context.statManager().addRateData("stream.con.initialRTT.in", highestRTT);
                    } else {
                        this._context.statManager().addRateData("stream.con.initialRTT.out", highestRTT);
                    }
                }
            }
            this._context.statManager().addRateData("stream.con.packetsAckedPerMessageReceived", acked.size(), highestRTT);
            if (con.getCloseSentOn() > 0L && con.getUnackedPacketsSent() <= 0) {
                lastPacketAcked = true;
            }
        }
        boolean rv = this.adjustWindow(con, isNew, packet.getSequenceNum(), numResends, acked != null ? acked.size() : 0, choke);
        if (lastPacketAcked) {
            con.notifyLastPacketAcked();
        }
        return rv;
    }

    private boolean adjustWindow(Connection con, boolean isNew, long sequenceNum, int numResends, int acked, boolean choke) {
        boolean congested;
        if (choke || !isNew && sequenceNum > 0L || con.isChoked()) {
            if (this._log.shouldDebug()) {
                this._log.debug("Congestion on the sending side, not adjusting window...\n* " + con);
            }
            congested = true;
        } else {
            congested = false;
        }
        long lowest = con.getHighestAckedThrough();
        if (lowest >= con.getCongestionWindowEnd() || acked > 1 || con.getUnackedPacketsSent() > 0) {
            int oldWindow;
            int newWindowSize = oldWindow = con.getOptions().getWindowSize();
            if (!congested && acked > 0) {
                int ssthresh = con.getSSThresh();
                if (newWindowSize < ssthresh) {
                    int factor = con.getOptions().getSlowStartGrowthRateFactor();
                    newWindowSize = factor <= 1 ? Math.min(ssthresh, newWindowSize + acked) : (acked < factor ? ++newWindowSize : (newWindowSize += acked / factor));
                    if (this._log.shouldDebug()) {
                        this._log.debug("Slow start ACKs = " + acked + " for " + con);
                    }
                } else {
                    int shouldIncrement = this._context.random().nextInt(con.getOptions().getCongestionAvoidanceGrowthRateFactor() * newWindowSize);
                    if (shouldIncrement < acked) {
                        ++newWindowSize;
                    }
                    if (this._log.shouldDebug()) {
                        this._log.debug("Congestion Avoidance ACKs = " + acked + " for " + con);
                    }
                }
            } else if (this._log.shouldDebug()) {
                this._log.debug("No change to [Window " + con.getOptions().getWindowSize() + "]\n* Congested? " + congested + "; ACKed: " + acked + "; Resends: " + numResends);
            }
            if (newWindowSize <= 0) {
                newWindowSize = 1;
            }
            con.getOptions().setWindowSize(newWindowSize);
            con.setCongestionWindowEnd((long)newWindowSize + lowest);
            if (this._log.shouldInfo()) {
                this._log.info("New window size: " + newWindowSize + "/" + oldWindow + "/" + con.getOptions().getWindowSize() + " (resends: " + numResends + ") for " + con);
            }
        } else if (this._log.shouldDebug()) {
            this._log.debug("No change to [Window " + con.getOptions().getWindowSize() + "]\n* HighestAckedThrough: " + lowest + "; congestionWindowEnd: " + con.getCongestionWindowEnd() + "; ACKed: " + acked + "; UnACKed: " + con.getUnackedPacketsSent());
        }
        con.windowAdjusted();
        return congested;
    }

    private boolean verifyPacket(Packet packet, Connection con) throws I2PException {
        if (packet.isFlagSet(4)) {
            this.verifyReset(packet, con);
            return false;
        }
        this.verifySignature(packet, con);
        if (con.getSendStreamId() <= 0L) {
            if (packet.isFlagSet(1)) {
                con.setSendStreamId(packet.getReceiveStreamId());
                Destination dest = packet.getOptionalFrom();
                if (dest == null) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Received SYN Packet without FROM");
                    }
                    return false;
                }
                con.setRemotePeer(dest);
                SigningPublicKey spk = packet.getTransientSPK();
                if (spk != null) {
                    con.setRemoteTransientSPK(spk);
                }
                return true;
            }
            if (packet.getSequenceNum() < 3L) {
                return true;
            }
            if (this._log.shouldWarn()) {
                this._log.warn("Received packet without RESET or SYN where we don't know StreamID: " + packet);
            }
            return false;
        }
        if (con.getSendStreamId() != packet.getReceiveStreamId()) {
            if (this._log.shouldWarn()) {
                this._log.warn("Received packet with the WRONG reply StreamID \n* " + con + " / " + packet);
            }
            return false;
        }
        return true;
    }

    private void verifyReset(Packet packet, Connection con) {
        if (con.getReceiveStreamId() == packet.getSendStreamId()) {
            Destination d1 = con.getRemotePeer();
            Destination d2 = packet.getOptionalFrom();
            if (d1 != null && d2 != null && !d1.equals(d2)) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Received RESET packet from WRONG destination on " + con);
                }
                return;
            }
            SigningPublicKey spk = con.getRemoteSPK();
            ByteArray ba = (ByteArray)this._cache.acquire();
            boolean ok = packet.verifySignature(this._context, spk, ba.getData());
            this._cache.release(ba);
            if (!ok) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Received unsigned or forged RESET packet on: " + con);
                }
                return;
            }
            if (this._log.shouldWarn()) {
                this._log.warn("Received RESET packet on " + con);
            }
            con.resetReceived();
            con.eventOccurred();
            this._context.statManager().addRateData("stream.resetReceived", con.getHighestAckedThrough(), con.getLifetime());
            return;
        }
        if (this._log.shouldWarn()) {
            this._log.warn("Received a RESET packet for the WRONG connection? " + con + " / " + packet);
        }
    }

    private void verifySignature(Packet packet, Connection con) throws I2PException {
        Destination d1 = con.getRemotePeer();
        Destination d2 = packet.getOptionalFrom();
        if (d1 != null && d2 != null && !d1.equals(d2)) {
            throw new I2PException("Received packet from WRONG destination on " + con);
        }
        if (con.getOptions().getRequireFullySigned() || packet.isFlagSet(11)) {
            SigningPublicKey spk = con.getRemoteSPK();
            ByteArray ba = (ByteArray)this._cache.acquire();
            boolean sigOk = packet.verifySignature(this._context, spk, ba.getData());
            this._cache.release(ba);
            if (!sigOk) {
                throw new I2PException("Received unsigned / forged packet: " + packet);
            }
        }
    }

    private class AckDup
    implements SimpleTimer.TimedEvent {
        private final long _created;
        private final Connection _con;

        public AckDup(Connection con) {
            this._created = ConnectionPacketHandler.this._context.clock().now();
            this._con = con;
        }

        @Override
        public void timeReached() {
            boolean sent = false;
            if (this._con.getLastSendTime() <= this._created) {
                if (this._con.getResetReceived() || this._con.getResetSent()) {
                    if (ConnectionPacketHandler.this._log.shouldDebug()) {
                        ConnectionPacketHandler.this._log.debug("ACK DUP on " + this._con + ", but we have been reset");
                    }
                    return;
                }
                if (ConnectionPacketHandler.this._log.shouldDebug()) {
                    ConnectionPacketHandler.this._log.debug("Last sent was a while ago, and we want to ACK a DUP on " + this._con);
                }
                this._con.ackImmediately();
                sent = true;
            } else if (ConnectionPacketHandler.this._log.shouldDebug()) {
                ConnectionPacketHandler.this._log.debug("ACK DUP on " + this._con + ", but we have sent (" + (this._con.getLastSendTime() - this._created) + ")");
            }
            ConnectionPacketHandler.this._context.statManager().addRateData("stream.ack.dup.sent", sent ? 1L : 0L);
        }
    }
}

