/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import gnu.getopt.Getopt;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import net.i2p.I2PAppContext;
import net.i2p.data.Base32;
import net.i2p.data.DataHelper;
import net.i2p.util.EepGet;

public class EepPost
extends EepGet {
    private static final String CRLF = "\r\n";
    private static final byte[] CRLFB = DataHelper.getASCII("\r\n");
    private static final int PROP_MAX_POST_PAYLOAD_RAM = 32768;

    public EepPost(I2PAppContext ctx, String proxyHost, int proxyPort, int numRetries, String outputFile, String url) {
        super(ctx, true, proxyHost, proxyPort, numRetries, -1L, -1L, outputFile, null, url, true, null, null);
    }

    public boolean post(Map<String, Object> fields, long headerTimeout, long totalTimeout, long inactivityTimeout) {
        if (fields.isEmpty()) {
            throw new IllegalArgumentException();
        }
        boolean multipart = false;
        long sz = 0L;
        for (Object o : fields.values()) {
            if (!(o instanceof File)) continue;
            sz += ((File)o).length();
            multipart = true;
            break;
        }
        if (multipart) {
            boolean rv;
            String sep = multipart ? this.getSeparator() : null;
            boolean useTmp = sz > 32768L;
            File tmp = null;
            OutputStream out = null;
            ByteArrayOutputStream baos = null;
            try {
                if (useTmp) {
                    tmp = new File(this._context.getTempDir(), "eeppost-" + this._context.random().nextLong() + ".dat");
                    out = new FileOutputStream(tmp);
                    if (this._log.shouldDebug()) {
                        this._log.debug("Estimated size: " + sz + ", using temp file " + tmp);
                    }
                } else {
                    baos = new ByteArrayOutputStream(4096);
                }
                EepPost.sendFields(out, sep, fields);
                if (useTmp) {
                    out.close();
                }
            }
            catch (IOException ioe) {
                try {
                    out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (tmp != null) {
                    tmp.delete();
                }
                return false;
            }
            String type = "multipart/form-data, boundary=" + sep;
            if (tmp != null) {
                rv = this.post(type, tmp, headerTimeout, totalTimeout, inactivityTimeout);
                tmp.delete();
            } else {
                rv = this.post(type, baos.toByteArray(), headerTimeout, totalTimeout, inactivityTimeout);
            }
            return rv;
        }
        StringBuilder out = new StringBuilder(2048);
        EepPost.sendFields(out, fields);
        String type = "application/x-www-form-urlencoded";
        return this.post(type, out.toString(), headerTimeout, totalTimeout, inactivityTimeout);
    }

    public boolean post(String contentType, String data, long headerTimeout, long totalTimeout, long inactivityTimeout) {
        if (data.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.setPostData(contentType, data);
        return super.fetch(headerTimeout, totalTimeout, inactivityTimeout);
    }

    public boolean post(String contentType, byte[] data, long headerTimeout, long totalTimeout, long inactivityTimeout) {
        if (data.length == 0) {
            throw new IllegalArgumentException();
        }
        this.setPostData(contentType, data);
        return super.fetch(headerTimeout, totalTimeout, inactivityTimeout);
    }

    public boolean post(String contentType, File data, long headerTimeout, long totalTimeout, long inactivityTimeout) {
        if (!data.isFile() || data.length() == 0L) {
            throw new IllegalArgumentException();
        }
        this.setPostData(contentType, data);
        return super.fetch(headerTimeout, totalTimeout, inactivityTimeout);
    }

    @Override
    public boolean fetch() {
        throw new UnsupportedOperationException("use post()");
    }

    @Override
    public boolean fetch(long fetchHeaderTimeout) {
        throw new UnsupportedOperationException("use post()");
    }

    @Override
    public boolean fetch(long fetchHeaderTimeout, long totalTimeout, long inactivityTimeout) {
        throw new UnsupportedOperationException("use post()");
    }

    private static void sendFields(StringBuilder out, Map<String, Object> fields) {
        boolean first = true;
        for (Map.Entry<String, Object> e : fields.entrySet()) {
            String field = e.getKey();
            Object val = e.getValue();
            if (!first) {
                out.append('&');
            }
            EepPost.sendField(out, field, val.toString());
            first = false;
        }
        out.append(CRLF);
    }

    private static void sendFields(OutputStream out, String separator, Map<String, Object> fields) throws IOException {
        for (Map.Entry<String, Object> e : fields.entrySet()) {
            String field = e.getKey();
            Object val = e.getValue();
            if (val instanceof File) {
                EepPost.sendFile(out, separator, field, (File)val);
                continue;
            }
            EepPost.sendField(out, separator, field, val.toString());
        }
        out.write(DataHelper.getUTF8("--" + separator + "--" + CRLF));
    }

    private static void sendField(StringBuilder out, String field, String val) {
        out.append(field.replace(" ", "+")).append('=').append(val.replace(" ", "+"));
    }

    private static void sendField(OutputStream out, String separator, String field, String val) throws IOException {
        out.write(DataHelper.getUTF8("--" + separator + CRLF));
        out.write(DataHelper.getUTF8("Content-Disposition: form-data; name=\"" + field + "\"" + CRLF + CRLF));
        out.write(DataHelper.getUTF8(val));
        out.write(CRLFB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendFile(OutputStream out, String separator, String field, File file) throws IOException {
        out.write(DataHelper.getUTF8("--" + separator + CRLF));
        out.write(DataHelper.getUTF8("Content-Disposition: form-data; name=\"" + field + "\"; filename=\"" + file.getName() + "\"" + CRLF));
        out.write(DataHelper.getUTF8("Content-Type: application/octet-stream\r\n\r\n"));
        try (FileInputStream in = new FileInputStream(file);){
            DataHelper.copy(in, out);
        }
        out.write(CRLFB);
    }

    private String getSeparator() {
        byte[] separator = new byte[32];
        this._context.random().nextBytes(separator);
        return Base32.encode(separator);
    }

    public static void main(String[] args) {
        String proxyHost = "127.0.0.1";
        int proxyPort = 4444;
        int numRetries = 0;
        int headerTimeout = 90000;
        int totalTimeout = -1;
        int inactivityTimeout = 120000;
        int markSize = 1024;
        int lineLen = 40;
        String saveAs = null;
        String username = null;
        String password = null;
        boolean error = false;
        HashMap<String, Object> fields = new HashMap<String, Object>(8);
        Getopt g = new Getopt("eeppost", args, "p:cn:t:v:w:o:u:x:l:m:s:f:");
        try {
            int c;
            block19: while ((c = g.getopt()) != -1) {
                switch (c) {
                    case 112: {
                        String s = g.getOptarg();
                        int colon = s.indexOf(58);
                        if (colon >= 0) {
                            proxyHost = s.substring(0, colon);
                            String port = s.substring(colon + 1);
                            proxyPort = Integer.parseInt(port);
                            continue block19;
                        }
                        proxyHost = s;
                        continue block19;
                    }
                    case 99: {
                        proxyHost = "";
                        proxyPort = 0;
                        continue block19;
                    }
                    case 102: {
                        String[] t = DataHelper.split(g.getOptarg(), "=", 2);
                        if (t.length == 2 && t[0].length() > 0) {
                            fields.put(t[0], new File(t[1]));
                            continue block19;
                        }
                        error = true;
                        continue block19;
                    }
                    case 108: {
                        lineLen = Integer.parseInt(g.getOptarg());
                        continue block19;
                    }
                    case 109: {
                        markSize = Integer.parseInt(g.getOptarg());
                        continue block19;
                    }
                    case 110: {
                        numRetries = Integer.parseInt(g.getOptarg());
                        continue block19;
                    }
                    case 111: {
                        saveAs = g.getOptarg();
                        continue block19;
                    }
                    case 115: {
                        String[] t = DataHelper.split(g.getOptarg(), "=", 2);
                        if (t.length == 2 && t[0].length() > 0) {
                            fields.put(t[0], t[1]);
                            continue block19;
                        }
                        error = true;
                        continue block19;
                    }
                    case 116: {
                        inactivityTimeout = 1000 * Integer.parseInt(g.getOptarg());
                        continue block19;
                    }
                    case 117: {
                        username = g.getOptarg();
                        continue block19;
                    }
                    case 118: {
                        headerTimeout = 1000 * Integer.parseInt(g.getOptarg());
                        continue block19;
                    }
                    case 119: {
                        totalTimeout = 1000 * Integer.parseInt(g.getOptarg());
                        continue block19;
                    }
                    case 120: {
                        password = g.getOptarg();
                        continue block19;
                    }
                }
                error = true;
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            error = true;
        }
        if (error || args.length - g.getOptind() != 1 || fields.isEmpty()) {
            if (fields.isEmpty()) {
                System.err.println("At least one -s or -f parameter required");
            }
            EepPost.usage();
            System.exit(1);
        }
        String url = args[g.getOptind()];
        if (saveAs == null) {
            saveAs = EepPost.suggestName(url);
        }
        EepPost post = new EepPost(I2PAppContext.getGlobalContext(), proxyHost, proxyPort, numRetries, saveAs, url);
        if (username != null) {
            if (password == null) {
                try {
                    BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
                    do {
                        System.err.print("Proxy password: ");
                        password = r.readLine();
                        if (password != null) continue;
                        throw new IOException();
                    } while ((password = password.trim()).length() <= 0);
                }
                catch (IOException ioe) {
                    System.exit(1);
                }
            }
            post.addAuthorization(username, password);
        }
        EepPost eepPost = post;
        eepPost.getClass();
        post.addStatusListener(eepPost.new EepGet.CLIStatusListener(markSize, lineLen));
        if (!post.post(fields, headerTimeout, totalTimeout, inactivityTimeout)) {
            System.err.println("Failed " + url);
            System.exit(1);
        }
    }

    private static void usage() {
        System.err.println("eeppost [-p 127.0.0.1[:4444]] [-c] [-o outputFile]\n        [-s key=value]*\n        [-f key=file]*\n        [-m markSize] (default 1024)\n        [-l lineLen]  (default 40)\n        [-n #retries] (default 0)\n        [-t headerTimeout]  (default 45 sec)\n        [-u inactivityTimeout]  (default 60 sec)\n        [-w totalTimeout]  (default unlimited)\n        [-u username] [-x password] url\n        (use -c or -p :0 for no proxy)");
    }
}

