/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.util.Locale;
import net.i2p.I2PAppContext;
import net.i2p.util.LogManager;
import net.i2p.util.LogRecord;

public class Log {
    private final Class<?> _class;
    private final String _className;
    private final String _name;
    private int _minPriority;
    private final LogScope _scope;
    private final LogManager _manager;
    public static final int DEBUG = 10;
    public static final int INFO = 20;
    public static final int WARN = 30;
    public static final int ERROR = 40;
    public static final int CRIT = 50;
    public static final String STR_DEBUG = "DEBUG";
    public static final String STR_INFO = "INFO";
    public static final String STR_WARN = "WARN";
    public static final String STR_ERROR = "ERROR";
    public static final String STR_CRIT = "CRIT";

    public static int getLevel(String level) {
        if (level == null) {
            return 40;
        }
        if (STR_DEBUG.startsWith(level = level.toUpperCase(Locale.US))) {
            return 10;
        }
        if (STR_INFO.startsWith(level)) {
            return 20;
        }
        if (STR_WARN.startsWith(level)) {
            return 30;
        }
        if (STR_ERROR.startsWith(level)) {
            return 40;
        }
        if (STR_CRIT.startsWith(level)) {
            return 50;
        }
        return 40;
    }

    public static String toLevelString(int level) {
        switch (level) {
            case 10: {
                return STR_DEBUG;
            }
            case 20: {
                return STR_INFO;
            }
            case 30: {
                return STR_WARN;
            }
            case 40: {
                return STR_ERROR;
            }
            case 50: {
                return STR_CRIT;
            }
        }
        return level > 50 ? STR_CRIT : STR_DEBUG;
    }

    public Log(Class<?> cls) {
        this(I2PAppContext.getGlobalContext().logManager(), cls, null);
        this._manager.addLog(this);
    }

    public Log(String name) {
        this(I2PAppContext.getGlobalContext().logManager(), null, name);
        this._manager.addLog(this);
    }

    Log(LogManager manager, Class<?> cls) {
        this(manager, cls, null);
    }

    Log(LogManager manager, String name) {
        this(manager, null, name);
    }

    Log(LogManager manager, Class<?> cls, String name) {
        this._manager = manager;
        this._class = cls;
        this._className = cls != null ? cls.getName() : null;
        this._name = name;
        this._minPriority = 10;
        this._scope = new LogScope(name, cls);
    }

    public void log(int priority, String msg) {
        if (priority >= this._minPriority) {
            this._manager.addRecord(new LogRecord(this._class, this._name, Thread.currentThread().getName(), priority, msg, null));
        }
    }

    public void log(int priority, String msg, Throwable t) {
        if (priority >= this._minPriority) {
            this._manager.addRecord(new LogRecord(this._class, this._name, Thread.currentThread().getName(), priority, msg, t));
        }
    }

    public void logAlways(int priority, String msg) {
        this._manager.addRecord(new LogRecord(this._class, this._name, Thread.currentThread().getName(), priority, msg, null));
    }

    public void debug(String msg) {
        this.log(10, msg);
    }

    public void debug(String msg, Throwable t) {
        this.log(10, msg, t);
    }

    public void info(String msg) {
        this.log(20, msg);
    }

    public void info(String msg, Throwable t) {
        this.log(20, msg, t);
    }

    public void warn(String msg) {
        this.log(30, msg);
    }

    public void warn(String msg, Throwable t) {
        this.log(30, msg, t);
    }

    public void error(String msg) {
        this.log(40, msg);
    }

    public void error(String msg, Throwable t) {
        this.log(40, msg, t);
    }

    public int getMinimumPriority() {
        return this._minPriority;
    }

    public void setMinimumPriority(int priority) {
        this._minPriority = priority;
    }

    public boolean shouldLog(int priority) {
        return priority >= this._minPriority;
    }

    public boolean shouldDebug() {
        return 10 >= this._minPriority;
    }

    public boolean shouldInfo() {
        return 20 >= this._minPriority;
    }

    public boolean shouldWarn() {
        return 30 >= this._minPriority;
    }

    public boolean shouldError() {
        return 40 >= this._minPriority;
    }

    public void logCloseLoop(Object ... desc) {
        this.logCloseLoop(10, desc);
    }

    public void logCloseLoop(int level, Object ... desc) {
        if (!this.shouldLog(level)) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("close() loop in");
        for (Object o : desc) {
            builder.append(" ");
            builder.append(String.valueOf(o));
        }
        Exception e = new Exception("check stack trace");
        this.log(level, builder.toString(), e);
    }

    public String getName() {
        if (this._className != null) {
            return this._className;
        }
        return this._name;
    }

    public Object getScope() {
        return this._scope;
    }

    static String getScope(String name, Class<?> cls) {
        if (name == null && cls == null) {
            return "f00";
        }
        if (cls == null) {
            return name;
        }
        if (name == null) {
            return cls.getName();
        }
        return name + "" + cls.getName();
    }

    private static final class LogScope {
        private final String _scopeCache;

        public LogScope(String name, Class<?> cls) {
            this._scopeCache = Log.getScope(name, cls);
        }

        public int hashCode() {
            return this._scopeCache.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            LogScope other = (LogScope)obj;
            return this._scopeCache.equals(other._scopeCache);
        }
    }
}

