/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.i2p.I2PAppContext;
import net.i2p.util.Log;
import net.i2p.util.LogManager;
import net.i2p.util.LogRecord;
import net.i2p.util.Translate;

class LogRecordFormatter {
    static final String NL = System.getProperty("line.separator");
    private static final int MAX_WHERE_LENGTH = 16;
    private static final int MAX_THREAD_LENGTH = 11;
    private static final int MAX_PRIORITY_LENGTH = 5;
    private static final String BUNDLE_NAME = "net.i2p.util.messages";

    LogRecordFormatter() {
    }

    public static String formatRecord(LogManager manager, LogRecord rec) {
        return LogRecordFormatter.formatRecord(manager, rec, true);
    }

    static String formatRecord(LogManager manager, LogRecord rec, boolean showDate) {
        int size = 128 + rec.getMessage().length();
        if (rec.getThrowable() != null) {
            size += 512;
        }
        StringBuilder buf = new StringBuilder(size);
        char[] format = manager.getFormat();
        block7: for (int i = 0; i < format.length; ++i) {
            switch (format[i]) {
                case 'd': {
                    if (showDate) {
                        buf.append(LogRecordFormatter.getWhen(manager, rec));
                        continue block7;
                    }
                    if (i + 1 >= format.length || format[i + 1] != ' ') continue block7;
                    ++i;
                    continue block7;
                }
                case 'c': {
                    buf.append(LogRecordFormatter.getWhere(rec));
                    continue block7;
                }
                case 't': {
                    buf.append(LogRecordFormatter.getThread(rec));
                    continue block7;
                }
                case 'p': {
                    buf.append("| " + LogRecordFormatter.getPriority(rec, manager.getContext()));
                    continue block7;
                }
                case 'm': {
                    String msg = LogRecordFormatter.getWhat(rec);
                    if (msg == null) continue block7;
                    buf.append(msg);
                    continue block7;
                }
                default: {
                    buf.append(format[i]);
                }
            }
        }
        buf.append(NL);
        if (rec.getThrowable() != null) {
            StringWriter sw = new StringWriter(512);
            PrintWriter pw = new PrintWriter(sw);
            rec.getThrowable().printStackTrace(pw);
            pw.flush();
            buf.append(sw.toString());
        }
        return buf.toString();
    }

    private static String getThread(LogRecord logRecord) {
        return LogRecordFormatter.toString(logRecord.getThreadName(), 11);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getWhen(LogManager manager, LogRecord logRecord) {
        SimpleDateFormat fmt = manager.getDateFormat();
        Date d = new Date(logRecord.getDate());
        SimpleDateFormat simpleDateFormat = fmt;
        synchronized (simpleDateFormat) {
            return fmt.format(d);
        }
    }

    private static String getPriority(LogRecord rec, I2PAppContext ctx) {
        int len = Translate.getLanguage(ctx).equals("de") ? 8 : 5;
        StringBuilder buf = new StringBuilder();
        while (buf.length() < len) {
            buf.append(' ');
        }
        return LogRecordFormatter.toString(Translate.getString(Log.toLevelString(rec.getPriority()), ctx, BUNDLE_NAME), len);
    }

    private static String getWhat(LogRecord rec) {
        return rec.getMessage();
    }

    private static String getWhere(LogRecord rec) {
        String src;
        String string = src = rec.getSource() != null ? rec.getSource().getName() : rec.getSourceName();
        if (src == null) {
            src = "<none>";
        }
        return LogRecordFormatter.toString(src, 16);
    }

    private static String toString(String str, int size) {
        String ellipsis = "...";
        StringBuilder buf = new StringBuilder();
        if (str == null) {
            str = "";
        }
        if (str.length() > size) {
            str = str.substring(str.length() - size);
            buf.append(ellipsis);
        }
        buf.append(str);
        while (buf.length() < size) {
            buf.append(' ');
        }
        return buf.toString();
    }

    private static String _x(String s) {
        return s;
    }

    static {
        String[] stringArray = new String[]{LogRecordFormatter._x("CRIT"), LogRecordFormatter._x("ERROR"), LogRecordFormatter._x("WARN"), LogRecordFormatter._x("INFO"), LogRecordFormatter._x("DEBUG")};
    }
}

