/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.streaming.I2PServerSocket;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.RouterRestartException;
import net.i2p.data.Hash;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;
import net.i2p.util.ObjectCounter;
import net.i2p.util.SimpleTimer2;
import org.klomp.snark.I2PSnarkUtil;
import org.klomp.snark.PeerAcceptor;
import org.klomp.snark.PeerCoordinatorSet;

class ConnectionAcceptor
implements Runnable {
    private final Log _log = I2PAppContext.getGlobalContext().logManager().getLog(ConnectionAcceptor.class);
    private final PeerAcceptor peeracceptor;
    private Thread thread;
    private final I2PSnarkUtil _util;
    private final ObjectCounter<Hash> _badCounter = new ObjectCounter();
    private final SimpleTimer2.TimedEvent _cleaner;
    private volatile boolean stop;
    private static final int MAX_BAD = 1;
    private static final long BAD_CLEAN_INTERVAL = 900000L;

    public ConnectionAcceptor(I2PSnarkUtil util, PeerCoordinatorSet set) {
        this._util = util;
        this._cleaner = new Cleaner();
        this.peeracceptor = new PeerAcceptor(set);
    }

    public synchronized void startAccepting() {
        this.stop = false;
        if (this._log.shouldWarn()) {
            this._log.warn("[I2PSnark] ConnectionAcceptor: Start accepting new thread? " + (this.thread == null));
        }
        if (this.thread == null) {
            this.thread = new I2PAppThread(this, "I2PSnark acceptor");
            this.thread.setDaemon(true);
            this.thread.start();
            this._cleaner.reschedule(900000L, false);
        }
    }

    public ConnectionAcceptor(I2PSnarkUtil util, PeerAcceptor peeracceptor) {
        this.peeracceptor = peeracceptor;
        this._util = util;
        this.thread = new I2PAppThread(this, "I2PSnark acceptor");
        this.thread.setDaemon(true);
        this.thread.start();
        this._cleaner = new Cleaner();
    }

    public synchronized void halt() {
        if (this.stop) {
            return;
        }
        this.stop = true;
        this.locked_halt();
        Thread t = this.thread;
        if (t != null) {
            t.interrupt();
            this.thread = null;
        }
    }

    private void locked_halt() {
        I2PServerSocket ss = this._util.getServerSocket();
        if (ss != null) {
            try {
                ss.close();
            }
            catch (I2PException i2PException) {
                // empty catch block
            }
        }
        this._badCounter.clear();
        this._cleaner.cancel();
    }

    public synchronized void restart() {
        Thread t = this.thread;
        if (t != null) {
            t.interrupt();
        } else {
            this.startAccepting();
        }
    }

    public int getPort() {
        return 6881;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.run2();
        }
        finally {
            ConnectionAcceptor connectionAcceptor = this;
            synchronized (connectionAcceptor) {
                this.thread = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run2() {
        while (!this.stop) {
            I2PServerSocket serverSocket = this._util.getServerSocket();
            while (serverSocket == null && !this.stop) {
                if (!this._util.isConnecting() && !this._util.connected()) {
                    this.stop = true;
                    break;
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                serverSocket = this._util.getServerSocket();
            }
            if (this.stop) break;
            try {
                I2PSocket socket = serverSocket.accept();
                if (socket == null) continue;
                if (socket.getPeerDestination().equals(this._util.getMyDestination())) {
                    this._log.error("[I2PSnark] Dropping incoming connection from our own router");
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {}
                    continue;
                }
                Hash h = socket.getPeerDestination().calculateHash();
                if (socket.getLocalPort() == 80) {
                    this._badCounter.increment(h);
                    if (this._log.shouldWarn()) {
                        this._log.warn("[I2PSnark] Dropping incoming HTTP connection from client [" + h.toBase32().substring(0, 8) + "]");
                    }
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {}
                    continue;
                }
                int bad = this._badCounter.count(h);
                if (bad >= 1) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("[I2PSnark] Rejecting incoming connection from client [" + h.toBase32().substring(0, 8) + "] after " + bad + " failures (Max is " + 1 + ")");
                    }
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {}
                    continue;
                }
                I2PAppThread t = new I2PAppThread(new Handler(socket), "I2PSnark incoming connection");
                ((Thread)t).start();
            }
            catch (RouterRestartException rre) {
                I2PAppContext ctx = I2PAppContext.getGlobalContext();
                String msg = "Waiting for I2P router restart...";
                if (this._log.shouldWarn()) {
                    this._log.warn("[I2PSnark] " + msg, rre);
                }
                if (!ctx.isRouterContext()) {
                    System.out.println(" \u2022 " + msg);
                }
                try {
                    Thread.sleep(120000L);
                }
                catch (InterruptedException t) {
                    // empty catch block
                }
                while (!this._util.connected() && !this._util.connect()) {
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                        break;
                    }
                }
                msg = "Router restarted";
                if (this._log.shouldWarn()) {
                    this._log.warn("[I2PSnark] " + msg);
                }
                if (ctx.isRouterContext()) continue;
                System.out.println(" \u2022 " + msg);
            }
            catch (I2PException ioe) {
                int level;
                int n = level = this.stop ? 30 : 40;
                if (this._log.shouldLog(level)) {
                    this._log.log(level, "[I2PSnark] Error while accepting", ioe);
                }
                ConnectionAcceptor connectionAcceptor = this;
                synchronized (connectionAcceptor) {
                    if (!this.stop) {
                        this.locked_halt();
                        this.thread = null;
                        this.stop = true;
                    }
                }
            }
            catch (ConnectException ioe) {
                if (this._log.shouldWarn()) {
                    this._log.warn("[I2PSnark] Error while accepting", ioe);
                }
                ConnectionAcceptor level = this;
                synchronized (level) {
                    if (!this.stop) {
                        this.locked_halt();
                        this.thread = null;
                        this.stop = true;
                    }
                }
            }
            catch (IOException ioe) {
                int level;
                int n = level = this.stop ? 30 : 40;
                if (this._log.shouldLog(level)) {
                    this._log.log(level, "[I2PSnark] Error while accepting", ioe);
                }
                ConnectionAcceptor connectionAcceptor = this;
                synchronized (connectionAcceptor) {
                    if (!this.stop) {
                        this.locked_halt();
                        this.thread = null;
                        this.stop = true;
                    }
                }
            }
        }
        if (this._log.shouldWarn()) {
            this._log.warn("[I2PSnark] ConnectionAcceptor closed");
        }
    }

    private class Cleaner
    extends SimpleTimer2.TimedEvent {
        public Cleaner() {
            super(ConnectionAcceptor.this._util.getContext().simpleTimer2());
        }

        @Override
        public void timeReached() {
            if (ConnectionAcceptor.this.stop) {
                return;
            }
            ConnectionAcceptor.this._badCounter.clear();
            this.schedule(900000L);
        }
    }

    private class Handler
    implements Runnable {
        private final I2PSocket _socket;

        public Handler(I2PSocket socket) {
            this._socket = socket;
        }

        @Override
        public void run() {
            try {
                InputStream in = this._socket.getInputStream();
                OutputStream out = this._socket.getOutputStream();
                in = new BufferedInputStream(in);
                if (ConnectionAcceptor.this._log.shouldDebug()) {
                    ConnectionAcceptor.this._log.debug("[I2PSnark] Handling socket from [" + this._socket.getPeerDestination().calculateHash() + "]");
                }
                ConnectionAcceptor.this.peeracceptor.connection(this._socket, in, out);
            }
            catch (PeerAcceptor.ProtocolException ihe) {
                ConnectionAcceptor.this._badCounter.increment(this._socket.getPeerDestination().calculateHash());
                if (ConnectionAcceptor.this._log.shouldInfo()) {
                    ConnectionAcceptor.this._log.info("[I2PSnark] Protocol error from [" + this._socket.getPeerDestination().calculateHash() + "]", ihe);
                }
                try {
                    this._socket.close();
                }
                catch (IOException iOException) {}
            }
            catch (IOException ioe) {
                if (ConnectionAcceptor.this._log.shouldDebug()) {
                    ConnectionAcceptor.this._log.debug("[I2PSnark] Error handling connection from [" + this._socket.getPeerDestination().calculateHash() + "]", ioe);
                }
                try {
                    this._socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

