/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import gnu.getopt.Getopt;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.i2p.I2PAppContext;
import net.i2p.crypto.SHA1;
import net.i2p.data.DataHelper;
import net.i2p.util.FileUtil;
import net.i2p.util.Log;
import org.klomp.snark.I2PSnarkUtil;
import org.klomp.snark.PartialPiece;
import org.klomp.snark.bencode.BDecoder;
import org.klomp.snark.bencode.BEValue;
import org.klomp.snark.bencode.BEncoder;
import org.klomp.snark.bencode.InvalidBEncodingException;

public class MetaInfo {
    private final Log _log = I2PAppContext.getGlobalContext().logManager().getLog(MetaInfo.class);
    private final String announce;
    private final byte[] info_hash;
    private final String name;
    private final String name_utf8;
    private final List<List<String>> files;
    private final List<List<String>> files_utf8;
    private final List<String> attributes;
    private final List<Long> lengths;
    private final int piece_length;
    private final byte[] piece_hashes;
    private final long length;
    private final int privateTorrent;
    private final List<List<String>> announce_list;
    private final String comment;
    private final String created_by;
    private final long creation_date;
    private final List<String> url_list;
    private Map<String, BEValue> infoMap;
    private int infoBytesLength;

    public MetaInfo(String announce, String name, String name_utf8, List<List<String>> files, List<Long> lengths, int piece_length, byte[] piece_hashes, long length, boolean privateTorrent, List<List<String>> announce_list, String created_by, List<String> url_list, String comment) {
        this.announce = announce;
        this.name = name;
        this.name_utf8 = name_utf8;
        this.files = files == null ? null : Collections.unmodifiableList(files);
        this.files_utf8 = null;
        this.lengths = lengths == null ? null : Collections.unmodifiableList(lengths);
        this.piece_length = piece_length;
        this.piece_hashes = piece_hashes;
        this.length = length;
        this.privateTorrent = privateTorrent ? 1 : 0;
        this.announce_list = announce_list;
        this.comment = comment;
        this.created_by = null;
        this.creation_date = 0L;
        this.url_list = url_list;
        this.attributes = null;
        this.info_hash = this.calculateInfoHash();
    }

    public MetaInfo(String announce, String name, String name_utf8, List<List<String>> files, List<Long> lengths, int piece_length, byte[] piece_hashes, long length, int privateTorrent, List<List<String>> announce_list, String created_by, List<String> url_list, String comment) {
        this.announce = announce;
        this.name = name;
        this.name_utf8 = name_utf8;
        this.files = files == null ? null : Collections.unmodifiableList(files);
        this.files_utf8 = null;
        this.lengths = lengths == null ? null : Collections.unmodifiableList(lengths);
        this.piece_length = piece_length;
        this.piece_hashes = piece_hashes;
        this.length = length;
        this.privateTorrent = privateTorrent;
        this.announce_list = announce_list;
        this.comment = comment;
        this.created_by = created_by;
        this.creation_date = I2PAppContext.getGlobalContext().clock().now();
        this.url_list = url_list;
        this.attributes = null;
        this.info_hash = this.calculateInfoHash();
    }

    public MetaInfo(MetaInfo old, String new_announce, List<List<String>> new_announce_list, String new_comment, String new_created_by, List<String> new_url_list) {
        this.announce = new_announce;
        this.info_hash = old.info_hash;
        this.name = old.name;
        this.name_utf8 = old.name_utf8;
        this.files = old.files;
        this.files_utf8 = old.files_utf8;
        this.attributes = old.attributes;
        this.lengths = old.lengths;
        this.piece_length = old.piece_length;
        this.piece_hashes = old.piece_hashes;
        this.length = old.length;
        this.privateTorrent = old.privateTorrent;
        this.announce_list = new_announce_list;
        this.comment = new_comment;
        this.created_by = null;
        this.creation_date = old.creation_date > 0L ? old.creation_date : I2PAppContext.getGlobalContext().clock().now();
        this.url_list = new_url_list;
        this.infoMap = old.infoMap;
        this.infoBytesLength = old.infoBytesLength;
    }

    public MetaInfo(InputStream in) throws IOException {
        this(new BDecoder(in));
    }

    private MetaInfo(BDecoder be) throws IOException {
        this(be.bdecodeMap().getMap());
        byte[] origInfohash = be.get_special_map_digest();
        if (!DataHelper.eq(origInfohash, this.info_hash)) {
            throw new InvalidBEncodingException("Infohash mismatch, please report");
        }
    }

    public MetaInfo(Map<String, BEValue> m) throws InvalidBEncodingException {
        BEValue val;
        if (this._log.shouldDebug()) {
            this._log.debug("Creating a metaInfo: " + m, new Exception("source"));
        }
        this.announce = (val = m.get("announce")) == null ? null : val.getString();
        val = m.get("announce-list");
        if (val == null) {
            this.announce_list = null;
        } else {
            this.announce_list = new ArrayList<List<String>>();
            List<BEValue> bl1 = val.getList();
            for (BEValue bev : bl1) {
                List<BEValue> bl2 = bev.getList();
                ArrayList<String> sl2 = new ArrayList<String>();
                for (BEValue bev2 : bl2) {
                    sl2.add(bev2.getString());
                }
                this.announce_list.add(sl2);
            }
        }
        val = m.get("url-list");
        if (val == null) {
            this.url_list = null;
        } else {
            List<String> urllist;
            try {
                List<BEValue> bl1 = val.getList();
                urllist = new ArrayList<String>(bl1.size());
                for (BEValue bev : bl1) {
                    urllist.add(bev.getString());
                }
            }
            catch (InvalidBEncodingException ibee) {
                urllist = Collections.singletonList(val.getString());
            }
            this.url_list = urllist;
        }
        val = m.get("comment");
        String st = null;
        if (val != null) {
            try {
                st = val.getString();
            }
            catch (InvalidBEncodingException ibee) {
                // empty catch block
            }
        }
        this.comment = st;
        val = m.get("created by");
        st = null;
        if (val != null) {
            try {
                st = val.getString();
            }
            catch (InvalidBEncodingException ibee) {
                // empty catch block
            }
        }
        this.created_by = st;
        val = m.get("creation date");
        long time = 0L;
        if (val != null) {
            try {
                time = val.getLong() * 1000L;
            }
            catch (InvalidBEncodingException bev) {
                // empty catch block
            }
        }
        this.creation_date = time;
        val = m.get("info");
        if (val == null) {
            throw new InvalidBEncodingException("Missing info map");
        }
        Map<String, BEValue> info = val.getMap();
        this.infoMap = Collections.unmodifiableMap(info);
        val = info.get("name");
        if (val == null) {
            throw new InvalidBEncodingException("Missing name string");
        }
        this.name = val.getString();
        if (this.name.indexOf(47) >= 0) {
            throw new InvalidBEncodingException("Invalid name containing '/' " + this.name);
        }
        val = info.get("name.utf-8");
        this.name_utf8 = val != null ? val.getString() : null;
        val = info.get("private");
        if (val != null) {
            Object o = val.getValue();
            boolean privat = "1".equals(o) || o instanceof Number && ((Number)o).intValue() == 1;
            this.privateTorrent = privat ? 1 : -1;
        } else {
            this.privateTorrent = 0;
        }
        val = info.get("piece length");
        if (val == null) {
            throw new InvalidBEncodingException("Missing piece length number");
        }
        this.piece_length = val.getInt();
        val = info.get("pieces");
        if (val == null) {
            int version;
            val = info.get("meta version");
            if (val != null && (version = val.getInt()) != 1) {
                throw new InvalidBEncodingException("Version " + version + " torrent file not supported");
            }
            throw new InvalidBEncodingException("Missing piece bytes");
        }
        this.piece_hashes = val.getBytes();
        val = info.get("length");
        if (val != null) {
            this.length = val.getLong();
            this.files = null;
            this.files_utf8 = null;
            this.lengths = null;
            this.attributes = null;
        } else {
            val = info.get("files");
            if (val == null) {
                throw new InvalidBEncodingException("Missing length number and/or files list");
            }
            List<BEValue> list = val.getList();
            int size = list.size();
            if (size == 0) {
                throw new InvalidBEncodingException("Zero size files list");
            }
            ArrayList m_files = new ArrayList(size);
            ArrayList m_files_utf8 = null;
            ArrayList<Long> m_lengths = new ArrayList<Long>(size);
            ArrayList<String> m_attributes = null;
            long l = 0L;
            for (int i = 0; i < list.size(); ++i) {
                Map<String, BEValue> desc = list.get(i).getMap();
                val = desc.get("length");
                if (val == null) {
                    throw new InvalidBEncodingException("Missing length number");
                }
                long len = val.getLong();
                if (len < 0L) {
                    throw new InvalidBEncodingException("Negative file length");
                }
                m_lengths.add(len);
                long oldTotal = l;
                if ((l += len) < oldTotal) {
                    throw new InvalidBEncodingException("Huge total length");
                }
                val = desc.get("path");
                if (val == null) {
                    throw new InvalidBEncodingException("Missing path list");
                }
                List<BEValue> path_list = val.getList();
                int path_length = path_list.size();
                if (path_length == 0) {
                    throw new InvalidBEncodingException("Zero size file path list");
                }
                ArrayList<String> file = new ArrayList<String>(path_length);
                Iterator<BEValue> it = path_list.iterator();
                while (it.hasNext()) {
                    String s = it.next().getString();
                    if (s.indexOf(47) >= 0) {
                        s = s.replace("/", "_");
                    }
                    file.add(s);
                }
                for (int j = 0; j < i; ++j) {
                    if (!file.equals(m_files.get(j))) continue;
                    throw new InvalidBEncodingException("Duplicate file path " + DataHelper.toString(file));
                }
                m_files.add(Collections.unmodifiableList(file));
                val = desc.get("path.utf-8");
                if (val != null) {
                    m_files_utf8 = new ArrayList(size);
                    path_list = val.getList();
                    path_length = path_list.size();
                    if (path_length > 0) {
                        file = new ArrayList(path_length);
                        it = path_list.iterator();
                        while (it.hasNext()) {
                            file.add(it.next().getString());
                        }
                        m_files_utf8.add(Collections.unmodifiableList(file));
                    }
                }
                if ((val = desc.get("attr")) != null) {
                    String s = val.getString();
                    if (m_attributes != null) continue;
                    m_attributes = new ArrayList<String>(size);
                    for (int j = 0; j < i; ++j) {
                        m_attributes.add("");
                    }
                    m_attributes.add(s);
                    continue;
                }
                if (m_attributes == null) continue;
                m_attributes.add("");
            }
            this.files = Collections.unmodifiableList(m_files);
            this.files_utf8 = m_files_utf8 != null ? Collections.unmodifiableList(m_files_utf8) : null;
            this.lengths = Collections.unmodifiableList(m_lengths);
            this.length = l;
            this.attributes = m_attributes;
        }
        this.info_hash = this.calculateInfoHash();
    }

    public static String getNameAndInfoHash(InputStream in, byte[] infoHashOut) throws IOException {
        BDecoder bd = new BDecoder(in);
        Map<String, BEValue> m = bd.bdecodeMap().getMap();
        BEValue ibev = m.get("info");
        if (ibev == null) {
            throw new InvalidBEncodingException("Missing info map");
        }
        Map<String, BEValue> i = ibev.getMap();
        BEValue rvbev = i.get("name");
        if (rvbev == null) {
            throw new InvalidBEncodingException("Missing name");
        }
        byte[] h = bd.get_special_map_digest();
        System.arraycopy(h, 0, infoHashOut, 0, 20);
        return rvbev.getString();
    }

    public String getAnnounce() {
        return this.announce;
    }

    public List<List<String>> getAnnounceList() {
        return this.announce_list;
    }

    public List<String> getWebSeedURLs() {
        return this.url_list;
    }

    public byte[] getInfoHash() {
        return this.info_hash;
    }

    public byte[] getPieceHashes() {
        return this.piece_hashes;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPrivate() {
        return this.privateTorrent > 0;
    }

    public int getPrivateTrackerStatus() {
        return this.privateTorrent;
    }

    public List<List<String>> getFiles() {
        return this.files;
    }

    public boolean isPaddingFile(int filenum) {
        if (this.attributes == null) {
            return false;
        }
        return this.attributes.get(filenum).indexOf(112) >= 0;
    }

    public List<Long> getLengths() {
        return this.lengths;
    }

    public String getComment() {
        return this.comment;
    }

    public String getCreatedBy() {
        return this.created_by;
    }

    public long getCreationDate() {
        return this.creation_date;
    }

    public int getPieces() {
        return this.piece_hashes.length / 20;
    }

    public int getPieceLength(int piece) {
        int pieces = this.getPieces();
        if (piece >= 0 && piece < pieces - 1) {
            return this.piece_length;
        }
        if (piece == pieces - 1) {
            return (int)(this.length - (long)piece * (long)this.piece_length);
        }
        throw new IndexOutOfBoundsException("No piece: " + piece);
    }

    public boolean checkPiece(int piece, byte[] bs, int off, int length) {
        return this.fast_checkPiece(piece, bs, off, length);
    }

    private boolean fast_checkPiece(int piece, byte[] bs, int off, int length) {
        MessageDigest sha1 = SHA1.getInstance();
        sha1.update(bs, off, length);
        byte[] hash = sha1.digest();
        for (int i = 0; i < 20; ++i) {
            if (hash[i] == this.piece_hashes[20 * piece + i]) continue;
            return false;
        }
        return true;
    }

    boolean checkPiece(PartialPiece pp) {
        byte[] hash;
        int piece = pp.getPiece();
        try {
            hash = pp.getHash();
        }
        catch (IOException ioe) {
            if (this._log.shouldDebug()) {
                this._log.debug("Error checking piece [" + piece + "] for " + this.name);
            }
            return false;
        }
        for (int i = 0; i < 20; ++i) {
            if (hash[i] == this.piece_hashes[20 * piece + i]) continue;
            return false;
        }
        return true;
    }

    public long getTotalLength() {
        return this.length;
    }

    public String toString() {
        return "MetaInfo for: " + this.name + "\n* InfoHash: " + I2PSnarkUtil.toHex(this.info_hash) + "\n* Announce: " + this.announce + "\n* Size: " + this.length + " bytes, Files: " + this.files + ", Pieces: " + this.piece_hashes.length / 20 + ", Piece Length: " + this.piece_length + " bytes";
    }

    public MetaInfo reannounce(String announce) throws InvalidBEncodingException {
        HashMap<String, BEValue> m = new HashMap<String, BEValue>();
        if (announce != null) {
            m.put("announce", new BEValue(DataHelper.getUTF8(announce)));
        }
        Map<String, BEValue> info = this.createInfoMap();
        m.put("info", new BEValue(info));
        return new MetaInfo(m);
    }

    public synchronized byte[] getTorrentData() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        if (this.announce != null) {
            m.put("announce", this.announce);
        }
        if (this.announce_list != null) {
            m.put("announce-list", this.announce_list);
        }
        if (this.url_list != null) {
            m.put("url-list", this.url_list);
        }
        if (this.comment != null) {
            m.put("comment", this.comment);
        }
        if (this.created_by != null) {
            m.put("created by", this.created_by);
        }
        if (this.creation_date != 0L) {
            m.put("creation date", this.creation_date / 1000L);
        }
        Map<String, BEValue> info = this.createInfoMap();
        m.put("info", info);
        return BEncoder.bencode(m);
    }

    public synchronized byte[] getInfoBytes() {
        if (this.infoMap == null) {
            this.createInfoMap();
        }
        byte[] rv = BEncoder.bencode(this.infoMap);
        this.infoBytesLength = rv.length;
        return rv;
    }

    public synchronized int getInfoBytesLength() {
        if (this.infoBytesLength > 0) {
            return this.infoBytesLength;
        }
        return this.getInfoBytes().length;
    }

    private Map<String, BEValue> createInfoMap() {
        if (this.infoMap != null) {
            return Collections.unmodifiableMap(this.infoMap);
        }
        if (this._log.shouldDebug()) {
            this._log.debug("Creating new infomap", new Exception());
        }
        HashMap<String, BEValue> info = new HashMap<String, BEValue>();
        info.put("name", new BEValue(DataHelper.getUTF8(this.name)));
        if (this.name_utf8 != null) {
            info.put("name.utf-8", new BEValue(DataHelper.getUTF8(this.name_utf8)));
        }
        if (this.privateTorrent != 0) {
            info.put("private", new BEValue(this.privateTorrent > 0 ? 1 : 0));
        }
        info.put("piece length", new BEValue(this.piece_length));
        info.put("pieces", new BEValue(this.piece_hashes));
        if (this.files == null) {
            info.put("length", new BEValue(this.length));
        } else {
            ArrayList<BEValue> l = new ArrayList<BEValue>();
            for (int i = 0; i < this.files.size(); ++i) {
                HashMap<String, BEValue> file = new HashMap<String, BEValue>();
                List<String> fi = this.files.get(i);
                ArrayList<BEValue> befiles = new ArrayList<BEValue>(fi.size());
                for (int j = 0; j < fi.size(); ++j) {
                    befiles.add(new BEValue(DataHelper.getUTF8(fi.get(j))));
                }
                file.put("path", new BEValue(befiles));
                if (this.files_utf8 != null && this.files_utf8.size() > i) {
                    List<String> fiu = this.files_utf8.get(i);
                    ArrayList<BEValue> beufiles = new ArrayList<BEValue>(fiu.size());
                    for (int j = 0; j < fiu.size(); ++j) {
                        beufiles.add(new BEValue(DataHelper.getUTF8(fiu.get(j))));
                    }
                    file.put("path.utf-8", new BEValue(beufiles));
                }
                file.put("length", new BEValue(this.lengths.get(i)));
                String attr = null;
                if (this.attributes != null && (attr = this.attributes.get(i)).length() > 0) {
                    file.put("attr", new BEValue(DataHelper.getASCII(attr)));
                }
                l.add(new BEValue(file));
            }
            info.put("files", new BEValue(l));
        }
        this.infoMap = info;
        return Collections.unmodifiableMap(this.infoMap);
    }

    private byte[] calculateInfoHash() {
        Map<String, BEValue> info = this.createInfoMap();
        if (this._log.shouldDebug()) {
            StringBuilder buf = new StringBuilder(128);
            buf.append("info: ");
            for (Map.Entry<String, BEValue> entry : info.entrySet()) {
                String key = entry.getKey();
                BEValue val = entry.getValue();
                buf.append(key).append('=');
                buf.append(((Object)val).toString());
            }
            this._log.debug(buf.toString());
        }
        byte[] infoBytes = BEncoder.bencode(info);
        MessageDigest digest = SHA1.getInstance();
        byte[] hash = digest.digest(infoBytes);
        if (this._log.shouldDebug()) {
            this._log.debug("[InfoHash " + I2PSnarkUtil.toHex(hash) + "]");
        }
        return hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        boolean error = false;
        String created_by = null;
        String announce = null;
        ArrayList<String> url_list = null;
        String comment = null;
        Getopt g = new Getopt("Storage", args, "a:c:m:w:");
        try {
            int c;
            block25: while ((c = g.getopt()) != -1) {
                switch (c) {
                    case 97: {
                        announce = g.getOptarg();
                        continue block25;
                    }
                    case 99: {
                        created_by = g.getOptarg();
                        continue block25;
                    }
                    case 109: {
                        comment = g.getOptarg();
                        continue block25;
                    }
                    case 119: {
                        if (url_list == null) {
                            url_list = new ArrayList<String>();
                        }
                        url_list.add(g.getOptarg());
                        continue block25;
                    }
                }
                error = true;
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            error = true;
        }
        if (error || args.length - g.getOptind() <= 0) {
            System.err.println("Usage: MetaInfo [-a announceURL] [-c created-by] [-m comment] [-w webseed-url]* file.torrent [file2.torrent...]");
            System.exit(1);
        }
        for (int i = g.getOptind(); i < args.length; ++i) {
            FileInputStream in = null;
            OutputStream out = null;
            try {
                in = new FileInputStream(args[i]);
                MetaInfo meta = new MetaInfo(in);
                System.out.println(args[i] + "\nInfoHash:     " + I2PSnarkUtil.toHex(meta.getInfoHash()) + "\nAnnounce:     " + meta.getAnnounce() + "\nWebSeed URLs: " + meta.getWebSeedURLs() + "\nCreated By:   " + meta.getCreatedBy() + "\nComment:      " + meta.getComment());
                if (created_by == null && announce == null && url_list == null && comment == null) continue;
                String cb = created_by != null ? created_by : meta.getCreatedBy();
                String an = announce != null ? announce : meta.getAnnounce();
                String cm = comment != null ? comment : meta.getComment();
                ArrayList<String> urls = url_list != null ? url_list : meta.getWebSeedURLs();
                MetaInfo meta2 = new MetaInfo(meta, an, meta.getAnnounceList(), cm, cb, urls);
                File from = new File(args[i]);
                File to = new File(args[i] + ".bak");
                if (FileUtil.copy(from, to, true, false)) {
                    out = new FileOutputStream(from);
                    out.write(meta2.getTorrentData());
                    out.close();
                    System.out.println("Modified " + from + " and backed up old file to " + to);
                    System.out.println(args[i] + "\nInfoHash:     " + I2PSnarkUtil.toHex(meta2.getInfoHash()) + "\nAnnounce:     " + meta2.getAnnounce() + "\nWebSeed URLs: " + meta2.getWebSeedURLs() + "\nCreated By:   " + meta2.getCreatedBy() + "\nComment:      " + meta2.getComment());
                    continue;
                }
                System.out.println("Failed backup of " + from + " to " + to);
                continue;
            }
            catch (IOException ioe) {
                System.err.println("Error in file " + args[i] + ": " + ioe);
                continue;
            }
            finally {
                try {
                    if (in != null) {
                        ((InputStream)in).close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }
}

